/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.base.ui.markuphelp;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.docmlet.base.ui.markuphelp.MarkupHelpContent;
import org.eclipse.statet.docmlet.base.ui.markuphelp.MarkupHelpContextProvider;
import org.eclipse.statet.docmlet.base.ui.markuphelp.MarkupHelpView;
import org.eclipse.statet.ecommons.commands.core.HandlerCollection;
import org.eclipse.statet.ecommons.ui.actions.SimpleContributionItem;
import org.eclipse.statet.ecommons.ui.swt.util.CssUtils;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.ecommons.ui.workbench.WorkbenchUIUtils;
import org.eclipse.statet.internal.docmlet.base.ui.DocmlBaseUIPlugin;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.util.HtmlUtils;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.statushandlers.StatusManager;

@NonNullByDefault
public class DocmletMarkupHelpView
extends ViewPart
implements MarkupHelpView {
    private Composite composite;
    private StackLayout compositeLayout;
    private Browser browser;
    private @Nullable IPartListener2 partListener;
    private @Nullable MarkupHelpContent currentContent;
    private String lastHtml;

    public void createPartControl(Composite parent) {
        this.composite = parent;
        this.compositeLayout = new StackLayout();
        parent.setLayout((Layout)this.compositeLayout);
        this.browser = new Browser(parent, 0);
        this.browser.setLayoutData((Object)new GridData(4, 4, true, true));
        this.browser.addOpenWindowListener(new OpenWindowListener(){

            public void open(WindowEvent event) {
                event.browser = DocmletMarkupHelpView.this.browser;
            }
        });
        this.browser.addLocationListener(new LocationListener(){

            public void changing(LocationEvent event) {
                if (event.location != null && !event.location.startsWith("about:")) {
                    DocmletMarkupHelpView.this.openExternal(event.location);
                    event.doit = false;
                }
            }

            public void changed(LocationEvent event) {
            }
        });
        IViewSite site = this.getViewSite();
        this.initActions((IServiceLocator)site, null);
        this.contributeToActionBars((IServiceLocator)site, site.getActionBars(), null);
        this.initLinking();
    }

    private void initLinking() {
        IPartListener2 partListener = new IPartListener2(){

            public void partVisible(IWorkbenchPartReference partRef) {
            }

            public void partOpened(IWorkbenchPartReference partRef) {
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }

            public void partHidden(IWorkbenchPartReference partRef) {
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
            }

            public void partClosed(IWorkbenchPartReference partRef) {
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
            }

            public void partActivated(IWorkbenchPartReference partRef) {
                IWorkbenchPart part = partRef.getPart(false);
                if (part instanceof IEditorPart) {
                    DocmletMarkupHelpView.this.activated((IEditorPart)part);
                }
            }
        };
        this.getSite().getPage().addPartListener(partListener);
        this.partListener = partListener;
        UIAccess.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IEditorPart editor = DocmletMarkupHelpView.this.getSite().getPage().getActiveEditor();
                if (editor != null) {
                    DocmletMarkupHelpView.this.activated(editor);
                }
            }
        });
    }

    protected void initActions(IServiceLocator serviceLocator, HandlerCollection handlers) {
    }

    protected void contributeToActionBars(IServiceLocator serviceLocator, IActionBars actionBars, HandlerCollection handlers) {
        IMenuManager menuManager = actionBars.getMenuManager();
        ImList<MarkupHelpContent> topics = DocmlBaseUIPlugin.getInstance().getMarkupHelpManager().getTopicList();
        for (MarkupHelpContent topic : topics) {
            menuManager.add((IContributionItem)new SimpleContributionItem(topic.getTitle(), null, topic){
                final String topicId;
                {
                    this.topicId = markupHelpContent.getId();
                }

                protected void execute(Event event) throws ExecutionException {
                    DocmletMarkupHelpView.this.show(this.topicId);
                }
            });
        }
    }

    public void dispose() {
        this.partListener = WorkbenchUIUtils.removeListener((IPartService)this.getSite().getPage(), (IPartListener2)this.partListener);
        super.dispose();
    }

    private void activated(IEditorPart editor) {
        String contentId;
        MarkupHelpContextProvider contextProvider = (MarkupHelpContextProvider)editor.getAdapter(MarkupHelpContextProvider.class);
        if (contextProvider != null && (contentId = contextProvider.getHelpContentId()) != null) {
            this.show(contentId);
        }
    }

    public void setFocus() {
        this.browser.setFocus();
    }

    @Override
    public void show(String id) {
        MarkupHelpContent content = DocmlBaseUIPlugin.getInstance().getMarkupHelpManager().getContent(id);
        if (content != null) {
            this.setContent(content);
        }
    }

    private void setContent(MarkupHelpContent content) {
        try {
            String html = content.getContent();
            this.currentContent = content;
            this.setHtmlContent(html, this.createCss());
        }
        catch (IOException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.docmlet.base.ui", 0, NLS.bind((String)"An error occurred while loading markup help content {0}).", (Object)content), (Throwable)e));
            DocmlBaseUIPlugin.getInstance().getMarkupHelpManager().disable(content.getId());
        }
    }

    private void setHtmlContent(String html, @Nullable String css) {
        if (css != null) {
            html = HtmlUtils.insertCssStylesheet((String)html, (String)css);
        }
        if (!html.equals(this.lastHtml)) {
            this.lastHtml = html;
            this.browser.setText(html);
        }
        if (this.compositeLayout.topControl != this.browser) {
            this.compositeLayout.topControl = this.browser;
            this.composite.layout(true);
        }
    }

    private String createCss() {
        RGB docBackgroundColor = JFaceResources.getColorRegistry().getRGB("org.eclipse.statet.workbench.themes.DocViewBackgroundColor");
        RGB foregroundColor = JFaceResources.getColorRegistry().getRGB("org.eclipse.statet.workbench.themes.DocViewColor");
        FontDescriptor docFontDescr = JFaceResources.getFontDescriptor((String)"org.eclipse.statet.workbench.themes.DocViewFont");
        FontData fontData = docFontDescr.getFontData()[0];
        CssUtils.StylesheetBuilder css = new CssUtils.StylesheetBuilder();
        css.addRuleset("body").addFontFamily(fontData, "sans-serif").addFontSize(fontData, 10).addBackground(docBackgroundColor).addColor(foregroundColor).addMargin(LayoutUtils.defaultVSpacing(), LayoutUtils.defaultHSpacing());
        css.addRuleset("table, tr, th, td ").addFontSize(fontData, 10);
        css.append("h4 { margin-bottom: 0.66em; }\npre { margin-top: 0.66em; margin-bottom: 0.66em; }\n");
        return css.build();
    }

    private void openExternal(String location) {
        IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
        try {
            IWebBrowser externalBrowser = browserSupport.createBrowser(14, "org.eclipse.statet.docmlet.base.MarkupHelp", null, null);
            URL url = new URL(location);
            externalBrowser.openURL(url);
        }
        catch (Exception e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.docmlet.base.ui", 0, "An error occurred while opening the page in an external browser.", (Throwable)e));
        }
    }
}

