/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.actions;

import java.util.Collections;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.HandlerEvent;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.bindings.BindingManagerEvent;
import org.eclipse.jface.bindings.IBindingManagerListener;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.commands.core.HandlerCollection;
import org.eclipse.statet.ecommons.ui.util.MenuUtils;
import org.eclipse.statet.ecommons.ui.workbench.WorkbenchUIUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.util.StringUtils;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.commands.ICommandImageService;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementReference;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.internal.services.IWorkbenchLocationService;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.statushandlers.StatusManager;

@NonNullByDefault
public class HandlerContributionItem
extends ContributionItem {
    public static final String NO_COMMAND_ID = "NO_COMMAND";
    public static final int STYLE_PUSH = 8;
    public static final int STYLE_CHECK = 32;
    public static final int STYLE_RADIO = 16;
    public static final int STYLE_PULLDOWN = 4;
    public static final int MODE_FORCE_TEXT = 1;
    private static final int MODE_NO_COMMAND = 0x10000000;
    private static final int MODE_CALLBACK_CALL = 0x1000000;
    private static final int MODE_CALLBACK_EXPL = 0x2000000;
    private LocalResourceManager localResourceManager;
    private @Nullable Widget widget;
    private @Nullable Listener menuItemListener;
    private IMenuService menuService;
    private final IServiceLocator serviceLocator;
    private ICommandService commandService;
    private IHandlerService handlerService;
    private IBindingService bindingService;
    protected final Display display;
    private @Nullable ParameterizedCommand command;
    private IHandler2 commandHandler;
    private @Nullable String label;
    private @Nullable String mnemonic;
    private @Nullable String tooltip;
    private @Nullable ImageDescriptor icon;
    private @Nullable ImageDescriptor disabledIcon;
    private @Nullable ImageDescriptor hoverIcon;
    private IElementReference elementRef;
    private boolean checkedState;
    private int style;
    private IHandlerListener commandListener;
    private @Nullable String dropDownMenuOverride;
    private @Nullable IWorkbenchHelpSystem workbenchHelpSystem;
    private @Nullable String helpContextId;
    private int mode = 0;
    private boolean visibleEnabled;
    private @Nullable String contributedLabel;
    private @Nullable String contributedTooltip;
    private @Nullable ImageDescriptor contributedIcon;
    private @Nullable ImageDescriptor contributedDisabledIcon;
    private @Nullable ImageDescriptor contributedHoverIcon;
    private final @Nullable UIElement callback;
    private final IBindingManagerListener bindingManagerListener = new IBindingManagerListener(){

        public void bindingManagerChanged(BindingManagerEvent event) {
            if (event.isActiveBindingsChanged() && event.isActiveBindingsChangedFor(HandlerContributionItem.this.getCommand())) {
                HandlerContributionItem.this.update();
            }
        }
    };

    public HandlerContributionItem(CommandContributionItemParameter contributionParameters, IHandler2 handler) {
        super(contributionParameters.id);
        this.serviceLocator = (IServiceLocator)ObjectUtils.nonNullAssert((Object)contributionParameters.serviceLocator);
        this.contributedLabel = this.label = contributionParameters.label;
        this.mnemonic = contributionParameters.mnemonic;
        this.contributedTooltip = this.tooltip = contributionParameters.tooltip;
        this.contributedIcon = this.icon = contributionParameters.icon;
        this.contributedDisabledIcon = this.disabledIcon = contributionParameters.disabledIcon;
        this.contributedHoverIcon = this.hoverIcon = contributionParameters.hoverIcon;
        this.style = contributionParameters.style;
        this.helpContextId = contributionParameters.helpContextId;
        this.visibleEnabled = contributionParameters.visibleEnabled;
        try {
            this.menuService = (IMenuService)this.serviceLocator.getService(IMenuService.class);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.commandService = (ICommandService)this.serviceLocator.getService(ICommandService.class);
        this.handlerService = (IHandlerService)this.serviceLocator.getService(IHandlerService.class);
        this.bindingService = (IBindingService)this.serviceLocator.getService(IBindingService.class);
        IWorkbenchLocationService workbenchLocationService = (IWorkbenchLocationService)this.serviceLocator.getService(IWorkbenchLocationService.class);
        this.display = workbenchLocationService.getWorkbench().getDisplay();
        this.createCommand(contributionParameters.commandId, contributionParameters.parameters);
        this.commandHandler = (IHandler2)ObjectUtils.nonNullAssert((Object)handler);
        UIElement uIElement = this.callback = handler instanceof IElementUpdater ? new UIElement(contributionParameters.serviceLocator){

            private boolean beginCallback() {
                if ((HandlerContributionItem.this.mode & 0x12000000) != 0 || WorkbenchUIUtils.isCommandElementsUpdater(HandlerContributionItem.this.commandHandler) || HandlerContributionItem.this.command.getCommand().getHandler() == HandlerContributionItem.this.commandHandler) {
                    HandlerContributionItem.this.mode |= 0x1000000;
                    return true;
                }
                return false;
            }

            private void endCallback() {
                HandlerContributionItem.this.mode &= 0xFEFFFFFF;
            }

            public void setText(@Nullable String text) {
                if (this.beginCallback()) {
                    try {
                        HandlerContributionItem.this.setText(text);
                    }
                    finally {
                        this.endCallback();
                    }
                }
            }

            public void setTooltip(@Nullable String text) {
                if (this.beginCallback()) {
                    try {
                        HandlerContributionItem.this.setTooltip(text);
                    }
                    finally {
                        this.endCallback();
                    }
                }
            }

            public void setIcon(@Nullable ImageDescriptor desc) {
                if (this.beginCallback()) {
                    try {
                        HandlerContributionItem.this.setIcon(desc);
                    }
                    finally {
                        this.endCallback();
                    }
                }
            }

            public void setDisabledIcon(@Nullable ImageDescriptor desc) {
                if (this.beginCallback()) {
                    try {
                        HandlerContributionItem.this.setDisabledIcon(desc);
                    }
                    finally {
                        this.endCallback();
                    }
                }
            }

            public void setHoverIcon(@Nullable ImageDescriptor desc) {
                if (this.beginCallback()) {
                    try {
                        HandlerContributionItem.this.setHoverIcon(desc);
                    }
                    finally {
                        this.endCallback();
                    }
                }
            }

            public void setChecked(boolean checked) {
                if (this.beginCallback()) {
                    try {
                        HandlerContributionItem.this.setChecked(checked);
                    }
                    finally {
                        this.endCallback();
                    }
                }
            }

            public void setDropDownId(String id) {
                if (this.beginCallback()) {
                    try {
                        HandlerContributionItem.this.dropDownMenuOverride = id;
                    }
                    finally {
                        this.endCallback();
                    }
                }
            }
        } : null;
        if (this.command != null) {
            this.setImages(contributionParameters.serviceLocator, contributionParameters.iconStyle);
        }
    }

    public HandlerContributionItem(CommandContributionItemParameter contributionParameters, HandlerCollection handlers) {
        this(contributionParameters, handlers.get(contributionParameters.commandId));
    }

    protected IServiceLocator getServiceLocator() {
        return this.serviceLocator;
    }

    private void setImages(IServiceLocator locator, String iconStyle) {
        if (this.icon == null && this.command != null) {
            ICommandImageService service = (ICommandImageService)locator.getService(ICommandImageService.class);
            this.icon = service.getImageDescriptor(this.command.getId(), 0, iconStyle);
            this.disabledIcon = service.getImageDescriptor(this.command.getId(), 1, iconStyle);
            this.hoverIcon = service.getImageDescriptor(this.command.getId(), 2, iconStyle);
            if (this.contributedIcon == null) {
                this.contributedIcon = this.icon;
            }
            if (this.contributedDisabledIcon == null) {
                this.contributedDisabledIcon = this.disabledIcon;
            }
            if (this.contributedHoverIcon == null) {
                this.contributedHoverIcon = this.hoverIcon;
            }
        }
    }

    private IHandlerListener getHandlerListener() {
        if (this.commandListener == null) {
            this.commandListener = new IHandlerListener(){

                public void handlerChanged(HandlerEvent commandEvent) {
                    if (commandEvent.isHandledChanged() || commandEvent.isEnabledChanged()) {
                        HandlerContributionItem.this.updateCommandProperties(commandEvent);
                    }
                }
            };
        }
        return this.commandListener;
    }

    private void updateCommandProperties(HandlerEvent commandEvent) {
        if (commandEvent.isHandledChanged()) {
            this.dropDownMenuOverride = null;
        }
        Runnable update = new Runnable(){

            @Override
            public void run() {
                HandlerContributionItem.this.update(null);
            }
        };
        if (this.display.getThread() == Thread.currentThread()) {
            update.run();
        } else {
            this.display.asyncExec(update);
        }
    }

    public @Nullable ParameterizedCommand getCommand() {
        return this.command;
    }

    void createCommand(@Nullable String commandId, @Nullable Map parameters) {
        if (commandId == null) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ecommons.uimisc", "Unable to create menu item \"" + this.getId() + "\", no command id"));
            return;
        }
        if (commandId == NO_COMMAND_ID) {
            this.mode |= 0x10000000;
            return;
        }
        Command cmd = this.commandService.getCommand(commandId);
        if (!cmd.isDefined()) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ecommons.uimisc", "Unable to create menu item \"" + this.getId() + "\", command \"" + commandId + "\" not defined"));
            return;
        }
        this.command = ParameterizedCommand.generateCommand((Command)cmd, (Map)parameters);
    }

    public CommandContributionItemParameter getData() {
        CommandContributionItemParameter data = new CommandContributionItemParameter(this.serviceLocator, this.getId(), null, this.style);
        data.label = this.contributedLabel;
        data.mnemonic = this.mnemonic;
        data.tooltip = this.contributedTooltip;
        data.icon = this.contributedIcon;
        data.disabledIcon = this.contributedDisabledIcon;
        data.hoverIcon = this.contributedHoverIcon;
        data.helpContextId = this.helpContextId;
        return data;
    }

    public void fill(Menu parent, int index) {
        if (this.command == null && (this.mode & 0x10000000) == 0) {
            return;
        }
        if (this.widget != null || parent == null) {
            return;
        }
        int tmpStyle = this.style;
        if (tmpStyle == 4) {
            tmpStyle = 8;
        }
        MenuItem item = null;
        item = index >= 0 ? new MenuItem(parent, tmpStyle, index) : new MenuItem(parent, tmpStyle);
        item.setData((Object)this);
        if (this.workbenchHelpSystem != null) {
            this.workbenchHelpSystem.setHelp(item, this.helpContextId);
        }
        item.addListener(12, this.getItemListener());
        item.addListener(13, this.getItemListener());
        this.widget = item;
        this.update(null);
        this.updateIcons();
        this.establishReferences();
    }

    public void fill(ToolBar parent, int index) {
        if (this.command == null && (this.mode & 0x10000000) == 0) {
            return;
        }
        if (this.widget != null || parent == null) {
            return;
        }
        ToolItem item = null;
        item = index >= 0 ? new ToolItem(parent, this.style, index) : new ToolItem(parent, this.style);
        item.setData((Object)this);
        item.addListener(13, this.getItemListener());
        item.addListener(12, this.getItemListener());
        this.widget = item;
        this.update(null);
        this.updateIcons();
        this.establishReferences();
    }

    public void fill(Composite parent) {
        if (this.command == null && (this.mode & 0x10000000) == 0) {
            return;
        }
        if (this.widget != null || parent == null) {
            return;
        }
        int tmpStyle = this.style;
        if (tmpStyle == 4) {
            tmpStyle = 8;
        }
        Button item = new Button(parent, tmpStyle);
        item.setData((Object)this);
        if (this.workbenchHelpSystem != null) {
            this.workbenchHelpSystem.setHelp((Control)item, this.helpContextId);
        }
        item.addListener(12, this.getItemListener());
        item.addListener(13, this.getItemListener());
        this.widget = item;
        this.update(null);
        this.updateIcons();
        this.establishReferences();
    }

    public void update() {
        this.update(null);
    }

    public void update(@Nullable String id) {
        if (this.widget != null) {
            if ((this.mode & 0x2000000) != 0) {
                return;
            }
            if ((this.mode & 0x11000000) == 0x10000000 && this.callback != null) {
                this.mode |= 0x2000000;
                try {
                    this.label = this.contributedLabel;
                    this.tooltip = this.contributedTooltip;
                    this.icon = this.contributedIcon;
                    this.disabledIcon = this.contributedDisabledIcon;
                    this.hoverIcon = this.contributedHoverIcon;
                    ((IElementUpdater)this.commandHandler).updateElement(this.callback, Collections.EMPTY_MAP);
                }
                finally {
                    this.mode &= 0xFDFFFFFF;
                }
            }
            if (this.widget instanceof MenuItem) {
                this.updateMenuItem((MenuItem)this.widget);
            } else if (this.widget instanceof ToolItem) {
                this.updateToolItem((ToolItem)this.widget);
            } else if (this.widget instanceof Button) {
                this.updateButton((Button)this.widget);
            }
        }
    }

    private void updateMenuItem(MenuItem item) {
        TriggerSequence binding;
        boolean shouldBeEnabled = this.isEnabled();
        if (item.isDisposed()) {
            return;
        }
        String text = this.label;
        if (text == null && this.command != null) {
            try {
                text = this.command.getCommand().getName();
            }
            catch (NotDefinedException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ecommons.uimisc", "Update item failed " + this.getId(), (Throwable)e));
            }
        }
        text = this.updateMnemonic(text);
        String keyBindingText = null;
        if (this.command != null && (binding = this.bindingService.getBestActiveBindingFor(this.command)) != null) {
            keyBindingText = binding.format();
        }
        if (text != null) {
            if (keyBindingText == null) {
                item.setText(text);
            } else {
                item.setText(text + "\t" + keyBindingText);
            }
        }
        if (item.getSelection() != this.checkedState) {
            item.setSelection(this.checkedState);
        }
        if (item.getEnabled() != shouldBeEnabled) {
            item.setEnabled(shouldBeEnabled);
        }
    }

    private void updateToolItem(ToolItem item) {
        boolean shouldBeEnabled = this.isEnabled();
        if (item.isDisposed()) {
            return;
        }
        String text = this.label;
        if (text == null && this.command != null) {
            try {
                text = this.command.getCommand().getName();
            }
            catch (NotDefinedException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ecommons.uimisc", "Update item failed " + this.getId(), (Throwable)e));
            }
        }
        if ((this.icon == null || (this.mode & 1) != 0) && text != null) {
            item.setText(text);
        }
        String toolTipText = this.getToolTipText(text);
        item.setToolTipText(toolTipText);
        if (item.getSelection() != this.checkedState) {
            item.setSelection(this.checkedState);
        }
        if (item.getEnabled() != shouldBeEnabled) {
            item.setEnabled(shouldBeEnabled);
        }
    }

    private void updateButton(Button item) {
        boolean shouldBeEnabled = this.isEnabled();
        if (item.isDisposed()) {
            return;
        }
        String text = this.label;
        if (text == null && this.command != null) {
            try {
                text = this.command.getCommand().getName();
            }
            catch (NotDefinedException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ecommons.uimisc", "Update item failed " + this.getId(), (Throwable)e));
            }
        }
        if (text != null) {
            item.setText(text);
        }
        String toolTipText = this.getToolTipText(text);
        item.setToolTipText(toolTipText);
        if (item.getSelection() != this.checkedState) {
            item.setSelection(this.checkedState);
        }
        if (item.getEnabled() != shouldBeEnabled) {
            item.setEnabled(shouldBeEnabled);
        }
    }

    private String getToolTipText(@Nullable String text) {
        String acceleratorText;
        TriggerSequence activeBinding;
        String tooltipText = this.tooltip;
        if (tooltipText == null) {
            tooltipText = text != null ? text : "";
        }
        if (this.command != null && (activeBinding = this.bindingService.getBestActiveBindingFor(this.command)) != null && !activeBinding.isEmpty() && (acceleratorText = activeBinding.format()) != null && acceleratorText.length() != 0) {
            tooltipText = NLS.bind((String)"{0} ({1})", (Object)tooltipText, (Object)acceleratorText);
        }
        return tooltipText;
    }

    private String updateMnemonic(String s) {
        if (this.mnemonic == null || s == null) {
            return s;
        }
        int idx = s.indexOf(this.mnemonic);
        if (idx < 0) {
            return s;
        }
        return StringUtils.insert((String)s, (int)idx, (char)'&');
    }

    private void handleWidgetDispose(Event event) {
        if (event.widget == this.widget) {
            this.disconnectReferences();
            this.widget.removeListener(13, this.getItemListener());
            this.widget.removeListener(12, this.getItemListener());
            this.widget = null;
            this.disposeOldImages();
        }
    }

    private void establishReferences() {
        if (this.command != null || (this.mode & 0x10000000) != 0) {
            this.commandHandler.addHandlerListener(this.getHandlerListener());
        }
        if (this.command != null && this.callback != null) {
            WorkbenchUIUtils.registerCommandElement(this.command.getId(), this.callback);
            try {
                this.elementRef = this.commandService.registerElementForCommand(this.command, this.callback);
            }
            catch (NotDefinedException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ecommons.uimisc", "Unable to register menu item \"" + this.getId() + "\", command \"" + this.command.getId() + "\" not defined"));
            }
        }
        this.bindingService.addBindingManagerListener(this.bindingManagerListener);
    }

    private void disconnectReferences() {
        if (this.bindingService != null) {
            this.bindingService.removeBindingManagerListener(this.bindingManagerListener);
        }
        if (this.elementRef != null) {
            this.commandService.unregisterElement(this.elementRef);
            this.elementRef = null;
        }
        if (this.command != null && this.callback != null) {
            WorkbenchUIUtils.unregisterCommandElement(this.command.getId(), this.callback);
        }
        if (this.commandListener != null) {
            this.commandHandler.removeHandlerListener(this.commandListener);
            this.commandListener = null;
        }
    }

    public void dispose() {
        if (this.widget != null) {
            this.widget.dispose();
            this.widget = null;
        }
        this.disconnectReferences();
        this.command = null;
        this.commandHandler = null;
        this.commandService = null;
        this.bindingService = null;
        this.menuService = null;
        this.handlerService = null;
        this.disposeOldImages();
        super.dispose();
    }

    private void disposeOldImages() {
        if (this.localResourceManager != null) {
            this.localResourceManager.dispose();
            this.localResourceManager = null;
        }
    }

    private Listener getItemListener() {
        if (this.menuItemListener == null) {
            this.menuItemListener = new Listener(){

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 12: {
                            HandlerContributionItem.this.handleWidgetDispose(event);
                            break;
                        }
                        case 13: {
                            if (event.widget == null) break;
                            HandlerContributionItem.this.handleWidgetSelection(event);
                        }
                    }
                }
            };
        }
        return this.menuItemListener;
    }

    private void handleWidgetSelection(Event event) {
        if (this.openDropDownMenu(event)) {
            return;
        }
        if ((this.style & 0x22) != 0) {
            if (event.widget instanceof ToolItem) {
                this.checkedState = ((ToolItem)event.widget).getSelection();
            } else if (event.widget instanceof MenuItem) {
                this.checkedState = ((MenuItem)event.widget).getSelection();
            }
        }
        try {
            ExecutionEvent executionEvent = this.command != null ? this.handlerService.createExecutionEvent(this.command, event) : new ExecutionEvent(null, Collections.EMPTY_MAP, null, (Object)this.handlerService.createContextSnapshot(true));
            this.commandHandler.execute(executionEvent);
        }
        catch (ExecutionException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ecommons.uimisc", "Failed to execute item " + this.getId(), (Throwable)e));
        }
    }

    private boolean openDropDownMenu(Event event) {
        int style;
        Widget item = event.widget;
        if (item != null && ((style = item.getStyle()) & 4) != 0 && event.detail == 4) {
            ToolItem ti = (ToolItem)item;
            MenuManager menuManager = new MenuManager();
            Menu menu = menuManager.createContextMenu((Control)ti.getParent());
            if (this.workbenchHelpSystem != null) {
                this.workbenchHelpSystem.setHelp(menu, this.helpContextId);
            }
            this.initDropDownMenu(menuManager);
            Point point = ti.getParent().toDisplay(new Point(event.x, event.y));
            menu.setLocation(point.x, point.y);
            menu.setVisible(true);
            return true;
        }
        return false;
    }

    protected void initDropDownMenu(MenuManager menuManager) {
        String id = this.dropDownMenuOverride;
        if (id == null) {
            id = this.getId();
        }
        MenuUtils.registerOneWayMenu(menuManager, id);
    }

    private void updateIcons() {
        Widget widget = this.widget;
        if (widget instanceof MenuItem) {
            MenuItem item = (MenuItem)widget;
            LocalResourceManager m = new LocalResourceManager(JFaceResources.getResources());
            try {
                item.setImage(this.icon == null ? null : m.createImage(this.icon));
            }
            catch (DeviceResourceException e) {
                this.icon = ImageDescriptor.getMissingImageDescriptor();
                item.setImage(m.createImage(this.icon));
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ecommons.uimisc", "Failed to load image", (Throwable)e));
            }
            this.disposeOldImages();
            this.localResourceManager = m;
        } else {
            Widget widget2 = this.widget;
            if (widget2 instanceof ToolItem) {
                ToolItem item = (ToolItem)widget2;
                LocalResourceManager m = new LocalResourceManager(JFaceResources.getResources());
                item.setDisabledImage(this.disabledIcon == null ? null : m.createImage(this.disabledIcon));
                item.setHotImage(this.hoverIcon == null ? null : m.createImage(this.hoverIcon));
                item.setImage(this.icon == null ? null : m.createImage(this.icon));
                this.disposeOldImages();
                this.localResourceManager = m;
            }
        }
    }

    public void setText(@Nullable String text) {
        this.label = text;
        this.update(null);
    }

    public void setTooltip(@Nullable String text) {
        this.tooltip = text;
        if (this.widget instanceof ToolItem) {
            ((ToolItem)this.widget).setToolTipText(text);
        }
    }

    public void setIcon(@Nullable ImageDescriptor desc) {
        this.icon = desc;
        this.updateIcons();
    }

    public void setDisabledIcon(@Nullable ImageDescriptor desc) {
        this.disabledIcon = desc;
        this.updateIcons();
    }

    public void setHoverIcon(@Nullable ImageDescriptor desc) {
        this.hoverIcon = desc;
        this.updateIcons();
    }

    public void setChecked(boolean checked) {
        if (this.checkedState == checked) {
            return;
        }
        this.checkedState = checked;
        if (this.widget instanceof MenuItem) {
            ((MenuItem)this.widget).setSelection(this.checkedState);
        } else if (this.widget instanceof ToolItem) {
            ((ToolItem)this.widget).setSelection(this.checkedState);
        }
    }

    public boolean isEnabled() {
        if (this.commandHandler != null) {
            this.commandHandler.setEnabled(this.menuService != null ? this.menuService.getCurrentState() : null);
            return this.commandHandler.isEnabled();
        }
        return false;
    }

    public boolean isVisible() {
        if (this.visibleEnabled) {
            return super.isVisible() && this.isEnabled();
        }
        return super.isVisible();
    }
}

