/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.actions;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuListener2;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.util.StringUtils;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.statushandlers.StatusManager;

@NonNullByDefault
public abstract class SimpleContributionItem
extends ContributionItem {
    public static final int STYLE_PUSH = 8;
    public static final int STYLE_CHECK = 32;
    public static final int STYLE_RADIO = 16;
    public static final int STYLE_PULLDOWN = 4;
    public static final int MODE_FORCE_TEXT = 1;
    private LocalResourceManager localResourceManager;
    private @Nullable Widget widget;
    private @Nullable Listener menuItemListener;
    private @Nullable String label;
    private @Nullable String mnemonic;
    private @Nullable String tooltip;
    private @Nullable ImageDescriptor icon;
    private @Nullable ImageDescriptor disabledIcon;
    private @Nullable ImageDescriptor hoverIcon;
    private boolean checkedState;
    private final int style;
    private @Nullable IWorkbenchHelpSystem workbenchHelpSystem;
    private @Nullable String helpContextId;
    private final int mode = 0;

    public SimpleContributionItem(CommandContributionItemParameter contributionParameters) {
        super(contributionParameters.id);
        this.label = contributionParameters.label;
        this.mnemonic = contributionParameters.mnemonic;
        this.tooltip = contributionParameters.tooltip;
        this.icon = contributionParameters.icon;
        this.disabledIcon = contributionParameters.disabledIcon;
        this.hoverIcon = contributionParameters.hoverIcon;
        this.style = contributionParameters.style;
        this.helpContextId = contributionParameters.helpContextId;
    }

    protected SimpleContributionItem(@Nullable String id, @Nullable String label, @Nullable String mnemonic, @Nullable ImageDescriptor icon, @Nullable ImageDescriptor disabledIcon, int style) {
        super(id);
        this.label = label;
        this.mnemonic = mnemonic;
        this.icon = icon;
        this.disabledIcon = disabledIcon;
        this.style = style;
    }

    protected SimpleContributionItem(@Nullable String label, @Nullable String mnemonic, @Nullable ImageDescriptor icon, @Nullable ImageDescriptor disabledIcon, int style) {
        this(null, label, mnemonic, icon, disabledIcon, style);
    }

    protected SimpleContributionItem(@Nullable String label, @Nullable String mnemonic, int style) {
        this(null, label, mnemonic, null, null, style);
    }

    protected SimpleContributionItem(@Nullable String label, @Nullable String mnemonic, @Nullable ImageDescriptor icon, @Nullable ImageDescriptor disabledIcon) {
        this(null, label, mnemonic, icon, disabledIcon, 8);
    }

    protected SimpleContributionItem(@Nullable String label, @Nullable String mnemonic) {
        this(null, label, mnemonic, null, null, 8);
    }

    public void fill(Menu parent, int index) {
        if (this.widget != null || parent == null) {
            return;
        }
        int tmpStyle = this.style;
        if (tmpStyle == 4) {
            tmpStyle = 8;
        }
        MenuItem item = null;
        item = index >= 0 ? new MenuItem(parent, tmpStyle, index) : new MenuItem(parent, tmpStyle);
        item.setData((Object)this);
        if (this.workbenchHelpSystem != null) {
            this.workbenchHelpSystem.setHelp(item, this.helpContextId);
        }
        item.addListener(12, this.getItemListener());
        item.addListener(13, this.getItemListener());
        this.widget = item;
        this.update(null);
        this.updateIcons();
    }

    public void fill(ToolBar parent, int index) {
        if (this.widget != null || parent == null) {
            return;
        }
        ToolItem item = null;
        item = index >= 0 ? new ToolItem(parent, this.style, index) : new ToolItem(parent, this.style);
        item.setData((Object)this);
        item.addListener(13, this.getItemListener());
        item.addListener(12, this.getItemListener());
        this.widget = item;
        this.update(null);
        this.updateIcons();
    }

    public void fill(Composite parent) {
        if (this.widget != null || parent == null) {
            return;
        }
        int tmpStyle = this.style;
        if (tmpStyle == 4) {
            tmpStyle = 8;
        }
        Button item = new Button(parent, tmpStyle);
        item.setData((Object)this);
        if (this.workbenchHelpSystem != null) {
            this.workbenchHelpSystem.setHelp((Control)item, this.helpContextId);
        }
        item.addListener(12, this.getItemListener());
        item.addListener(13, this.getItemListener());
        this.widget = item;
        this.update(null);
        this.updateIcons();
    }

    public void update() {
        this.update(null);
    }

    public void update(String id) {
        if (this.widget != null) {
            if (this.widget instanceof MenuItem) {
                this.updateMenuItem((MenuItem)this.widget);
            } else if (this.widget instanceof ToolItem) {
                this.updateToolItem((ToolItem)this.widget);
            } else if (this.widget instanceof Button) {
                this.updateButton((Button)this.widget);
            }
        }
    }

    private void updateMenuItem(MenuItem item) {
        boolean shouldBeEnabled = this.isEnabled();
        if (item.isDisposed()) {
            return;
        }
        String text = this.label;
        text = this.updateMnemonic(text);
        String keyBindingText = null;
        if (text != null) {
            if (keyBindingText == null) {
                item.setText(text);
            } else {
                item.setText(text + "\t" + keyBindingText);
            }
        }
        if (item.getSelection() != this.checkedState) {
            item.setSelection(this.checkedState);
        }
        if (item.getEnabled() != shouldBeEnabled) {
            item.setEnabled(shouldBeEnabled);
        }
    }

    private void updateToolItem(ToolItem item) {
        boolean shouldBeEnabled = this.isEnabled();
        if (item.isDisposed()) {
            return;
        }
        String text = this.label;
        if ((this.icon == null || false & true) && text != null) {
            item.setText(text);
        }
        String toolTipText = this.getToolTipText(text);
        item.setToolTipText(toolTipText);
        if (item.getSelection() != this.checkedState) {
            item.setSelection(this.checkedState);
        }
        if (item.getEnabled() != shouldBeEnabled) {
            item.setEnabled(shouldBeEnabled);
        }
    }

    private void updateButton(Button item) {
        boolean shouldBeEnabled = this.isEnabled();
        if (item.isDisposed()) {
            return;
        }
        String text = this.label;
        if (text != null) {
            item.setText(text);
        }
        String toolTipText = this.getToolTipText(text);
        item.setToolTipText(toolTipText);
        if (item.getSelection() != this.checkedState) {
            item.setSelection(this.checkedState);
        }
        if (item.getEnabled() != shouldBeEnabled) {
            item.setEnabled(shouldBeEnabled);
        }
    }

    private String getToolTipText(String text) {
        String tooltipText = this.tooltip;
        if (this.tooltip == null) {
            tooltipText = text != null ? text : "";
        }
        return tooltipText;
    }

    private String updateMnemonic(String s) {
        if (this.mnemonic == null || s == null) {
            return s;
        }
        int idx = s.indexOf(this.mnemonic);
        if (idx < 0) {
            return s;
        }
        return StringUtils.insert((String)s, (int)idx, (char)'&');
    }

    private void handleWidgetDispose(Event event) {
        if (event.widget == this.widget) {
            this.widget.removeListener(13, this.getItemListener());
            this.widget.removeListener(12, this.getItemListener());
            this.widget = null;
            this.disposeOldImages();
        }
    }

    public void dispose() {
        if (this.widget != null) {
            this.widget.dispose();
            this.widget = null;
        }
        this.disposeOldImages();
        super.dispose();
    }

    private void disposeOldImages() {
        if (this.localResourceManager != null) {
            this.localResourceManager.dispose();
            this.localResourceManager = null;
        }
    }

    private Listener getItemListener() {
        if (this.menuItemListener == null) {
            this.menuItemListener = new Listener(){

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 12: {
                            SimpleContributionItem.this.handleWidgetDispose(event);
                            break;
                        }
                        case 13: {
                            if (event.widget == null) break;
                            SimpleContributionItem.this.handleWidgetSelection(event);
                        }
                    }
                }
            };
        }
        return this.menuItemListener;
    }

    private void handleWidgetSelection(Event event) {
        if (this.openDropDownMenu(event)) {
            return;
        }
        if ((this.style & 0x22) != 0) {
            if (event.widget instanceof ToolItem) {
                this.checkedState = ((ToolItem)event.widget).getSelection();
            } else if (event.widget instanceof MenuItem) {
                this.checkedState = ((MenuItem)event.widget).getSelection();
            }
        }
        try {
            this.execute(event);
        }
        catch (ExecutionException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ecommons.uimisc", "Failed to execute item " + this.getId(), (Throwable)e));
        }
    }

    private boolean openDropDownMenu(Event event) {
        int style;
        Widget item = event.widget;
        if (item != null && ((style = item.getStyle()) & 4) != 0 && event.detail == 4) {
            ToolItem ti = (ToolItem)item;
            MenuManager menuManager = new MenuManager();
            Menu menu = menuManager.createContextMenu((Control)ti.getParent());
            if (this.workbenchHelpSystem != null) {
                this.workbenchHelpSystem.setHelp(menu, this.helpContextId);
            }
            this.initDropDownMenu(menuManager);
            Point point = ti.getParent().toDisplay(new Point(event.x, event.y));
            menu.setLocation(point.x, point.y);
            menu.setVisible(true);
            return true;
        }
        return false;
    }

    protected void initDropDownMenu(final MenuManager menuManager) {
        final Menu menu = menuManager.getMenu();
        menuManager.addMenuListener((IMenuListener)new IMenuListener2(){

            public void menuAboutToShow(IMenuManager manager) {
                SimpleContributionItem.this.dropDownMenuAboutToShow(manager);
            }

            public void menuAboutToHide(IMenuManager manager) {
                menu.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        menuManager.dispose();
                    }
                });
            }
        });
    }

    private void updateIcons() {
        if (this.widget instanceof MenuItem) {
            MenuItem item = (MenuItem)this.widget;
            LocalResourceManager m = new LocalResourceManager(JFaceResources.getResources());
            try {
                item.setImage(this.icon == null ? null : m.createImage(this.icon));
            }
            catch (DeviceResourceException e) {
                this.icon = ImageDescriptor.getMissingImageDescriptor();
                item.setImage(m.createImage(this.icon));
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ecommons.uimisc", "Failed to load image", (Throwable)e));
            }
            this.disposeOldImages();
            this.localResourceManager = m;
        } else if (this.widget instanceof ToolItem) {
            ToolItem item = (ToolItem)this.widget;
            LocalResourceManager m = new LocalResourceManager(JFaceResources.getResources());
            item.setDisabledImage(this.disabledIcon == null ? null : m.createImage(this.disabledIcon));
            item.setHotImage(this.hoverIcon == null ? null : m.createImage(this.hoverIcon));
            item.setImage(this.icon == null ? null : m.createImage(this.icon));
            this.disposeOldImages();
            this.localResourceManager = m;
        }
    }

    public void setText(@Nullable String text) {
        this.label = text;
        this.update(null);
    }

    public void setChecked(boolean checked) {
        if (this.checkedState == checked) {
            return;
        }
        this.checkedState = checked;
        if (this.widget instanceof MenuItem) {
            ((MenuItem)this.widget).setSelection(this.checkedState);
        } else if (this.widget instanceof ToolItem) {
            ((ToolItem)this.widget).setSelection(this.checkedState);
        }
    }

    public void setTooltip(@Nullable String text) {
        this.tooltip = text;
        if (this.widget instanceof ToolItem) {
            ((ToolItem)this.widget).setToolTipText(text);
        }
    }

    public void setIcon(@Nullable ImageDescriptor desc) {
        this.icon = desc;
        this.updateIcons();
    }

    public void setDisabledIcon(@Nullable ImageDescriptor desc) {
        this.disabledIcon = desc;
        this.updateIcons();
    }

    public void setHoverIcon(@Nullable ImageDescriptor desc) {
        this.hoverIcon = desc;
        this.updateIcons();
    }

    protected void dropDownMenuAboutToShow(IMenuManager manager) {
    }

    protected void execute(Event event) throws ExecutionException {
        this.execute();
    }

    @Deprecated
    protected void execute() throws ExecutionException {
    }
}

