/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.viewers.breadcrumb;

import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.statet.ecommons.ui.SharedUIResources;
import org.eclipse.statet.ecommons.ui.jface.resource.ImageDescriptorRegistry;
import org.eclipse.statet.ecommons.ui.swt.SwtUtils;
import org.eclipse.statet.ecommons.ui.swt.util.ArrowImageDataProvider;
import org.eclipse.statet.ecommons.ui.viewers.breadcrumb.BreadcrumbMessages;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

@NonNullByDefault
class DropDownContributionItem
extends ContributionItem {
    private final int flags;
    private @Nullable ToolItem widget = null;
    private @Nullable ArrowImageDataProvider arrowImageData = (ArrowImageDataProvider)ObjectUtils.nonNullLateInit();

    public DropDownContributionItem(int flags) {
        this.flags = flags;
    }

    public @Nullable Widget getWidget() {
        return this.widget;
    }

    public void dispose() {
        this.widget = SwtUtils.dispose(this.widget);
    }

    public void fill(ToolBar parent, int index) {
        if (this.widget != null || parent == null) {
            return;
        }
        ToolItem widget = null;
        widget = index >= 0 ? new ToolItem(parent, 8, index) : new ToolItem(parent, 8);
        widget.setData((Object)this);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (event.widget != DropDownContributionItem.this.widget) {
                    return;
                }
                switch (event.type) {
                    case 12: {
                        DropDownContributionItem.this.onWidgetDisposed();
                        break;
                    }
                    case 13: {
                        DropDownContributionItem.this.handleWidgetSelection();
                    }
                }
            }
        };
        widget.addListener(13, listener);
        widget.addListener(12, listener);
        this.widget = widget;
        this.updateImages();
        widget.setToolTipText(BreadcrumbMessages.BreadcrumbItemDropDown_showDropDownMenu_action_tooltip);
        widget.getDisplay().asyncExec(this::updateImages);
    }

    private void updateImages() {
        ToolItem widget = this.widget;
        if (widget == null || widget.isDisposed()) {
            return;
        }
        ArrowImageDataProvider arrowImageData = this.arrowImageData;
        RGB foregroundColor = ArrowImageDataProvider.computeDefaultForegroundColor(widget.getForeground(), widget.getBackground());
        if (arrowImageData != null && arrowImageData.getForegroundColor().equals((Object)foregroundColor)) {
            return;
        }
        this.arrowImageData = arrowImageData = new ArrowImageDataProvider((this.flags & 0x4000000) != 0 ? 16384 : 131072, foregroundColor);
        ImageDescriptorRegistry imageRegistry = SharedUIResources.getInstance().getImageDescriptorRegistry();
        Image image = imageRegistry.getRequired(ImageDescriptor.createFromImageDataProvider((ImageDataProvider)arrowImageData));
        widget.setImage(image);
        widget.setDisabledImage(imageRegistry.get(ImageDescriptor.createWithFlags((ImageDescriptor)ImageDescriptor.createFromImage((Image)image), (int)1)));
    }

    private void onWidgetDisposed() {
        this.widget = null;
    }

    protected void handleWidgetSelection() {
    }
}

