/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.workbench;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.statet.ecommons.commands.core.HandlerCollection;
import org.eclipse.statet.ecommons.ui.actions.CollapseAllHandler;
import org.eclipse.statet.ecommons.ui.actions.ExpandAllHandler;
import org.eclipse.statet.ecommons.ui.actions.HandlerContributionItem;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.ecommons.ui.workbench.ContextHandlers;
import org.eclipse.statet.ecommons.ui.workbench.WorkbenchUIUtils;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

@NonNullByDefault
public abstract class BasicEditorOutlinePage
extends Page
implements IContentOutlinePage,
IAdaptable,
IPostSelectionProvider {
    private @Nullable TreeViewer treeViewer;
    private @Nullable ISelection currentSelection;
    private final CopyOnWriteIdentityListSet<ISelectionChangedListener> selectionListeners = new CopyOnWriteIdentityListSet();
    private final ISelectionChangedListener selectionListener = new SelectionChangeNotify(this.selectionListeners);
    private final CopyOnWriteIdentityListSet<ISelectionChangedListener> postSelectionListeners = new CopyOnWriteIdentityListSet();
    private final ISelectionChangedListener postSelectionListener = new SelectionChangeNotify(this.postSelectionListeners);
    private int ignoreSelection;
    private final String contextMenuID;
    private @Nullable Menu contextMenu;
    private ContextHandlers handlers;
    private final CopyOnWriteIdentityListSet<IHandler2> handlersToUpdate = new CopyOnWriteIdentityListSet();

    public BasicEditorOutlinePage(String contextMenuId) {
        this.contextMenuID = contextMenuId;
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        pageSite.setSelectionProvider((ISelectionProvider)this);
    }

    protected abstract IDialogSettings getDialogSettings();

    protected @Nullable StructuredViewer getViewer() {
        return this.treeViewer;
    }

    public void createControl(Composite parent) {
        TreeViewer viewer = new TreeViewer(parent, 770);
        viewer.setUseHashlookup(true);
        this.configureViewer(viewer);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)viewer);
        this.treeViewer = viewer;
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                BasicEditorOutlinePage.this.currentSelection = event.getSelection();
            }
        });
        final IPageSite site = this.getSite();
        this.handlers = new ContextHandlers((IServiceLocator)site);
        this.initActions((IServiceLocator)site, this.handlers);
        this.selectionListeners.add((Object)new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Control control = BasicEditorOutlinePage.this.getControl();
                if (control != null && control.isVisible()) {
                    EvaluationContext evaluationContext = new EvaluationContext(null, (Object)event.getSelection());
                    evaluationContext.addVariable("activeSite", (Object)site);
                    evaluationContext.addVariable("selection", (Object)event.getSelection());
                    for (IHandler2 handler : BasicEditorOutlinePage.this.handlersToUpdate.toList()) {
                        handler.setEnabled((Object)evaluationContext);
                    }
                }
            }
        });
        this.contributeToActionBars((IServiceLocator)site, site.getActionBars(), this.handlers);
        this.hookContextMenu();
        this.init();
    }

    private void hookContextMenu() {
        MenuManager menuManager = new MenuManager(this.contextMenuID, this.contextMenuID);
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager m) {
                BasicEditorOutlinePage.this.contextMenuAboutToShow(m);
            }
        });
        StructuredViewer viewer = (StructuredViewer)ObjectUtils.nonNullAssert((Object)this.getViewer());
        Menu contextMenu = menuManager.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(contextMenu);
        this.contextMenu = contextMenu;
        this.getSite().registerContextMenu(this.contextMenuID, menuManager, (ISelectionProvider)viewer);
    }

    public @Nullable Control getControl() {
        TreeViewer viewer = this.treeViewer;
        if (viewer != null) {
            return viewer.getControl();
        }
        return null;
    }

    public void setFocus() {
        StructuredViewer viewer = this.getViewer();
        if (viewer == null || !UIAccess.isOkToUse(viewer.getControl())) {
            return;
        }
        viewer.getControl().setFocus();
    }

    protected abstract void configureViewer(TreeViewer var1);

    protected void init() {
    }

    protected void beginIgnoreSelection() {
        ++this.ignoreSelection;
    }

    protected void endIgnoreSelection(boolean async) {
        if (async) {
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    --BasicEditorOutlinePage.this.ignoreSelection;
                }
            });
        } else {
            --this.ignoreSelection;
        }
    }

    protected void initActions(IServiceLocator serviceLocator, ContextHandlers handlers) {
        StructuredViewer viewer = (StructuredViewer)ObjectUtils.nonNullAssert((Object)this.getViewer());
        this.postSelectionListeners.add((Object)new DefaultSelectionListener());
        viewer.addSelectionChangedListener(this.selectionListener);
        viewer.addPostSelectionChangedListener(this.postSelectionListener);
        if (viewer instanceof AbstractTreeViewer) {
            AbstractTreeViewer treeViewer = (AbstractTreeViewer)viewer;
            AbstractHandler handler = new CollapseAllHandler(treeViewer){

                @Override
                public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
                    BasicEditorOutlinePage.this.beginIgnoreSelection();
                    try {
                        Object object = super.execute(event);
                        return object;
                    }
                    finally {
                        BasicEditorOutlinePage.this.endIgnoreSelection(true);
                    }
                }
            };
            handlers.addActivate("org.eclipse.ui.navigate.collapseAll", (IHandler2)handler);
            handler = new ExpandAllHandler(treeViewer);
            handlers.addActivate("org.eclipse.ui.navigate.expandAll", (IHandler2)handler);
        }
    }

    protected void contributeToActionBars(IServiceLocator serviceLocator, IActionBars actionBars, HandlerCollection handlers) {
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        toolBarManager.add((IContributionItem)new Separator("view.expand"));
        toolBarManager.appendToGroup("view.expand", (IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter(serviceLocator, null, "org.eclipse.ui.navigate.collapseAll", 8), handlers));
        toolBarManager.add((IContributionItem)new Separator("view.sort"));
        Separator viewFilter = new Separator("view.filter");
        viewFilter.setVisible(false);
        toolBarManager.add((IContributionItem)viewFilter);
    }

    protected void contextMenuAboutToShow(IMenuManager m) {
    }

    public void dispose() {
        this.handlers.dispose();
        this.handlersToUpdate.clear();
        this.postSelectionListeners.clear();
        Menu contextMenu = this.contextMenu;
        if (contextMenu != null && !contextMenu.isDisposed()) {
            this.contextMenu = null;
            contextMenu.dispose();
        }
    }

    protected abstract void selectInEditor(ISelection var1);

    protected void registerHandlerToUpdate(IHandler2 handler) {
        this.handlersToUpdate.add((Object)handler);
    }

    public void setSelection(ISelection selection) {
        StructuredViewer viewer = this.getViewer();
        if (viewer == null || !UIAccess.isOkToUse(viewer.getControl())) {
            return;
        }
        viewer.setSelection(selection);
    }

    public ISelection getSelection() {
        ISelection selection = this.currentSelection;
        if (selection != null) {
            return selection;
        }
        TreeViewer viewer = this.treeViewer;
        if (viewer != null) {
            return viewer.getSelection();
        }
        return TreeSelection.EMPTY;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add((Object)((ISelectionChangedListener)ObjectUtils.nonNullAssert((Object)listener)));
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove((Object)listener);
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        this.postSelectionListeners.add((Object)((ISelectionChangedListener)ObjectUtils.nonNullAssert((Object)listener)));
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        this.postSelectionListeners.remove((Object)listener);
    }

    public <T> @Nullable T getAdapter(Class<T> adapterType) {
        return null;
    }

    protected abstract class AbstractToggleHandler
    extends AbstractHandler
    implements IElementUpdater {
        private final String settingsKey;
        private final String commandId;
        private final int time;
        private boolean isSettingEnabled;

        public AbstractToggleHandler(String checkSettingsKey, boolean checkSettingsDefault, String commandId, int expensive) {
            boolean on;
            this.settingsKey = checkSettingsKey;
            this.commandId = commandId;
            this.time = expensive;
            IDialogSettings settings = BasicEditorOutlinePage.this.getDialogSettings();
            this.isSettingEnabled = on = settings.get(this.settingsKey) == null ? checkSettingsDefault : BasicEditorOutlinePage.this.getDialogSettings().getBoolean(this.settingsKey);
            this.apply(on);
        }

        protected void init() {
        }

        public void updateElement(UIElement element, Map parameters) {
            WorkbenchUIUtils.aboutToUpdateCommandsElements((IHandler2)this, element);
            try {
                element.setChecked(this.isChecked());
            }
            finally {
                WorkbenchUIUtils.finalizeUpdateCommandsElements((IHandler2)this);
            }
        }

        public boolean isChecked() {
            return this.isSettingEnabled;
        }

        public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
            boolean on;
            this.isSettingEnabled = on = !this.isSettingEnabled;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    AbstractToggleHandler.this.apply(on);
                    BasicEditorOutlinePage.this.getDialogSettings().put(AbstractToggleHandler.this.settingsKey, on);
                }
            };
            if (this.time == 0) {
                runnable.run();
            } else {
                BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)runnable);
            }
            if (this.commandId != null) {
                WorkbenchUIUtils.refreshCommandElements(this.commandId, (IHandler2)this, null);
            }
            return null;
        }

        protected abstract void apply(boolean var1);
    }

    private class DefaultSelectionListener
    implements ISelectionChangedListener {
        private DefaultSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (BasicEditorOutlinePage.this.ignoreSelection == 0) {
                BasicEditorOutlinePage.this.selectInEditor(event.getSelection());
            }
        }
    }

    private static class SelectionChangeNotify
    extends SafeRunnable
    implements ISelectionChangedListener {
        private final CopyOnWriteIdentityListSet<ISelectionChangedListener> selectionListeners;
        private SelectionChangedEvent currentEvent;
        private ISelectionChangedListener currentListener;

        public SelectionChangeNotify(CopyOnWriteIdentityListSet<ISelectionChangedListener> listenerList) {
            this.selectionListeners = listenerList;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.currentEvent = event;
            Iterator iterator = this.selectionListeners.toList().iterator();
            while (iterator.hasNext()) {
                ISelectionChangedListener listener;
                this.currentListener = listener = (ISelectionChangedListener)iterator.next();
                SafeRunner.run((ISafeRunnable)this);
            }
            this.currentEvent = null;
            this.currentListener = null;
        }

        public void run() {
            this.currentListener.selectionChanged(this.currentEvent);
        }
    }
}

