/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.services.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.MessageFormat;
import org.eclipse.statet.jcommons.io.FileUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.rj.data.RDataUtils;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RVector;
import org.eclipse.statet.rj.data.UnexpectedRDataException;
import org.eclipse.statet.rj.renv.core.RNumVersion;
import org.eclipse.statet.rj.renv.core.RPkg;
import org.eclipse.statet.rj.renv.core.RPkgType;
import org.eclipse.statet.rj.renv.core.RPkgUtils;
import org.eclipse.statet.rj.services.FunctionCall;
import org.eclipse.statet.rj.services.RService;

@NonNullByDefault
public class RPkgInstallation {
    private final RPkg pkgInfo;
    private final Path file;
    private final String fileName;

    public RPkgInstallation(Path file) throws StatusException {
        this.file = (Path)ObjectUtils.nonNullAssert((Object)file);
        this.fileName = FileUtils.requireFileName((Path)file).toString();
        this.pkgInfo = RPkgUtils.checkPkgFileName(this.fileName);
    }

    public RPkgInstallation(File file) throws StatusException {
        this(file.toPath());
    }

    public RPkg getPkg() {
        return this.pkgInfo;
    }

    protected String getPkgFileName() {
        return this.fileName;
    }

    protected void uploadPkgFile(String target, RService r, ProgressMonitor m) throws StatusException, IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStream in = Files.newInputStream(this.file, new OpenOption[0]);){
            r.uploadFile(in, Files.size(this.file), target, 0, m);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void install(RService r, ProgressMonitor m) throws StatusException {
        String source = this.getPkgFileName();
        RPkgType pkgType = RPkgUtils.checkPkgType(source, r.getPlatform());
        String serverFile = null;
        String libLoc = null;
        try {
            try {
                RVector data = RDataUtils.checkRIntVector((RObject)r.evalData("rj:::renv.isValidLibLocation(.libPaths()[1])", m));
                int state = RDataUtils.checkSingleIntValue((RObject)data);
                libLoc = data.getNames().getChar(0);
                if (state != 0) {
                    throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.rj.services.core", MessageFormat.format("The library location ''{0}'' is not writable.", libLoc)));
                }
                FunctionCall call = r.createFunctionCall("dir.create");
                call.addChar("rpkgs");
                call.addLogi("showWarnings", false);
                call.evalVoid(m);
                serverFile = "rpkgs/" + source;
                this.uploadPkgFile(serverFile, r, m);
                call = r.createFunctionCall("install.packages");
                call.addChar(serverFile);
                call.addChar("lib", libLoc);
                call.addNull("repos");
                call.addChar("type", RPkgUtils.getPkgTypeInstallKey(r.getPlatform(), pkgType));
                call.evalVoid(m);
                call = r.createFunctionCall("packageDescription");
                call.addChar("pkg", this.pkgInfo.getName());
                call.addChar("lib.loc", libLoc);
                call.addChar("fields", "Version");
                RVector data2 = RDataUtils.checkRVector((RObject)call.evalData(m));
                try {
                    String s = RDataUtils.checkSingleCharValue((RObject)data2);
                    RNumVersion installedVersion = RNumVersion.create(s);
                    if (!installedVersion.equals(this.pkgInfo.getVersion())) {
                        throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.rj.services.core", String.format("Validation of package installation failed: installed package has different version (found= %1$s, expected= %2$s).", installedVersion.toString(), this.pkgInfo.getVersion().toString())));
                    }
                }
                catch (UnexpectedRDataException e) {
                    throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.rj.services.core", "Validation of package installation failed: no installed package found."));
                }
                this.clear(serverFile, r, m);
                serverFile = null;
            }
            catch (IOException | StatusException | UnexpectedRDataException e) {
                throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.rj.services.core", String.format("An error occurred when installing R package from %1$s.", source), e));
            }
        }
        catch (Throwable throwable) {
            if (serverFile != null) {
                try {
                    this.clear(serverFile, r, m);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw throwable;
        }
        if (serverFile != null) {
            try {
                this.clear(serverFile, r, m);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void clear(String target, RService r, ProgressMonitor m) throws StatusException {
        FunctionCall call = r.createFunctionCall("file.remove");
        call.addChar(target);
        call.evalVoid(m);
    }
}

