/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.services.util.dataaccess;

import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.rj.data.RDataUtils;
import org.eclipse.statet.rj.data.RLanguage;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RObjectFactory;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.RVector;
import org.eclipse.statet.rj.data.UnexpectedRDataException;
import org.eclipse.statet.rj.data.impl.DefaultRObjectFactory;
import org.eclipse.statet.rj.services.FQRObjectRef;
import org.eclipse.statet.rj.services.FunctionCall;
import org.eclipse.statet.rj.services.RService;
import org.eclipse.statet.rj.services.util.dataaccess.LazyRStore;
import org.eclipse.statet.rj.services.util.dataaccess.RDataAssignment;

public abstract class AbstractRDataAdapter<TRObject extends RObject, TFragmentObject extends RObject> {
    public static final int ROW_COUNT = 1;
    public static final int STORE_TYPE = 4;
    protected static final String API_R_PREFIX = "rj:::sda002";
    protected static final RObjectFactory R_OBJECT_FACTORY = DefaultRObjectFactory.INSTANCE;

    protected static void addXRef(FunctionCall fcall, FQRObjectRef ref) {
        fcall.add("x.env", ref.getEnv());
        fcall.add("x.expr", (RObject)R_OBJECT_FACTORY.createExpression("x.env$" + ((RLanguage)ref.getName()).getSource()));
    }

    public abstract TRObject validate(RObject var1) throws UnexpectedRDataException;

    public abstract TRObject validate(RObject var1, TRObject var2, int var3) throws UnexpectedRDataException;

    public abstract long getRowCount(TRObject var1);

    public abstract long getColumnCount(TRObject var1);

    public void check(FQRObjectRef ref, TRObject referenceObject, RService r, ProgressMonitor m) throws StatusException, UnexpectedRDataException {
        FunctionCall fcall = r.createFunctionCall("rj:::sda002.checkDataStruct");
        AbstractRDataAdapter.addXRef(fcall, ref);
        fcall.addChar("xClass1", referenceObject.getRClassName());
        fcall.add("xDim", (RObject)R_OBJECT_FACTORY.createNumVector(new double[]{this.getRowCount(referenceObject), this.getColumnCount(referenceObject)}));
        RObject result = fcall.evalData(m);
        if (!RDataUtils.checkSingleLogiValue((RObject)result)) {
            throw new UnexpectedRDataException("It seems something changed.");
        }
    }

    public TFragmentObject loadData(FQRObjectRef ref, TRObject referenceObject, LazyRStore.Fragment<TFragmentObject> fragment, String rowMapping, RService r, ProgressMonitor m) throws StatusException, UnexpectedRDataException {
        FunctionCall fcall = r.createFunctionCall(this.getLoadDataFName());
        AbstractRDataAdapter.addXRef(fcall, ref);
        fcall.add("idxs", (RObject)R_OBJECT_FACTORY.createNumVector(new double[]{fragment.getRowBeginIdx() + 1L, fragment.getRowEndIdx(), fragment.getColumnBeginIdx() + 1L, fragment.getColumnEndIdx()}));
        if (rowMapping != null) {
            fcall.addChar("rowMapping", rowMapping);
        }
        RObject fragmentObject = fcall.evalData(null, this.getLoadOptions(), -1, m);
        return this.validateData(fragmentObject, referenceObject, fragment);
    }

    protected abstract String getLoadDataFName();

    protected int getLoadOptions() {
        return 0;
    }

    protected abstract TFragmentObject validateData(RObject var1, TRObject var2, LazyRStore.Fragment<TFragmentObject> var3) throws UnexpectedRDataException;

    public void setData(FQRObjectRef ref, TRObject referenceObject, RDataAssignment assignment, String rowMapping, RService r, ProgressMonitor m) throws StatusException, UnexpectedRDataException {
        FunctionCall fcall = r.createFunctionCall(this.getSetDataFName());
        AbstractRDataAdapter.addXRef(fcall, ref);
        fcall.add("idxs", (RObject)R_OBJECT_FACTORY.createNumVector(new double[]{assignment.getRowBeginIdx() + 1L, assignment.getRowEndIdx(), assignment.getColumnBeginIdx() + 1L, assignment.getColumnEndIdx()}));
        if (rowMapping != null) {
            fcall.addChar("rowMapping", rowMapping);
        }
        fcall.add("values", (RObject)R_OBJECT_FACTORY.createVector(assignment.getData()));
        fcall.evalVoid(m);
    }

    protected abstract String getSetDataFName();

    public RVector<?> loadRowNames(FQRObjectRef ref, TRObject referenceObject, LazyRStore.Fragment<RVector<?>> fragment, String rowMapping, RService r, ProgressMonitor m) throws StatusException, UnexpectedRDataException {
        FunctionCall fcall = r.createFunctionCall(this.getLoadRowNamesFName());
        AbstractRDataAdapter.addXRef(fcall, ref);
        fcall.add("idxs", (RObject)R_OBJECT_FACTORY.createNumVector(new double[]{fragment.getRowBeginIdx() + 1L, fragment.getRowEndIdx()}));
        if (rowMapping != null) {
            fcall.addChar("rowMapping", rowMapping);
        }
        RObject fragmentObject = fcall.evalData(m);
        return this.validateRowNames(fragmentObject, referenceObject, fragment);
    }

    protected abstract String getLoadRowNamesFName();

    protected RVector<?> validateRowNames(RObject rObject, TRObject referenceObject, LazyRStore.Fragment<RVector<?>> fragment) throws UnexpectedRDataException {
        if (rObject.getRObjectType() == 1) {
            return null;
        }
        RVector vector = RDataUtils.checkRVector((RObject)rObject);
        RDataUtils.checkLengthEqual((RStore)vector.getData(), (long)fragment.getRowCount());
        return vector;
    }
}

