/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.util;

import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;

@NonNullByDefault
public class RCodeBuilder {
    protected final StringBuilder sb;

    public static void appendStringD(StringBuilder sb, CharSequence s) {
        sb.ensureCapacity(sb.length() + 2);
        sb.append('\"');
        int doneIndex = 0;
        int endIndex = s.length();
        int index = 0;
        while (index < endIndex) {
            char c = s.charAt(index);
            switch (c) {
                case '\\': {
                    if (doneIndex < index) {
                        sb.append(s, doneIndex, index);
                    }
                    sb.append("\\\\");
                    doneIndex = ++index;
                    break;
                }
                case '\"': {
                    if (doneIndex < index) {
                        sb.append(s, doneIndex, index);
                    }
                    sb.append("\\\"");
                    doneIndex = ++index;
                    break;
                }
                default: {
                    ++index;
                }
            }
        }
        if (doneIndex < endIndex) {
            sb.append(s, doneIndex, endIndex);
        }
        sb.append('\"');
    }

    public RCodeBuilder() {
        this.sb = new StringBuilder();
    }

    public RCodeBuilder(int initialCapacity) {
        this.sb = new StringBuilder(initialCapacity);
    }

    public RCodeBuilder clear() {
        this.sb.setLength(0);
        return this;
    }

    public RCodeBuilder append(CharSequence code) {
        this.sb.append((CharSequence)ObjectUtils.nonNullAssert((Object)code));
        return this;
    }

    public RCodeBuilder append(String code) {
        this.sb.append((String)ObjectUtils.nonNullAssert((Object)code));
        return this;
    }

    public RCodeBuilder append(CharSequence code, int startIndex, int endIndex) {
        this.sb.append((CharSequence)ObjectUtils.nonNullAssert((Object)code), startIndex, endIndex);
        return this;
    }

    public RCodeBuilder append(char c) {
        this.sb.append(c);
        return this;
    }

    public RCodeBuilder insert(int index, char c) {
        this.sb.insert(index, c);
        return this;
    }

    public RCodeBuilder deleteEnd(int length) {
        int endIndex = this.sb.length();
        this.sb.delete(endIndex - length, endIndex);
        return this;
    }

    public RCodeBuilder appendChar(CharSequence s) {
        RCodeBuilder.appendStringD(this.sb, s);
        return this;
    }

    public String build() {
        return this.sb.toString();
    }

    public String toString() {
        return this.sb.toString();
    }
}

