/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.jar;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.tea.library.build.jar.JarComparator;
import org.eclipse.tea.library.build.jar.ZipExec;
import org.eclipse.tea.library.build.jar.ZipExecPart;

abstract class BaseZipExec
implements ZipExec {
    protected static final String GITIGNORE = ".gitignore";
    protected File zipFile;
    protected final List<ZipExecPart> parts = new ArrayList<ZipExecPart>();
    protected boolean isJar;

    BaseZipExec() {
    }

    @Override
    public void setZipFile(File zipFile) {
        this.zipFile = zipFile;
    }

    @Override
    public void setJarMode(boolean isJar) {
        this.isJar = isJar;
    }

    @Override
    public void addPart(ZipExecPart part) {
        this.parts.add(part);
    }

    @Override
    public final void createZip() {
        if (this.isJar) {
            Collections.sort(this.parts, new Comparator<ZipExecPart>(){

                @Override
                public int compare(ZipExecPart o1, ZipExecPart o2) {
                    String key1 = o1.getJarKey();
                    String key2 = o2.getJarKey();
                    return JarComparator.instance.compare(key1, key2);
                }
            });
        }
        this.doCreateZip();
    }

    protected abstract void doCreateZip();
}

