/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.model;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.tea.library.build.internal.Activator;
import org.eclipse.tea.library.build.model.BundleData;
import org.eclipse.tea.library.build.model.ManifestAttribute;
import org.eclipse.tea.library.build.model.ParameterValue;

final class ManifestHolder {
    private static final ParameterValue[] EMPTY_VALUES = new ParameterValue[0];
    private final Map<String, ManifestAttribute> attributes = new TreeMap<String, ManifestAttribute>();
    private final File referenceFile;
    private static final String MANIFEST_VERSION = "Manifest-Version";

    private ManifestHolder(Manifest manifest, File referenceFile) {
        Attributes attr = manifest.getMainAttributes();
        for (Object key : attr.keySet()) {
            String name = key.toString();
            String[] values = BundleData.splitList(attr, name);
            this.attributes.put(name, new ManifestAttribute(name, values));
        }
        this.referenceFile = referenceFile;
    }

    static ManifestHolder fromManifest(Manifest manifest, File manifestFile) {
        if (manifest == null) {
            return null;
        }
        return new ManifestHolder(manifest, manifestFile);
    }

    private ParameterValue[] getValues(String key) {
        ManifestAttribute attr = this.attributes.get(key);
        if (attr == null) {
            return null;
        }
        return attr.values;
    }

    private ParameterValue[] safeList(String name) {
        ParameterValue[] result = this.getValues(name);
        if (result == null) {
            return EMPTY_VALUES;
        }
        return result;
    }

    ParameterValue[] getListAttribute(String name) {
        return this.safeList(name);
    }

    ParameterValue getSingleAttribute(String name) {
        return this.firstValue(name);
    }

    private ParameterValue firstValue(String key) {
        ParameterValue[] result = this.getValues(key);
        if (result == null || result.length < 1) {
            return null;
        }
        return result[0];
    }

    private String[] safeValueList(String name) {
        ParameterValue[] result = this.getValues(name);
        if (result == null) {
            return BundleData.EMPTY_STRINGS;
        }
        return ParameterValue.valuesFromList(result);
    }

    private String getSimple(String name) {
        ParameterValue pv = this.firstValue(name);
        if (pv == null) {
            return null;
        }
        return pv.value;
    }

    private boolean getBoolean(String name) {
        return Boolean.parseBoolean(this.getSimple(name));
    }

    private void putSimple(String name, String value) {
        this.attributes.put(name, new ManifestAttribute(name, value));
    }

    private void putList(String name, String[] values) {
        this.attributes.put(name, new ManifestAttribute(name, values));
    }

    private void putList(String name, ParameterValue[] values) {
        this.attributes.put(name, new ManifestAttribute(name, values));
    }

    ParameterValue getSymbolicName() {
        return this.firstValue("Bundle-SymbolicName");
    }

    String getDescription() {
        return this.getSimple("Bundle-Name");
    }

    String getActivator() {
        return this.getSimple("Bundle-Activator");
    }

    void setActivator(String activator) {
        if (activator == null) {
            this.attributes.remove("Bundle-Activator");
        } else {
            this.putSimple("Bundle-Activator", activator);
        }
    }

    void addDependency(String pluginName, boolean optional) {
        ManifestAttribute reqBundleAttr = this.attributes.get("Require-Bundle");
        ParameterValue[] dependencies = reqBundleAttr.values;
        ParameterValue[] newDependecies = new ParameterValue[dependencies.length + 1];
        System.arraycopy(dependencies, 0, newDependecies, 0, dependencies.length);
        String param = optional ? ";resolution:=optional" : "";
        newDependecies[newDependecies.length - 1] = new ParameterValue(String.valueOf(pluginName) + param);
        ManifestAttribute manifestAttr = new ManifestAttribute("Require-Bundle", newDependecies);
        this.attributes.put("Require-Bundle", manifestAttr);
    }

    ParameterValue[] getDependencies() {
        return this.safeList("Require-Bundle");
    }

    ParameterValue[] getMavenDependencies() {
        if (this.attributes.containsKey("WAMAS-Build-Maven")) {
            return this.safeList("WAMAS-Build-Maven");
        }
        return this.safeList("Build-Maven");
    }

    ParameterValue[] getImportPackages() {
        return this.safeList("Import-Package");
    }

    ParameterValue[] getExportPackages() {
        return this.safeList("Export-Package");
    }

    void setExportPackages(ParameterValue[] value) {
        if (value == null || value.length == 0) {
            this.attributes.remove("Export-Package");
        } else {
            this.putList("Export-Package", value);
        }
    }

    String getPlatformFilter() {
        return this.getSimple("Eclipse-PlatformFilter");
    }

    void setPlatformFilter(String value) {
        this.putSimple("Eclipse-PlatformFilter", value);
    }

    String[] getClassPath() {
        return this.safeValueList("Bundle-ClassPath");
    }

    void setClassPath(String[] values) {
        this.putList("Bundle-ClassPath", values);
    }

    ParameterValue[] getNativeCode() {
        return this.safeList("Bundle-NativeCode");
    }

    String[] getRequiredExecutionEnvironment() {
        return this.safeValueList("Bundle-RequiredExecutionEnvironment");
    }

    void setRequiredExecutionEnvironment(String[] values) {
        this.putList("Bundle-RequiredExecutionEnvironment", values);
    }

    void setAutomaticModuleName(String value) {
        this.putSimple("Automatic-Module-Name", value);
    }

    String getAutomaticModuleName() {
        return this.getSimple("Automatic-Module-Name");
    }

    String getBundleVersion() {
        return this.getSimple("Bundle-Version");
    }

    void setBundleVersion(String value) {
        this.putSimple("Bundle-Version", value);
    }

    String getBundleVendor() {
        return this.getSimple("Bundle-Vendor");
    }

    void setBundleVendor(String value) {
        this.putSimple("Bundle-Vendor", value);
    }

    String getActivationPolicy() {
        return this.getSimple("Bundle-ActivationPolicy");
    }

    void setLazyActivationPolicy() {
        this.putSimple("Bundle-ActivationPolicy", "lazy");
    }

    ParameterValue getFragmentHost() {
        return this.firstValue("Fragment-Host");
    }

    boolean getNeedUnpack() {
        ParameterValue value = this.firstValue("Eclipse-BundleShape");
        return value != null && value.value != null && value.value.equals("dir");
    }

    String[] getBinaryInclude() {
        return this.safeValueList("Binary-Include");
    }

    void write(File mfFile) throws IOException {
        ManifestAttribute mfVer;
        if (this.referenceFile != null) {
            this.calculateOrder();
        }
        if ((mfVer = this.attributes.get(MANIFEST_VERSION)) == null) {
            mfVer = new ManifestAttribute(MANIFEST_VERSION, "1.0");
            this.attributes.put(MANIFEST_VERSION, mfVer);
        }
        mfVer.order = Integer.MIN_VALUE;
        ArrayList<ManifestAttribute> sorted = new ArrayList<ManifestAttribute>(this.attributes.values());
        Collections.sort(sorted, new Comparator<ManifestAttribute>(){

            @Override
            public int compare(ManifestAttribute a1, ManifestAttribute a2) {
                if (a1.order < a2.order) {
                    return -1;
                }
                if (a1.order > a2.order) {
                    return 1;
                }
                return a1.name.compareTo(a2.name);
            }
        });
        try (FileWriter ps = new FileWriter(mfFile);){
            for (ManifestAttribute mf : sorted) {
                ManifestHolder.writeAttribute(mf.name, mf.values, ps);
            }
        }
    }

    private static void writeAttribute(String name, ParameterValue[] value, Writer ps) throws IOException {
        ps.write(name);
        ps.write(": ");
        boolean firstLine = true;
        ParameterValue[] parameterValueArray = value;
        int n = value.length;
        int n2 = 0;
        while (n2 < n) {
            ParameterValue pv = parameterValueArray[n2];
            if (firstLine) {
                firstLine = false;
            } else {
                ps.write(",\n ");
            }
            pv.write(ps);
            ++n2;
        }
        ps.write(10);
    }

    private void calculateOrder() {
        ArrayList<String> lines = new ArrayList<String>();
        try (LineNumberReader r = new LineNumberReader(new FileReader(this.referenceFile));){
            String line;
            while ((line = r.readLine()) != null) {
                lines.add(line);
            }
        }
        catch (Exception e) {
            Activator.log(4, "cannot read " + this.referenceFile, e);
            return;
        }
        int index = 0;
        for (String line : lines) {
            for (ManifestAttribute mf : this.attributes.values()) {
                if (!line.startsWith(String.valueOf(mf.name) + ':')) continue;
                mf.order = index;
                break;
            }
            ++index;
        }
    }

    public boolean migrateUnpackInformation() {
        if (this.getBoolean("Unpack")) {
            this.putSimple("Eclipse-BundleShape", "dir");
            this.attributes.remove("Unpack");
            return true;
        }
        return false;
    }

    public ParameterValue getBuddyPolicy() {
        return this.firstValue("Eclipse-BuddyPolicy");
    }

    public ParameterValue[] getBuddyRegistrations() {
        return this.safeList("Eclipse-RegisterBuddy");
    }
}

