/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.p2;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.engine.SimpleProfileRegistry;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.Util;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.tea.core.services.TaskingLog;
import org.eclipse.tea.library.build.internal.Activator;
import org.osgi.framework.BundleContext;

public class P2InstallationHelper {
    public static File getInstallLocation(TaskingLog console, String installableUnitId) {
        IProfile profile = P2InstallationHelper.loadSelfProfile(console);
        console.debug("looking up " + installableUnitId + " in profile: " + profile);
        IQuery tpQ = QueryUtil.createIUPropertyQuery((String)"org.eclipse.equinox.p2.name", (String)installableUnitId);
        IQueryResult result = profile.query(tpQ, (IProgressMonitor)new NullProgressMonitor());
        if (result.isEmpty()) {
            throw new IllegalStateException("cannot find '" + installableUnitId + "' in profile:  " + profile);
        }
        TreeSet ius = new TreeSet(Collections.reverseOrder());
        ius.addAll(result.toSet());
        IInstallableUnit rootIu = (IInstallableUnit)ius.first();
        console.debug("looking up '" + installableUnitId + "' from IU: " + rootIu);
        return P2InstallationHelper.getInstallLocation(profile, rootIu);
    }

    public static IProfile loadSelfProfile(TaskingLog log) {
        int retryCnt = 100;
        IProfile profile = null;
        while (profile == null && retryCnt-- > 0) {
            IProfileRegistry r = P2InstallationHelper.getProfileRegistry();
            if (r == null) {
                throw new IllegalStateException("no profile registry present");
            }
            profile = r.getProfile("_SELF_");
            if (profile == null) {
                return null;
            }
            log.debug("p2 gave us this profile: " + profile + "(timestamp: " + profile.getTimestamp() + ")");
            if (profile.getTimestamp() != 0L) continue;
            profile = null;
            if (r instanceof SimpleProfileRegistry) {
                ((SimpleProfileRegistry)r).resetProfiles();
            }
            try {
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (profile == null) {
            throw new RuntimeException("cannot load profile");
        }
        return profile;
    }

    private static File getInstallLocation(IProfile profile, IInstallableUnit rootIu) {
        IProvisioningAgent agent = P2InstallationHelper.getProvisioningAgent();
        Collection requirements = rootIu.getRequirements();
        if (requirements.isEmpty()) {
            throw new IllegalStateException("cannot find requirements for " + rootIu);
        }
        for (IRequirement req : requirements) {
            IQueryResult iuqr = profile.query(QueryUtil.createMatchQuery((IExpression)req.getMatches(), (Object[])new Object[0]), (IProgressMonitor)new NullProgressMonitor());
            for (IInstallableUnit iu : iuqr) {
                IArtifactKey key;
                File dir;
                Collection artifacts = iu.getArtifacts();
                if (artifacts == null || artifacts.isEmpty() || (dir = Util.getArtifactFile((IProvisioningAgent)agent, (IArtifactKey)(key = (IArtifactKey)artifacts.iterator().next()), (IProfile)profile)) == null || !dir.isDirectory()) continue;
                return dir;
            }
        }
        throw new IllegalStateException("cannot find install location for " + rootIu);
    }

    private static IProvisioningAgent getProvisioningAgent() {
        return (IProvisioningAgent)ServiceHelper.getService((BundleContext)Activator.getContext(), (String)IProvisioningAgent.SERVICE_NAME);
    }

    private static IProfileRegistry getProfileRegistry() {
        return (IProfileRegistry)P2InstallationHelper.getProvisioningAgent().getService(IProfileRegistry.SERVICE_NAME);
    }
}

