/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.tasks.p2;

import java.util.Collections;
import java.util.List;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.tea.library.build.jar.JarManager;
import org.eclipse.tea.library.build.model.FeatureBuild;
import org.eclipse.tea.library.build.model.WorkspaceBuild;

public class TaskUpdateStrictFeatureVersions {
    private final String feature;
    private FeatureBuild fb;

    private TaskUpdateStrictFeatureVersions(String feature) {
        this.feature = feature;
    }

    public static TaskUpdateStrictFeatureVersions create(String feature, List<TaskUpdateStrictFeatureVersions> updates) {
        TaskUpdateStrictFeatureVersions t = new TaskUpdateStrictFeatureVersions(feature);
        updates.add(t);
        return t;
    }

    public String toString() {
        return "Update plugin versions for " + this.feature;
    }

    @Execute
    public void update(WorkspaceBuild wb, JarManager jm) throws Exception {
        this.fb = wb.getFeature(this.feature);
        if (this.fb == null) {
            return;
        }
        this.fb.backupFeatureXml();
        this.fb.generateFeatureXml(jm, Collections.emptyList(), this.fb.getIncludedPlugins());
    }

    public Object restore() {
        return new Object(){

            @Execute
            public void restore() {
                if (TaskUpdateStrictFeatureVersions.this.fb != null) {
                    try {
                        TaskUpdateStrictFeatureVersions.this.fb.restoreFeatureXml();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }

            public String toString() {
                return "Restore feature.xml for " + TaskUpdateStrictFeatureVersions.this.feature;
            }
        };
    }
}

