/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.accservice.swtbridge.internal.ia2;

import org.eclipse.actf.accservice.swtbridge.ia2.AccessibleText;
import org.eclipse.actf.accservice.swtbridge.ia2.TextSegment;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.IAccessibleText;
import org.eclipse.actf.util.win32.MemoryUtil;
import org.eclipse.actf.util.win32.NativeIntAccess;
import org.eclipse.actf.util.win32.NativeStringAccess;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.ole.win32.COM;

public class InternalAccessibleText
implements AccessibleText {
    private IAccessibleText accessibleText = null;

    public InternalAccessibleText(int n) {
        this.accessibleText = new IAccessibleText(n);
        this.accessibleText.AddRef();
    }

    public void dispose() {
        if (this.accessibleText != null) {
            this.accessibleText.Release();
            this.accessibleText = null;
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public boolean addSelection(int n, int n2) {
        if (this.accessibleText != null) {
            return this.accessibleText.addSelection(n, n2) == 0;
        }
        return false;
    }

    public TextSegment getCharacterAttributes(int n) {
        if (this.accessibleText != null) {
            NativeIntAccess nativeIntAccess = new NativeIntAccess(2);
            NativeStringAccess nativeStringAccess = new NativeStringAccess();
            try {
                if (this.accessibleText.get_attributes(n, nativeIntAccess.getAddress(0), nativeIntAccess.getAddress(1), nativeStringAccess.getAddress()) == 0) {
                    TextSegment textSegment = new TextSegment(nativeStringAccess.getString(), nativeIntAccess.getInt(0), nativeIntAccess.getInt(1));
                    return textSegment;
                }
            }
            catch (Exception exception) {
            }
            finally {
                nativeStringAccess.dispose();
                nativeIntAccess.dispose();
            }
        }
        return null;
    }

    public int getCaretPosition() {
        if (this.accessibleText != null) {
            NativeIntAccess nativeIntAccess = new NativeIntAccess();
            try {
                if (this.accessibleText.get_caretOffset(nativeIntAccess.getAddress()) == 0) {
                    int n = nativeIntAccess.getInt();
                    return n;
                }
            }
            catch (Exception exception) {
            }
            finally {
                nativeIntAccess.dispose();
            }
        }
        return -1;
    }

    public Rectangle getCharacterBounds(int n, int n2) {
        if (this.accessibleText != null) {
            NativeIntAccess nativeIntAccess = new NativeIntAccess(4);
            try {
                if (this.accessibleText.get_characterExtents(n, n2, nativeIntAccess.getAddress(0), nativeIntAccess.getAddress(1), nativeIntAccess.getAddress(2), nativeIntAccess.getAddress(3)) == 0) {
                    Rectangle rectangle = new Rectangle(nativeIntAccess.getInt(0), nativeIntAccess.getInt(1), nativeIntAccess.getInt(2), nativeIntAccess.getInt(3));
                    return rectangle;
                }
            }
            catch (Exception exception) {
            }
            finally {
                nativeIntAccess.dispose();
            }
        }
        return null;
    }

    public int getSelectionCount() {
        if (this.accessibleText != null) {
            NativeIntAccess nativeIntAccess = new NativeIntAccess();
            try {
                if (this.accessibleText.get_nSelections(nativeIntAccess.getAddress()) == 0) {
                    int n = nativeIntAccess.getInt();
                    return n;
                }
            }
            catch (Exception exception) {
            }
            finally {
                nativeIntAccess.dispose();
            }
        }
        return 0;
    }

    public int getIndexAtPoint(Point point, int n) {
        if (this.accessibleText != null) {
            NativeIntAccess nativeIntAccess = new NativeIntAccess();
            try {
                if (this.accessibleText.get_offsetAtPoint(point.x, point.y, n, nativeIntAccess.getAddress()) == 0) {
                    int n2 = nativeIntAccess.getInt();
                    return n2;
                }
            }
            catch (Exception exception) {
            }
            finally {
                nativeIntAccess.dispose();
            }
        }
        return -1;
    }

    public Point getSelection(int n) {
        if (this.accessibleText != null) {
            NativeIntAccess nativeIntAccess = new NativeIntAccess(2);
            try {
                if (this.accessibleText.get_selection(n, nativeIntAccess.getAddress(0), nativeIntAccess.getAddress(1)) == 0) {
                    Point point = new Point(nativeIntAccess.getInt(0), nativeIntAccess.getInt(1));
                    return point;
                }
            }
            catch (Exception exception) {
            }
            finally {
                nativeIntAccess.dispose();
            }
        }
        return null;
    }

    public String getTextRange(int n, int n2) {
        if (this.accessibleText != null) {
            NativeStringAccess nativeStringAccess = new NativeStringAccess();
            try {
                if (this.accessibleText.get_text(n, n2, nativeStringAccess.getAddress()) == 0) {
                    String string = nativeStringAccess.getString();
                    return string;
                }
            }
            catch (Exception exception) {
            }
            finally {
                nativeStringAccess.dispose();
            }
        }
        return null;
    }

    public TextSegment getTextBeforeIndex(int n, int n2) {
        if (this.accessibleText != null) {
            NativeIntAccess nativeIntAccess = new NativeIntAccess(2);
            NativeStringAccess nativeStringAccess = new NativeStringAccess();
            try {
                if (this.accessibleText.get_textBeforeOffset(n, n2, nativeIntAccess.getAddress(0), nativeIntAccess.getAddress(1), nativeStringAccess.getAddress()) == 0) {
                    TextSegment textSegment = new TextSegment(nativeStringAccess.getString(), nativeIntAccess.getInt(0), nativeIntAccess.getInt(1));
                    return textSegment;
                }
            }
            catch (Exception exception) {
            }
            finally {
                nativeStringAccess.dispose();
                nativeIntAccess.dispose();
            }
        }
        return null;
    }

    public TextSegment getTextAfterIndex(int n, int n2) {
        if (this.accessibleText != null) {
            NativeIntAccess nativeIntAccess = new NativeIntAccess(2);
            NativeStringAccess nativeStringAccess = new NativeStringAccess();
            try {
                if (this.accessibleText.get_textAfterOffset(n, n2, nativeIntAccess.getAddress(0), nativeIntAccess.getAddress(1), nativeStringAccess.getAddress()) == 0) {
                    TextSegment textSegment = new TextSegment(nativeStringAccess.getString(), nativeIntAccess.getInt(0), nativeIntAccess.getInt(1));
                    return textSegment;
                }
            }
            catch (Exception exception) {
            }
            finally {
                nativeStringAccess.dispose();
                nativeIntAccess.dispose();
            }
        }
        return null;
    }

    public TextSegment getTextAtIndex(int n, int n2) {
        if (this.accessibleText != null) {
            NativeIntAccess nativeIntAccess = new NativeIntAccess(2);
            NativeStringAccess nativeStringAccess = new NativeStringAccess();
            try {
                if (this.accessibleText.get_textAtOffset(n, n2, nativeIntAccess.getAddress(0), nativeIntAccess.getAddress(1), nativeStringAccess.getAddress()) == 0) {
                    TextSegment textSegment = new TextSegment(nativeStringAccess.getString(), nativeIntAccess.getInt(0), nativeIntAccess.getInt(1));
                    return textSegment;
                }
            }
            catch (Exception exception) {
            }
            finally {
                nativeStringAccess.dispose();
                nativeIntAccess.dispose();
            }
        }
        return null;
    }

    public boolean removeSelection(int n) {
        if (this.accessibleText != null) {
            return this.accessibleText.removeSelection(n) == 0;
        }
        return false;
    }

    public boolean setCaretPosition(int n) {
        if (this.accessibleText != null) {
            return this.accessibleText.setCaretOffset(n) == 0;
        }
        return false;
    }

    public boolean setSelection(int n, int n2, int n3) {
        if (this.accessibleText != null) {
            return this.accessibleText.setSelection(n, n2, n3) == 0;
        }
        return false;
    }

    public int getCharacterCount() {
        if (this.accessibleText != null) {
            NativeIntAccess nativeIntAccess = new NativeIntAccess();
            try {
                if (this.accessibleText.get_nCharacters(nativeIntAccess.getAddress()) == 0) {
                    int n = nativeIntAccess.getInt();
                    return n;
                }
            }
            catch (Exception exception) {
            }
            finally {
                nativeIntAccess.dispose();
            }
        }
        return 0;
    }

    public boolean scrollSubstringTo(int n, int n2, int n3) {
        if (this.accessibleText != null) {
            return this.accessibleText.scrollSubstringTo(n, n2, n3) == 0;
        }
        return false;
    }

    public boolean scrollSubstringToPoint(int n, int n2, int n3, int n4, int n5) {
        if (this.accessibleText != null) {
            return this.accessibleText.scrollSubstringToPoint(n, n2, n3, n4, n5) == 0;
        }
        return false;
    }

    public TextSegment getNewText() {
        if (this.accessibleText != null) {
            NativeIntAccess nativeIntAccess = new NativeIntAccess(3);
            try {
                if (this.accessibleText.get_newText(nativeIntAccess.getAddress()) == 0) {
                    TextSegment textSegment = InternalAccessibleText.getTextSegment(nativeIntAccess);
                    return textSegment;
                }
            }
            catch (Exception exception) {
            }
            finally {
                nativeIntAccess.dispose();
            }
        }
        return null;
    }

    public TextSegment getOldText() {
        if (this.accessibleText != null) {
            NativeIntAccess nativeIntAccess = new NativeIntAccess(3);
            try {
                if (this.accessibleText.get_oldText(nativeIntAccess.getAddress()) == 0) {
                    TextSegment textSegment = InternalAccessibleText.getTextSegment(nativeIntAccess);
                    return textSegment;
                }
            }
            catch (Exception exception) {
            }
            finally {
                nativeIntAccess.dispose();
            }
        }
        return null;
    }

    private static TextSegment getTextSegment(NativeIntAccess nativeIntAccess) {
        int[] nArray = new int[3];
        MemoryUtil.MoveMemory((int[])nArray, (int)nativeIntAccess.getAddress(), (int)(4 * nArray.length));
        if (nArray[0] != 0) {
            try {
                TextSegment textSegment = new TextSegment("", 0, 0);
                int n = COM.SysStringByteLen((int)nArray[0]);
                if (n > 0) {
                    char[] cArray = new char[(n + 1) / 2];
                    MemoryUtil.MoveMemory((char[])cArray, (int)nArray[0], (int)n);
                    textSegment.text = new String(cArray);
                }
                textSegment.start = nArray[1];
                textSegment.end = nArray[2];
                TextSegment textSegment2 = textSegment;
                return textSegment2;
            }
            finally {
                COM.SysFreeString((int)nArray[0]);
            }
        }
        return null;
    }
}

