/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.win32.comclutch.impl;

import java.util.UUID;
import org.eclipse.actf.util.win32.comclutch.IUnknown;
import org.eclipse.actf.util.win32.comclutch.ResourceManager;
import org.eclipse.actf.util.win32.comclutch.impl.IDispatchImpl;
import org.eclipse.actf.util.win32.comclutch.impl.IOleContainerImpl;
import org.eclipse.actf.util.win32.comclutch.impl.IResourceImpl;
import org.eclipse.actf.util.win32.comclutch.impl.IServiceProviderImpl;
import org.eclipse.actf.util.win32.msaa.impl.IAccessibleImpl;

public class IUnknownImpl
extends IResourceImpl
implements IUnknown {
    private int internalRefCount;
    private long ptr;

    public long getPtr() {
        return this.ptr;
    }

    public IUnknown queryInterface(UUID iid) {
        IUnknown iunk = this._queryInterface(this.ptr, iid.getMostSignificantBits(), iid.getLeastSignificantBits());
        if (iunk instanceof IUnknownImpl) {
            IUnknownImpl iunkImpl = (IUnknownImpl)iunk;
            if (iid.equals(IUnknown.IID_IOleContainer)) {
                IOleContainerImpl ioc = new IOleContainerImpl(iunkImpl);
                iunk.release();
                return ioc;
            }
            if (iid.equals(IUnknown.IID_IWebBrowser2)) {
                IDispatchImpl idisp = new IDispatchImpl(iunkImpl);
                iunk.release();
                return idisp;
            }
            if (iid.equals(IUnknown.IID_IAccessible)) {
                IAccessibleImpl iacc = new IAccessibleImpl(iunkImpl);
                iunk.release();
                return iacc;
            }
            if (iid.equals(IUnknown.IID_IServiceProvider)) {
                IServiceProviderImpl isp = new IServiceProviderImpl(iunkImpl);
                iunk.release();
                return isp;
            }
        }
        return iunk;
    }

    public void release() {
        super.release();
        while (this.internalRefCount > 0) {
            this._release(this.ptr);
            --this.internalRefCount;
        }
    }

    public int getTotalRefCount() {
        int r = this._addRef(this.ptr);
        this._release(this.ptr);
        return r - 1;
    }

    public IUnknownImpl(ResourceManager rm, long ptr, boolean permanent) {
        super(rm, permanent);
        this.ptr = ptr;
        this.internalRefCount = 1;
    }

    public IUnknownImpl(ResourceManager rm, IUnknown base) {
        this(rm, base.getPtr(), false);
        base.addRef(base.getPtr());
    }

    protected IUnknownImpl(IUnknownImpl base) {
        this(base.getResourceManager(), base.ptr, false);
        this.addRef(this.ptr);
    }

    private native int _release(long var1);

    private native int _addRef(long var1);

    private native IUnknown _queryInterface(long var1, long var3, long var5);

    private static native void _addReleaseWaitQueue(long var0);

    protected void finalize() {
        if (!this.isPermanent()) {
            while (this.internalRefCount > 0) {
                IUnknownImpl._addReleaseWaitQueue(this.ptr);
                --this.internalRefCount;
            }
        }
    }

    public static IUnknown newIUnknown(ResourceManager rm, long ptr, boolean permanent) {
        IUnknownImpl iunk = new IUnknownImpl(rm, ptr, permanent);
        rm.addResource(iunk);
        return iunk;
    }

    public IUnknown newIUnknown(long ptr) {
        IUnknown iunk = (IUnknown)this.findInResource(ptr);
        if (iunk != null) {
            if (iunk instanceof IUnknownImpl) {
                ++((IUnknownImpl)iunk).internalRefCount;
            }
        } else {
            iunk = new IUnknownImpl(this.getResourceManager(), ptr, false);
            this.addResource(iunk);
        }
        return iunk;
    }

    public void addRef(long ptr) {
        this._addRef(ptr);
    }
}

