/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.checker;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Stack;
import java.util.Vector;
import org.eclipse.actf.visualization.engines.lowvision.LowVisionType;
import org.eclipse.actf.visualization.engines.lowvision.image.ImageException;
import org.eclipse.actf.visualization.internal.engines.lowvision.DecisionMaker;
import org.eclipse.actf.visualization.internal.engines.lowvision.character.CharacterMS;
import org.eclipse.actf.visualization.internal.engines.lowvision.character.CharacterSM;
import org.eclipse.actf.visualization.internal.engines.lowvision.character.CharacterSS;
import org.eclipse.actf.visualization.internal.engines.lowvision.checker.W3CColorChecker;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorIRGB;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.BinaryImage;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.ConnectedComponent;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Container;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.IInt2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Int2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.PageImage;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Topology;
import org.eclipse.actf.visualization.internal.engines.lowvision.operator.LowVisionFilter;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.BlurProblem;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.ColorProblem;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionProblem;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionProblemException;
import org.eclipse.actf.visualization.internal.engines.lowvision.problem.LowVisionProblemGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharacterChecker {
    public static final double THRESHOLD_MIN_SM_COLOR_PROBLEM_RATIO = 0.8;
    private PageImage pageImage;

    public CharacterChecker(PageImage pageImage) {
        this.pageImage = pageImage;
    }

    public LowVisionProblemGroup[] checkAllCharacters(LowVisionType _lvType) throws ImageException, LowVisionProblemException {
        if (_lvType.countTypes() == 0) {
            return new LowVisionProblemGroup[0];
        }
        Vector<LowVisionProblem> problemVec = new Vector<LowVisionProblem>();
        int k = 0;
        while (k < this.pageImage.getNumContainers()) {
            LowVisionProblem prob;
            Container cont = this.pageImage.getContainers()[k];
            Vector<LowVisionProblem> tmpProblemVec = new Vector<LowVisionProblem>();
            int l = 0;
            while (l < cont.getNumSSCharacters()) {
                prob = this.checkOneSSCharacter(cont.getSsCharacters()[l], _lvType);
                if (prob != null) {
                    tmpProblemVec.addElement(prob);
                }
                ++l;
            }
            l = 0;
            while (l < cont.getNumMSCharacters()) {
                prob = this.checkOneMSCharacter(cont.getMsCharacters()[l], _lvType);
                if (prob != null) {
                    tmpProblemVec.addElement(prob);
                }
                ++l;
            }
            l = 0;
            while (l < cont.getNumSMCharacters()) {
                prob = this.checkOneSMCharacter(cont.getSmCharacters()[l], _lvType);
                if (prob != null) {
                    tmpProblemVec.addElement(prob);
                }
                ++l;
            }
            Vector<LowVisionProblemGroup> curProblemVec = this.collectProblems(tmpProblemVec);
            if (curProblemVec != null) {
                int curSize = curProblemVec.size();
                int m = 0;
                while (m < curSize) {
                    problemVec.addElement(curProblemVec.elementAt(m));
                    ++m;
                }
            }
            ++k;
        }
        Vector<LowVisionProblem> tmpProblemVec = new Vector<LowVisionProblem>();
        int k2 = 0;
        while (k2 < this.pageImage.getNumNonContainedCharacters()) {
            LowVisionProblem prob = this.checkOneSMCharacter(this.pageImage.getNonContainedCharacters()[k2], _lvType);
            if (prob != null) {
                tmpProblemVec.addElement(prob);
            }
            ++k2;
        }
        Vector<LowVisionProblemGroup> curProblemVec = this.collectProblems(tmpProblemVec);
        if (curProblemVec != null) {
            int curSize = curProblemVec.size();
            int m = 0;
            while (m < curSize) {
                problemVec.addElement(curProblemVec.elementAt(m));
                ++m;
            }
        }
        Collections.sort(problemVec, new CompareByPriority());
        LowVisionProblemGroup[] problemArray = null;
        int problemVecSize = problemVec.size();
        if (problemVecSize > 0) {
            problemArray = new LowVisionProblemGroup[problemVecSize];
            int k3 = 0;
            while (k3 < problemVecSize) {
                problemArray[k3] = (LowVisionProblemGroup)problemVec.elementAt(k3);
                ++k3;
            }
            problemVec.removeAllElements();
            return problemArray;
        }
        return new LowVisionProblemGroup[0];
    }

    private LowVisionProblem simulateAndCheckMSCharacter(CharacterMS _msc, LowVisionType _lvType, int _bg) throws ImageException, LowVisionProblemException {
        ConnectedComponent cc;
        Topology simTopo;
        int ccTop;
        if (!_lvType.doBlur()) {
            return null;
        }
        int margin = 0;
        if (_lvType.doEyesight()) {
            margin = _lvType.getEyesightRadius();
        }
        IInt2D beforeI2d = _msc.makeMarginedImage(margin * 2);
        LowVisionFilter lvFilter = new LowVisionFilter(_lvType);
        Int2D afterI2d = null;
        try {
            afterI2d = new Int2D(lvFilter.filter(beforeI2d.toBufferedImage(), null));
        }
        catch (Exception exception) {
            throw new ImageException("Error occurred while simulating an MSCharacter.");
        }
        int afterWidth = afterI2d.getWidth() - 2 * margin;
        int afterHeight = afterI2d.getHeight() - 2 * margin;
        BinaryImage bin = new BinaryImage(afterWidth, afterHeight);
        HashMap<Integer, Boolean> answerMap = new HashMap<Integer, Boolean>();
        try {
            int j = 0;
            while (j < afterHeight) {
                int i = 0;
                while (i < afterWidth) {
                    int pixel = afterI2d.getData()[j + margin][i + margin];
                    if (pixel != _bg) {
                        Integer pixelInt = new Integer(pixel);
                        Boolean answerBool = (Boolean)answerMap.get(pixelInt);
                        if (answerBool == null) {
                            if (DecisionMaker.distinguishableTextColors(pixel, _bg)) {
                                bin.data[j][i] = 1;
                                answerMap.put(pixelInt, new Boolean(true));
                            } else {
                                answerMap.put(pixelInt, new Boolean(false));
                            }
                        } else if (answerBool.booleanValue()) {
                            bin.data[j][i] = 1;
                        }
                    }
                    ++i;
                }
                ++j;
            }
        }
        catch (Exception exception) {
            throw new ImageException("Error occurred while making binary image.");
        }
        int ccLeft = _msc.cc.getLeft() - margin;
        if (ccLeft < 0) {
            ccLeft = 0;
        }
        if ((ccTop = _msc.cc.getTop() - margin) < 0) {
            ccTop = 0;
        }
        if ((simTopo = (cc = new ConnectedComponent(ccLeft, ccTop, bin, 2)).thinning().calcTopology()).match(_msc.getTopology())) {
            return null;
        }
        double probability = 1.0;
        if (_msc.getTopology().getCount() > 0 && (probability = (double)Math.abs(_msc.getTopology().getCount() - simTopo.getCount()) / (double)_msc.getTopology().getCount()) > 1.0) {
            probability = 1.0;
        }
        return new BlurProblem(_msc, _lvType, probability);
    }

    private LowVisionProblem simulateAndCheckSMCharacter(CharacterSM _smc, LowVisionType _lvType, int _fg) throws ImageException, LowVisionProblemException {
        ConnectedComponent cc;
        Topology simTopo;
        int ccTop;
        if (!_lvType.doBlur()) {
            return null;
        }
        int margin = 0;
        if (_lvType.doEyesight()) {
            margin = _lvType.getEyesightRadius();
        }
        IInt2D beforeI2d = _smc.makeMarginedImage(margin * 2);
        LowVisionFilter lvFilter = new LowVisionFilter(_lvType);
        Int2D afterI2d = null;
        try {
            afterI2d = new Int2D(lvFilter.filter(beforeI2d.toBufferedImage(), null));
        }
        catch (Exception exception) {
            throw new ImageException("Error occurred while simulating an SMCharacter.");
        }
        int afterWidth = afterI2d.getWidth() - 2 * margin;
        int afterHeight = afterI2d.getHeight() - 2 * margin;
        BinaryImage bin = new BinaryImage(afterWidth, afterHeight);
        HashMap<Integer, Boolean> answerMap = new HashMap<Integer, Boolean>();
        try {
            int j = 0;
            while (j < afterHeight) {
                int i = 0;
                while (i < afterWidth) {
                    int pixel = afterI2d.getData()[j + margin][i + margin];
                    if (pixel == _fg) {
                        bin.data[j][i] = 1;
                    } else {
                        Integer pixelInt = new Integer(pixel);
                        Boolean answerBool = (Boolean)answerMap.get(pixelInt);
                        if (answerBool == null) {
                            if (!DecisionMaker.distinguishableTextColors(pixel, _fg)) {
                                bin.data[j][i] = 1;
                                answerMap.put(pixelInt, new Boolean(false));
                            } else {
                                answerMap.put(pixelInt, new Boolean(true));
                            }
                        } else if (!answerBool.booleanValue()) {
                            bin.data[j][i] = 1;
                        }
                    }
                    ++i;
                }
                ++j;
            }
        }
        catch (Exception exception) {
            throw new ImageException("Error occurred while making binary image.");
        }
        int ccLeft = _smc.cc.getLeft() - margin;
        if (ccLeft < 0) {
            ccLeft = 0;
        }
        if ((ccTop = _smc.cc.getTop() - margin) < 0) {
            ccTop = 0;
        }
        if ((simTopo = (cc = new ConnectedComponent(ccLeft, ccTop, bin, 2)).thinning().calcTopology()).match(_smc.getTopology())) {
            return null;
        }
        double probability = 1.0;
        if (_smc.getTopology().getCount() > 0 && (probability = (double)Math.abs(_smc.getTopology().getCount() - simTopo.getCount()) / (double)_smc.getTopology().getCount()) > 1.0) {
            probability = 1.0;
        }
        return new BlurProblem(_smc, _lvType, probability);
    }

    private LowVisionProblem simulateAndCheckSSCharacter(CharacterSS _ssc, LowVisionType _lvType, int _bg) throws ImageException, LowVisionProblemException {
        ConnectedComponent cc;
        Topology simTopo;
        int ccTop;
        int margin = 0;
        if (_lvType.doEyesight()) {
            margin = _lvType.getEyesightRadius();
        }
        IInt2D beforeI2d = _ssc.makeMarginedImage(margin * 2);
        LowVisionFilter lvFilter = new LowVisionFilter(_lvType);
        Int2D afterI2d = null;
        try {
            afterI2d = new Int2D(lvFilter.filter(beforeI2d.toBufferedImage(), null));
        }
        catch (Exception exception) {
            throw new ImageException("Error occurred while simulating an SSCharacter.");
        }
        int afterWidth = afterI2d.getWidth() - 2 * margin;
        int afterHeight = afterI2d.getHeight() - 2 * margin;
        BinaryImage bin = new BinaryImage(afterWidth, afterHeight);
        HashMap<Integer, Boolean> answerMap = new HashMap<Integer, Boolean>();
        try {
            int j = 0;
            while (j < afterHeight) {
                int i = 0;
                while (i < afterWidth) {
                    int pixel = afterI2d.getData()[j + margin][i + margin];
                    if (pixel != _bg) {
                        Integer pixelInt = new Integer(pixel);
                        Boolean answerBool = (Boolean)answerMap.get(pixelInt);
                        if (answerBool == null) {
                            if (DecisionMaker.distinguishableTextColors(pixel, _bg)) {
                                bin.data[j][i] = 1;
                                answerMap.put(pixelInt, new Boolean(true));
                            } else {
                                answerMap.put(pixelInt, new Boolean(false));
                            }
                        } else if (answerBool.booleanValue()) {
                            bin.data[j][i] = 1;
                        }
                    }
                    ++i;
                }
                ++j;
            }
        }
        catch (Exception exception) {
            throw new ImageException("Error occurred while making binary image.");
        }
        int ccLeft = _ssc.cc.getLeft() - margin;
        if (ccLeft < 0) {
            ccLeft = 0;
        }
        if ((ccTop = _ssc.cc.getTop() - margin) < 0) {
            ccTop = 0;
        }
        if ((simTopo = (cc = new ConnectedComponent(ccLeft, ccTop, bin, 2)).thinning().calcTopology()).match(_ssc.getTopology())) {
            return null;
        }
        double probability = 1.0;
        if (_ssc.getTopology().getCount() > 0 && (probability = (double)Math.abs(_ssc.getTopology().getCount() - simTopo.getCount()) / (double)_ssc.getTopology().getCount()) > 1.0) {
            probability = 1.0;
        }
        return new BlurProblem(_ssc, _lvType, probability);
    }

    private LowVisionProblem checkOneMSCharacter(CharacterMS _msc, LowVisionType _lvType) throws ImageException, LowVisionProblemException {
        int simBgColor = _msc.getBackgroundColor();
        if (_lvType.doChangeColors()) {
            try {
                simBgColor = _lvType.convertColor(_msc.getBackgroundColor());
                int simFgColor = _lvType.convertColor(_msc.getForegroundColor());
                double sev = W3CColorChecker.calcSeverity(new ColorIRGB(simFgColor), new ColorIRGB(simBgColor));
                if (sev > 0.0) {
                    return new ColorProblem(_msc, _lvType, sev);
                }
            }
            catch (Exception exception) {}
        }
        if (_lvType.doBlur()) {
            return this.simulateAndCheckMSCharacter(_msc, _lvType, simBgColor);
        }
        return null;
    }

    private LowVisionProblem checkOneSMCharacter(CharacterSM _smc, LowVisionType _lvType) throws ImageException, LowVisionProblemException {
        int simFgColor = _smc.getForegroundColor();
        if (_lvType.doChangeColors()) {
            try {
                simFgColor = _lvType.convertColor(_smc.getForegroundColor());
                int badCount = 0;
                int w = _smc.getWidth();
                int h = _smc.getHeight();
                int[][] im = _smc.getImage();
                byte[][] data = _smc.cc.getShape().getData();
                HashMap<Integer, Boolean> map = new HashMap<Integer, Boolean>();
                int j = 0;
                while (j < h) {
                    int i = 0;
                    while (i < w) {
                        if (data[j][i] == 0) {
                            int simBg = _lvType.convertColor(im[j][i]);
                            Integer bgInt = new Integer(simBg);
                            Boolean bgBool = (Boolean)map.get(bgInt);
                            if (bgBool == null) {
                                if (!DecisionMaker.distinguishableTextColors(simFgColor, simBg)) {
                                    ++badCount;
                                    map.put(bgInt, new Boolean(false));
                                } else {
                                    map.put(bgInt, new Boolean(true));
                                }
                            } else if (!bgBool.booleanValue()) {
                                ++badCount;
                            }
                        }
                        ++i;
                    }
                    ++j;
                }
                double badRatio = (double)badCount / (double)(w * h - _smc.cc.getCount());
                if (badRatio >= 0.8) {
                    double probability = (badRatio - 0.8) / 0.19999999999999996;
                    return new ColorProblem(_smc, _lvType, probability);
                }
            }
            catch (Exception exception) {}
        }
        if (_lvType.doBlur()) {
            return this.simulateAndCheckSMCharacter(_smc, _lvType, simFgColor);
        }
        return null;
    }

    private LowVisionProblem checkOneSSCharacter(CharacterSS _ssc, LowVisionType _lvType) throws ImageException, LowVisionProblemException {
        int simBgColor = _ssc.getBackgroundColor();
        if (_lvType.doChangeColors()) {
            try {
                int simFgColor = _lvType.convertColor(_ssc.getForegroundColor());
                simBgColor = _lvType.convertColor(_ssc.getBackgroundColor());
                double sev = W3CColorChecker.calcSeverity(new ColorIRGB(simFgColor), new ColorIRGB(simBgColor));
                if (sev > 0.0) {
                    return new ColorProblem(_ssc, _lvType, sev);
                }
            }
            catch (Exception exception) {
                throw new ImageException("An error occurred while checking colors of an SSCharacter.");
            }
        }
        if (_lvType.doBlur()) {
            return this.simulateAndCheckSSCharacter(_ssc, _lvType, simBgColor);
        }
        return null;
    }

    private Vector<LowVisionProblemGroup> collectProblems(Vector<LowVisionProblem> _tmpVec) throws ImageException {
        int size = _tmpVec.size();
        if (size == 0) {
            return null;
        }
        int[] idMap = new int[size];
        int id = 1;
        int i = 0;
        while (i < size) {
            LowVisionProblem curProb = _tmpVec.elementAt(i);
            if (idMap[i] == 0) {
                idMap[i] = id;
                this.assignProblemGroupID(curProb, id, _tmpVec, size, idMap);
                ++id;
            }
            ++i;
        }
        Vector<LowVisionProblemGroup> resultVec = new Vector<LowVisionProblemGroup>();
        int i2 = 1;
        while (i2 < id) {
            this.makeProblemGroupByID(resultVec, i2, _tmpVec, size, idMap);
            ++i2;
        }
        return resultVec;
    }

    private void assignProblemGroupID(LowVisionProblem _curProb, int _id, Vector<LowVisionProblem> _tmpVec, int _size, int[] _idMap) throws ImageException {
        try {
            Stack<LowVisionProblem> searchStack = new Stack<LowVisionProblem>();
            searchStack.push(_curProb);
            while (!searchStack.empty()) {
                LowVisionProblem sProb = (LowVisionProblem)searchStack.pop();
                int i = 0;
                while (i < _size) {
                    LowVisionProblem tmpProb;
                    if (_idMap[i] == 0 && DecisionMaker.areSameGroupProblems(sProb, tmpProb = _tmpVec.elementAt(i))) {
                        _idMap[i] = _id;
                        searchStack.push(tmpProb);
                    }
                    ++i;
                }
            }
        }
        catch (LowVisionProblemException lowVisionProblemException) {
            throw new ImageException("Error occurred while making problem group.");
        }
    }

    private void makeProblemGroupByID(Vector<LowVisionProblemGroup> _resultVec, int _id, Vector<LowVisionProblem> _tmpVec, int _size, int[] _idMap) throws ImageException {
        Vector<LowVisionProblem> groupVector = new Vector<LowVisionProblem>();
        int i = 0;
        while (i < _size) {
            if (_idMap[i] == _id) {
                LowVisionProblem curProb = _tmpVec.elementAt(i);
                groupVector.addElement(curProb);
            }
            ++i;
        }
        int groupSize = groupVector.size();
        if (groupSize <= 0) {
            throw new ImageException("No instance belongs to the group. id = " + _id);
        }
        LowVisionProblemGroup pg = null;
        try {
            pg = new LowVisionProblemGroup(groupVector);
        }
        catch (LowVisionProblemException lowVisionProblemException) {
            throw new ImageException("LowVisionProblemGroup cannot be constracted.");
        }
        _resultVec.addElement(pg);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CompareByPriority
    implements Comparator<LowVisionProblem> {
        private CompareByPriority() {
        }

        @Override
        public int compare(LowVisionProblem _o1, LowVisionProblem _o2) {
            return _o2.getPriority() - _o1.getPriority();
        }
    }
}

