/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.image;

import org.eclipse.actf.visualization.internal.engines.lowvision.image.Coord;

public class LineSegment {
    public static final short POINT = 0;
    public static final short HORIZONTAL_LINE = 1;
    public static final short VERTICAL_LINE = 2;
    public static final short DIAGONAL_LINE = 3;
    int x0;
    int y0;
    int x1;
    int y1;

    public LineSegment(int _x0, int _y0, int _x1, int _y1) {
        if (_x0 < _x1) {
            this.x0 = _x0;
            this.y0 = _y0;
            this.x1 = _x1;
            this.y1 = _y1;
        } else if (_x0 > _x1) {
            this.x0 = _x1;
            this.y0 = _y1;
            this.x1 = _x0;
            this.y1 = _y0;
        } else if (_y0 <= _y1) {
            this.x0 = _x0;
            this.y0 = _y0;
            this.x1 = _x1;
            this.y1 = _y1;
        } else {
            this.x0 = _x1;
            this.y0 = _y1;
            this.x1 = _x0;
            this.y1 = _y0;
        }
    }

    public LineSegment(Coord _co0, Coord _co1) {
        this(_co0.x, _co0.y, _co1.x, _co1.y);
    }

    public Coord getLeftPoint() {
        return new Coord(this.x0, this.y0);
    }

    public Coord getRightPoint() {
        return new Coord(this.x1, this.y1);
    }

    public Coord getUpperPoint() {
        if (this.y0 <= this.y1) {
            return new Coord(this.x0, this.y0);
        }
        return new Coord(this.x1, this.y1);
    }

    public Coord getLowerPoint() {
        if (this.y0 > this.y1) {
            return new Coord(this.x0, this.y0);
        }
        return new Coord(this.x1, this.y1);
    }

    public short getType() {
        if (this.x0 == this.x1) {
            if (this.y0 == this.y1) {
                return 0;
            }
            return 2;
        }
        if (this.y0 == this.y1) {
            return 1;
        }
        return 3;
    }

    public boolean isPoint() {
        return this.getType() == 0;
    }

    public boolean isVertical() {
        return this.getType() == 2;
    }

    public boolean isHorizontal() {
        return this.getType() == 1;
    }

    public boolean isDiagonal() {
        return this.getType() == 3;
    }

    public double getLength() {
        int xDiff = this.x1 - this.x0 + 1;
        int yDiff = this.y1 - this.y0 + 1;
        if (this.x0 == this.x1) {
            return Math.abs(yDiff);
        }
        if (this.y0 == this.y1) {
            return Math.abs(xDiff);
        }
        return Math.sqrt(xDiff * xDiff + yDiff * yDiff);
    }
}

