/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.image;

import org.eclipse.actf.visualization.engines.lowvision.image.ImageException;
import org.eclipse.actf.visualization.internal.engines.lowvision.DebugUtil;
import org.eclipse.actf.visualization.internal.engines.lowvision.character.CharacterSS;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorUtil;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.ConnectedComponent;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Container;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.IInt2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Int2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.PageComponent;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.PageImage;

public class PageImageDebugUtil {
    private PageImage pageImage;

    PageImageDebugUtil(PageImage pageImage) {
        this.pageImage = pageImage;
    }

    public void paintOnePageComponent(PageComponent _com, int[][] _image, int _color) {
        int startX = _com.cc.left;
        int startY = _com.cc.top;
        int paintW = _com.cc.shape.width;
        int paintH = _com.cc.shape.height;
        int j = 0;
        while (j < paintH) {
            int i = 0;
            while (i < paintW) {
                if (_com.cc.shape.data[j][i] != 0) {
                    _image[j + startY][i + startX] = _color;
                }
                ++i;
            }
            ++j;
        }
    }

    public int[][] paintContainers(int[][] _image, int _color) {
        if (this.pageImage.numContainers == 0) {
            DebugUtil.errMsg(this, "There are no containers.");
            return null;
        }
        DebugUtil.debugMsg(null, "# of containers = " + this.pageImage.numContainers, "CONTAINER");
        int i = 0;
        while (i < this.pageImage.numContainers) {
            Container curContainer = this.pageImage.containers[i];
            this.paintOnePageComponent(curContainer, _image, _color);
            ++i;
        }
        return _image;
    }

    public IInt2D showRepaintedContainerMap() {
        Int2D i2d = new Int2D(this.pageImage.pixel.getWidth(), this.pageImage.pixel.getHeight());
        int j = 0;
        while (j < this.pageImage.pixel.getHeight()) {
            int i = 0;
            while (i < this.pageImage.pixel.getWidth()) {
                i2d.getData()[j][i] = ColorUtil.distinguishableColor(this.pageImage.containerMap[j][i]);
                ++i;
            }
            ++j;
        }
        return i2d;
    }

    public IInt2D showAllSSCharacters() {
        return this.showAllSSCharacters(0xFF0000);
    }

    public IInt2D showAllSSCharacters(int _color) {
        Int2D i2d = new Int2D(this.pageImage.pixel.getWidth(), this.pageImage.pixel.getHeight());
        int k = 0;
        while (k < this.pageImage.containerVector.size()) {
            i2d = this.showSSCharactersInOneContainer(i2d, k, _color);
            ++k;
        }
        return i2d;
    }

    public Int2D showSSCharactersInOneContainer(Int2D _i2d, int _contIndex, int _color) {
        Container curCont = this.pageImage.containerVector.elementAt(_contIndex);
        int l = 0;
        while (l < curCont.ssCharacterVector.size()) {
            CharacterSS ssc = curCont.ssCharacterVector.elementAt(l);
            ConnectedComponent cc = ssc.cc;
            int j = 0;
            while (j < cc.shape.height) {
                int i = 0;
                while (i < cc.shape.width) {
                    if (cc.shape.data[j][i] != 0) {
                        _i2d.getData()[j + cc.top][i + cc.left] = _color;
                    }
                    ++i;
                }
                ++j;
            }
            ++l;
        }
        return _i2d;
    }

    public IInt2D showAllCharacters() {
        return this.showAllCharacters(0xFF0000, 65280, 255, 0xFFFF00);
    }

    public IInt2D showAllCharacters(int _ssColor, int _msColor, int _smColor1, int _smColor2) {
        Int2D i2d = new Int2D(this.pageImage.pixel.getWidth(), this.pageImage.pixel.getHeight());
        DebugUtil.debugMsg(this, "numContainers = " + this.pageImage.numContainers, "CONTAINER");
        int k = 0;
        while (k < this.pageImage.numContainers) {
            Container cont = this.pageImage.containers[k];
            i2d = this.showCharactersInOneContainer(i2d, cont, _ssColor, _msColor, _smColor1);
            ++k;
        }
        k = 0;
        while (k < this.pageImage.numNonContainedCharacters) {
            i2d = this.pageImage.nonContainedCharacters[k].cc.drawShape(i2d, _smColor2);
            ++k;
        }
        return i2d;
    }

    public Int2D showCharactersInOneContainer(Int2D _i2d, Container _cont, int _ssColor, int _msColor, int _smColor) {
        int l = 0;
        while (l < _cont.numSSCharacters) {
            _i2d = _cont.ssCharacters[l].cc.drawShape(_i2d, _ssColor);
            ++l;
        }
        l = 0;
        while (l < _cont.numMSCharacters) {
            _i2d = _cont.msCharacters[l].cc.drawShape(_i2d, _msColor);
            ++l;
        }
        l = 0;
        while (l < _cont.numSMCharacters) {
            _i2d = _cont.smCharacters[l].cc.drawShape(_i2d, _smColor);
            ++l;
        }
        return _i2d;
    }

    public IInt2D showAllThinedCharacters() throws ImageException {
        return this.showAllThinedCharacters(0xFF0000, 65280, 255, 0xFFFF00);
    }

    public IInt2D showAllThinedCharacters(int _ssColor, int _msColor, int _smColor1, int _smColor2) throws ImageException {
        Int2D i2d = new Int2D(this.pageImage.pixel.getWidth(), this.pageImage.pixel.getHeight());
        DebugUtil.debugMsg(this, "numContainers = " + this.pageImage.numContainers, "CONTAINER");
        int k = 0;
        while (k < this.pageImage.numContainers) {
            Container cont = this.pageImage.containers[k];
            i2d = this.showThinedCharactersInOneContainer(i2d, cont, _ssColor, _msColor, _smColor1);
            ++k;
        }
        k = 0;
        while (k < this.pageImage.numNonContainedCharacters) {
            i2d = this.pageImage.nonContainedCharacters[k].cc.thinning().drawShape(i2d, _smColor2);
            ++k;
        }
        return i2d;
    }

    public Int2D showThinedCharactersInOneContainer(Int2D _i2d, Container _cont, int _ssColor, int _msColor, int _smColor) throws ImageException {
        int l = 0;
        while (l < _cont.numSSCharacters) {
            _i2d = _cont.ssCharacters[l].cc.thinning().drawShape(_i2d, _ssColor);
            ++l;
        }
        l = 0;
        while (l < _cont.numMSCharacters) {
            _i2d = _cont.msCharacters[l].cc.thinning().drawShape(_i2d, _msColor);
            ++l;
        }
        l = 0;
        while (l < _cont.numSMCharacters) {
            _i2d = _cont.smCharacters[l].cc.thinning().drawShape(_i2d, _smColor);
            ++l;
        }
        return _i2d;
    }
}

