/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.operator;

import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.eclipse.actf.visualization.engines.lowvision.LowVisionType;
import org.eclipse.actf.visualization.internal.engines.lowvision.operator.ILowVisionOperator;

public class BlurOp
implements ILowVisionOperator {
    private ConvolveOp cop = null;

    public BlurOp(LowVisionType _lvType) {
        int i;
        double pixel = _lvType.getEyesightPixel();
        int cPixel = (int)Math.ceil(pixel);
        int fPixel = (int)Math.floor(pixel);
        int arrayWidth = 2 * cPixel + 1;
        double[][] blurArray = new double[arrayWidth][arrayWidth];
        if (cPixel == fPixel) {
            double area = arrayWidth * arrayWidth;
            int j = 0;
            while (j < arrayWidth) {
                i = 0;
                while (i < arrayWidth) {
                    blurArray[j][i] = 1.0 / area;
                    ++i;
                }
                ++j;
            }
        } else if (cPixel == fPixel + 1) {
            double cornerHalf;
            double cornerValue;
            double dicimal = pixel - (double)fPixel;
            double area = (2.0 * pixel + 1.0) * (2.0 * pixel + 1.0);
            double centerValue = 1.0 / area;
            int j = 1;
            while (j < arrayWidth - 1) {
                int i2 = 1;
                while (i2 < arrayWidth - 1) {
                    blurArray[j][i2] = centerValue;
                    ++i2;
                }
                ++j;
            }
            double edgeValue = dicimal / area;
            int j2 = 1;
            while (j2 < arrayWidth - 1) {
                blurArray[j2][0] = edgeValue;
                blurArray[j2][arrayWidth - 1] = edgeValue;
                blurArray[0][j2] = edgeValue;
                blurArray[arrayWidth - 1][j2] = edgeValue;
                ++j2;
            }
            blurArray[0][0] = cornerValue = dicimal * dicimal / area;
            blurArray[0][arrayWidth - 1] = cornerValue;
            blurArray[arrayWidth - 1][0] = cornerValue;
            blurArray[arrayWidth - 1][arrayWidth - 1] = cornerValue;
            double temp = blurArray[0][0] * 4.0;
            blurArray[0][0] = cornerHalf = 0.0;
            blurArray[0][arrayWidth - 1] = cornerHalf;
            blurArray[arrayWidth - 1][0] = cornerHalf;
            blurArray[arrayWidth - 1][arrayWidth - 1] = cornerHalf;
            double[] dArray = blurArray[arrayWidth / 2];
            int n = arrayWidth / 2;
            dArray[n] = dArray[n] + temp;
        }
        float[] element = new float[arrayWidth * arrayWidth];
        int k = 0;
        int j = 0;
        while (j < arrayWidth) {
            i = 0;
            while (i < arrayWidth) {
                element[k] = (float)blurArray[j][i];
                ++k;
                ++i;
            }
            ++j;
        }
        Kernel kernel = new Kernel(arrayWidth, arrayWidth, element);
        this.cop = new ConvolveOp(kernel, 1, null);
    }

    public BufferedImage filter(BufferedImage _src, BufferedImage _dest) {
        return this.newFilter(_src, _dest);
    }

    private BufferedImage newFilter(BufferedImage _src, BufferedImage _dest) {
        if (_dest == null) {
            _dest = new BufferedImage(_src.getWidth(), _src.getHeight(), _src.getType());
        }
        Kernel karnel = this.cop.getKernel();
        int w = karnel.getWidth();
        int h = karnel.getHeight();
        float[] d = new float[w * h];
        karnel.getKernelData(d);
        int width = _src.getWidth();
        int height = _src.getHeight();
        double N = 1.005;
        double[] pow = new double[256];
        int i = 0;
        while (i < pow.length) {
            pow[i] = Math.pow(N, i);
            ++i;
        }
        double logN = Math.log(N);
        int x = 0;
        while (x < width) {
            int y = 0;
            while (y < height) {
                double dr = 0.0;
                double dg = 0.0;
                double db = 0.0;
                int xx = 0;
                while (xx < w) {
                    int yy = 0;
                    while (yy < h) {
                        int xxx = x + xx - w / 2;
                        int yyy = y + yy - h / 2;
                        xxx = xxx > 0 ? xxx : 0;
                        xxx = xxx >= width ? width - 1 : xxx;
                        yyy = yyy > 0 ? yyy : 0;
                        yyy = yyy >= height ? height - 1 : yyy;
                        int rgb = _src.getRGB(xxx, yyy);
                        int ir = (rgb & 0xFF0000) >> 16;
                        int ig = (rgb & 0xFF00) >> 8;
                        int ib = rgb & 0xFF;
                        dr += pow[ir] * (double)d[xx * w + yy];
                        dg += pow[ig] * (double)d[xx * w + yy];
                        db += pow[ib] * (double)d[xx * w + yy];
                        ++yy;
                    }
                    ++xx;
                }
                int ir = (int)(Math.log(dr) / logN);
                int ig = (int)(Math.log(dg) / logN);
                int ib = (int)(Math.log(db) / logN);
                ir = ir > 255 ? 255 : ir;
                ig = ig > 255 ? 255 : ig;
                ib = ib > 255 ? 255 : ib;
                _dest.setRGB(x, y, (ir << 16) + (ig << 8) + ib);
                ++y;
            }
            ++x;
        }
        return _dest;
    }

    public WritableRaster filter(Raster _src, WritableRaster _dest) {
        return this.cop.filter(_src, _dest);
    }
}

