/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.accservice.swtbridge.internal.ia2;

import org.eclipse.actf.accservice.swtbridge.ia2.AccessibleText;
import org.eclipse.actf.accservice.swtbridge.ia2.TextSegment;
import org.eclipse.actf.accservice.swtbridge.internal.ia2.IAccessibleText;
import org.eclipse.actf.util.win32.MemoryUtil;
import org.eclipse.actf.util.win32.NativeIntAccess;
import org.eclipse.actf.util.win32.NativeStringAccess;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.ole.win32.COM;

public class InternalAccessibleText
implements AccessibleText {
    private IAccessibleText accessibleText = null;

    public InternalAccessibleText(int address) {
        this.accessibleText = new IAccessibleText(address);
        this.accessibleText.AddRef();
    }

    public void dispose() {
        if (this.accessibleText != null) {
            this.accessibleText.Release();
            this.accessibleText = null;
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public boolean addSelection(int startOffset, int endOffset) {
        if (this.accessibleText != null) {
            return this.accessibleText.addSelection(startOffset, endOffset) == 0;
        }
        return false;
    }

    public TextSegment getCharacterAttributes(int offset) {
        if (this.accessibleText != null) {
            NativeIntAccess nia = new NativeIntAccess(2);
            NativeStringAccess nsa = new NativeStringAccess();
            try {
                if (this.accessibleText.get_attributes(offset, nia.getAddress(0), nia.getAddress(1), nsa.getAddress()) == 0) {
                    TextSegment textSegment = new TextSegment(nsa.getString(), nia.getInt(0), nia.getInt(1));
                    return textSegment;
                }
            }
            catch (Exception exception) {
            }
            finally {
                nsa.dispose();
                nia.dispose();
            }
        }
        return null;
    }

    public int getCaretPosition() {
        if (this.accessibleText != null) {
            NativeIntAccess nia = new NativeIntAccess();
            try {
                if (this.accessibleText.get_caretOffset(nia.getAddress()) == 0) {
                    int n = nia.getInt();
                    return n;
                }
            }
            catch (Exception exception) {
            }
            finally {
                nia.dispose();
            }
        }
        return -1;
    }

    public Rectangle getCharacterBounds(int offset, int coordType) {
        if (this.accessibleText != null) {
            NativeIntAccess nia = new NativeIntAccess(4);
            try {
                if (this.accessibleText.get_characterExtents(offset, coordType, nia.getAddress(0), nia.getAddress(1), nia.getAddress(2), nia.getAddress(3)) == 0) {
                    Rectangle rectangle = new Rectangle(nia.getInt(0), nia.getInt(1), nia.getInt(2), nia.getInt(3));
                    return rectangle;
                }
            }
            catch (Exception exception) {
            }
            finally {
                nia.dispose();
            }
        }
        return null;
    }

    public int getSelectionCount() {
        if (this.accessibleText != null) {
            NativeIntAccess nia = new NativeIntAccess();
            try {
                if (this.accessibleText.get_nSelections(nia.getAddress()) == 0) {
                    int n = nia.getInt();
                    return n;
                }
            }
            catch (Exception exception) {
            }
            finally {
                nia.dispose();
            }
        }
        return 0;
    }

    public int getIndexAtPoint(Point point, int coordType) {
        if (this.accessibleText != null) {
            NativeIntAccess nia = new NativeIntAccess();
            try {
                if (this.accessibleText.get_offsetAtPoint(point.x, point.y, coordType, nia.getAddress()) == 0) {
                    int n = nia.getInt();
                    return n;
                }
            }
            catch (Exception exception) {
            }
            finally {
                nia.dispose();
            }
        }
        return -1;
    }

    public Point getSelection(int selectionIndex) {
        if (this.accessibleText != null) {
            NativeIntAccess nia = new NativeIntAccess(2);
            try {
                if (this.accessibleText.get_selection(selectionIndex, nia.getAddress(0), nia.getAddress(1)) == 0) {
                    Point point = new Point(nia.getInt(0), nia.getInt(1));
                    return point;
                }
            }
            catch (Exception exception) {
            }
            finally {
                nia.dispose();
            }
        }
        return null;
    }

    public String getTextRange(int startOffset, int endOffset) {
        if (this.accessibleText != null) {
            NativeStringAccess nsa = new NativeStringAccess();
            try {
                if (this.accessibleText.get_text(startOffset, endOffset, nsa.getAddress()) == 0) {
                    String string = nsa.getString();
                    return string;
                }
            }
            catch (Exception exception) {
            }
            finally {
                nsa.dispose();
            }
        }
        return null;
    }

    public TextSegment getTextBeforeIndex(int offset, int boundaryType) {
        if (this.accessibleText != null) {
            NativeIntAccess nia = new NativeIntAccess(2);
            NativeStringAccess nsa = new NativeStringAccess();
            try {
                if (this.accessibleText.get_textBeforeOffset(offset, boundaryType, nia.getAddress(0), nia.getAddress(1), nsa.getAddress()) == 0) {
                    TextSegment textSegment = new TextSegment(nsa.getString(), nia.getInt(0), nia.getInt(1));
                    return textSegment;
                }
            }
            catch (Exception exception) {
            }
            finally {
                nsa.dispose();
                nia.dispose();
            }
        }
        return null;
    }

    public TextSegment getTextAfterIndex(int offset, int boundaryType) {
        if (this.accessibleText != null) {
            NativeIntAccess nia = new NativeIntAccess(2);
            NativeStringAccess nsa = new NativeStringAccess();
            try {
                if (this.accessibleText.get_textAfterOffset(offset, boundaryType, nia.getAddress(0), nia.getAddress(1), nsa.getAddress()) == 0) {
                    TextSegment textSegment = new TextSegment(nsa.getString(), nia.getInt(0), nia.getInt(1));
                    return textSegment;
                }
            }
            catch (Exception exception) {
            }
            finally {
                nsa.dispose();
                nia.dispose();
            }
        }
        return null;
    }

    public TextSegment getTextAtIndex(int offset, int boundaryType) {
        if (this.accessibleText != null) {
            NativeIntAccess nia = new NativeIntAccess(2);
            NativeStringAccess nsa = new NativeStringAccess();
            try {
                if (this.accessibleText.get_textAtOffset(offset, boundaryType, nia.getAddress(0), nia.getAddress(1), nsa.getAddress()) == 0) {
                    TextSegment textSegment = new TextSegment(nsa.getString(), nia.getInt(0), nia.getInt(1));
                    return textSegment;
                }
            }
            catch (Exception exception) {
            }
            finally {
                nsa.dispose();
                nia.dispose();
            }
        }
        return null;
    }

    public boolean removeSelection(int selectionIndex) {
        if (this.accessibleText != null) {
            return this.accessibleText.removeSelection(selectionIndex) == 0;
        }
        return false;
    }

    public boolean setCaretPosition(int offset) {
        if (this.accessibleText != null) {
            return this.accessibleText.setCaretOffset(offset) == 0;
        }
        return false;
    }

    public boolean setSelection(int selectionIndex, int startOffset, int endOffset) {
        if (this.accessibleText != null) {
            return this.accessibleText.setSelection(selectionIndex, startOffset, endOffset) == 0;
        }
        return false;
    }

    public int getCharacterCount() {
        if (this.accessibleText != null) {
            NativeIntAccess nia = new NativeIntAccess();
            try {
                if (this.accessibleText.get_nCharacters(nia.getAddress()) == 0) {
                    int n = nia.getInt();
                    return n;
                }
            }
            catch (Exception exception) {
            }
            finally {
                nia.dispose();
            }
        }
        return 0;
    }

    public boolean scrollSubstringTo(int startIndex, int endIndex, int scrollType) {
        if (this.accessibleText != null) {
            return this.accessibleText.scrollSubstringTo(startIndex, endIndex, scrollType) == 0;
        }
        return false;
    }

    public boolean scrollSubstringToPoint(int startIndex, int endIndex, int coordinateType, int x, int y) {
        if (this.accessibleText != null) {
            return this.accessibleText.scrollSubstringToPoint(startIndex, endIndex, coordinateType, x, y) == 0;
        }
        return false;
    }

    public TextSegment getNewText() {
        if (this.accessibleText != null) {
            NativeIntAccess nia = new NativeIntAccess(3);
            try {
                if (this.accessibleText.get_newText(nia.getAddress()) == 0) {
                    TextSegment textSegment = InternalAccessibleText.getTextSegment(nia);
                    return textSegment;
                }
            }
            catch (Exception exception) {
            }
            finally {
                nia.dispose();
            }
        }
        return null;
    }

    public TextSegment getOldText() {
        if (this.accessibleText != null) {
            NativeIntAccess nia = new NativeIntAccess(3);
            try {
                if (this.accessibleText.get_oldText(nia.getAddress()) == 0) {
                    TextSegment textSegment = InternalAccessibleText.getTextSegment(nia);
                    return textSegment;
                }
            }
            catch (Exception exception) {
            }
            finally {
                nia.dispose();
            }
        }
        return null;
    }

    private static TextSegment getTextSegment(NativeIntAccess nia) {
        int[] hMem = new int[3];
        MemoryUtil.MoveMemory((int[])hMem, (int)nia.getAddress(), (int)(4 * hMem.length));
        if (hMem[0] != 0) {
            try {
                TextSegment textSegment = new TextSegment("", 0, 0);
                int size = COM.SysStringByteLen((int)hMem[0]);
                if (size > 0) {
                    char[] buffer = new char[(size + 1) / 2];
                    MemoryUtil.MoveMemory((char[])buffer, (int)hMem[0], (int)size);
                    textSegment.text = new String(buffer);
                }
                textSegment.start = hMem[1];
                textSegment.end = hMem[2];
                TextSegment textSegment2 = textSegment;
                return textSegment2;
            }
            finally {
                COM.SysFreeString((int)hMem[0]);
            }
        }
        return null;
    }
}

