/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.gui.ui.views;

import org.eclipse.actf.visualization.gui.msaa.properties.IPropertyInvoke;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;

public class PropertyTreeEntry {
    private IPropertySource source;
    private IPropertyDescriptor descriptor;
    private PropertyTreeEntry parent;
    private Object id;
    private String path;
    private int color = -1;

    public PropertyTreeEntry(PropertyTreeEntry parent, IPropertySource propertySource, IPropertyDescriptor propertyDescriptor) {
        this.parent = parent;
        this.source = propertySource;
        this.descriptor = propertyDescriptor;
        this.id = propertyDescriptor.getId();
        this.path = parent == null ? "" : String.valueOf(parent.path) + "/";
        this.path = String.valueOf(this.path) + this.id.toString();
    }

    public String getDisplayName() {
        return this.descriptor.getDisplayName();
    }

    public String getValueAsString() {
        Object value = this.getValue();
        if (value == null) {
            return "null";
        }
        if (value instanceof IPropertySource) {
            value = ((IPropertySource)value).getEditableValue();
        }
        if (value == null) {
            return null;
        }
        ILabelProvider provider = this.descriptor.getLabelProvider();
        if (provider == null) {
            return value.toString();
        }
        String text = provider.getText(value);
        if (text == null) {
            return "";
        }
        return text;
    }

    public Object getId() {
        return this.id;
    }

    public IPropertySource getPropertySource() {
        return this.source;
    }

    public String getPath() {
        return this.path;
    }

    public Object getValue() {
        return this.id != null ? this.source.getPropertyValue(this.id) : null;
    }

    public boolean canInvoke() {
        if (this.id != null && this.source instanceof IPropertyInvoke) {
            return ((IPropertyInvoke)this.source).canInvoke(this.id);
        }
        return false;
    }

    public PropertyTreeEntry getParent() {
        return this.parent;
    }

    public boolean hasChildren() {
        return this.getChildren().length > 0;
    }

    public Object[] getChildren() {
        Object value = this.getValue();
        if (value instanceof IPropertySource) {
            return PropertyTreeEntry.getElements(this, (IPropertySource)value);
        }
        return new Object[0];
    }

    public void setColor(int color) {
        this.color = color;
    }

    public int getColor() {
        return this.color;
    }

    public static Object[] getElements(PropertyTreeEntry parent, IPropertySource source) {
        IPropertyDescriptor[] base = source.getPropertyDescriptors();
        IPropertyDescriptor[] extra = new IPropertyDescriptor[]{};
        if (source instanceof IPropertyInvoke) {
            extra = ((IPropertyInvoke)source).getPropertyDescriptorsExtra();
        }
        Object[] elements = new Object[base.length + extra.length];
        int i = 0;
        while (i < base.length) {
            elements[i] = new PropertyTreeEntry(parent, source, base[i]);
            ++i;
        }
        i = 0;
        while (i < extra.length) {
            elements[base.length + i] = new PropertyTreeEntry(parent, source, extra[i]);
            ++i;
        }
        return elements;
    }

    public boolean equals(Object o) {
        if (super.equals(o)) {
            return true;
        }
        if (o instanceof PropertyTreeEntry) {
            return this.path.equals(((PropertyTreeEntry)o).path);
        }
        return false;
    }
}

