/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.blind.html.util;

import java.util.Map;
import java.util.Vector;
import org.eclipse.actf.visualization.engines.blind.TextCheckResult;
import org.eclipse.actf.visualization.engines.blind.TextChecker;
import org.eclipse.actf.visualization.engines.blind.html.VisualizeEngine;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.eclipse.actf.visualization.internal.engines.blind.html.BlindProblem;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.VisualizationNodeInfo;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.VisualizeMapDataImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImgChecker {
    private static final String SRC = "src";
    private static final String ALT = "alt";
    private VisualizeMapDataImpl mapData;
    private Map<String, Element> mapMap;
    private TextChecker textChecker;
    private Vector<IProblemItem> problemV;
    private String baseUrl;
    private boolean[] checkItems;

    public ImgChecker(VisualizeMapDataImpl mapData, Map<String, Element> mapMap, TextChecker textChecker, Vector<IProblemItem> problemV, String baseUrl, boolean[] checkItems) {
        this.mapData = mapData;
        this.mapMap = mapMap;
        this.textChecker = textChecker;
        this.problemV = problemV;
        this.baseUrl = baseUrl;
        this.checkItems = checkItems;
    }

    public boolean checkAndReplaceImg(Element img, Document doc, boolean remove) {
        Element mapEl = null;
        NodeList areaNL = null;
        String mapName = img.getAttribute("usemap");
        if (mapName.length() > 0 && (mapEl = this.mapMap.get(mapName.substring(1))) != null) {
            areaNL = mapEl.getElementsByTagName("area");
        }
        String imgText = this.checkAlt(img);
        if (remove) {
            Node parent = img.getParentNode();
            Element spanEl = doc.createElement("span");
            spanEl.setAttribute("width", img.getAttribute("width"));
            spanEl.setAttribute("height", img.getAttribute("height"));
            spanEl.setAttribute("id", img.getAttribute("id"));
            spanEl.setAttribute("style", img.getAttribute("style"));
            boolean isVisible = true;
            VisualizationNodeInfo info = this.mapData.getNodeInfo(img);
            if (info != null) {
                isVisible = !info.isInvisible();
            }
            img.removeAttribute("id");
            if (imgText.length() > 0 && isVisible) {
                spanEl.appendChild(doc.createTextNode(imgText));
            }
            parent.insertBefore(spanEl, img);
            if (areaNL != null) {
                int size = areaNL.getLength();
                int i = 0;
                while (i < size) {
                    Element areaEl = doc.createElement("span");
                    areaEl.setAttribute("style", img.getAttribute("style"));
                    spanEl.appendChild(areaEl);
                    Element areaE = (Element)areaNL.item(i);
                    BlindProblem prob = null;
                    Integer idObj = null;
                    areaEl.setAttribute("id", String.valueOf(areaE.getAttribute("id")) + "-span");
                    if (!areaE.hasAttribute(ALT)) {
                        if (areaE.hasAttribute("href")) {
                            prob = new BlindProblem(2, "map name=\"" + mapEl.getAttribute("name") + "\", href=\"" + areaE.getAttribute("href") + "\".");
                            prob.setTargetNode(this.mapData.getOrigNode(areaE));
                        }
                    } else {
                        String alt = areaE.getAttribute(ALT);
                        TextCheckResult result = this.textChecker.checkAlt(alt);
                        if (result.equals((Object)TextCheckResult.SPACE_SEPARATED) || result.equals((Object)TextCheckResult.SPACE_SEPARATED_JP)) {
                            prob = new BlindProblem(31, alt);
                        }
                        if (prob != null) {
                            prob.setTargetNode(this.mapData.getOrigNode(areaE));
                        }
                        areaEl.appendChild(doc.createTextNode("[" + alt + ".] "));
                    }
                    if (prob != null) {
                        idObj = this.mapData.getIdOfNode(img);
                        if (idObj != null) {
                            prob.setNode(areaE, idObj);
                        } else {
                            prob.setNode(areaE);
                        }
                        this.problemV.add(prob);
                        idObj = this.mapData.getIdOfNode(areaE);
                        if (this.checkItems[prob.getSubType()]) {
                            Element errorImg = doc.createElement("img");
                            errorImg.setAttribute(ALT, "error icon");
                            errorImg.setAttribute("title", prob.getDescription());
                            if (idObj != null) {
                                errorImg.setAttribute("onmouseover", "updateBaloon('id" + idObj + "');");
                            }
                            errorImg.setAttribute(SRC, String.valueOf(this.baseUrl) + "img/" + VisualizeEngine.ERROR_ICON_NAME);
                            areaEl.appendChild(errorImg);
                        }
                    }
                    ++i;
                }
            }
            this.mapData.addReplacedNodeMapping(img, spanEl);
            parent.removeChild(img);
        }
        return true;
    }

    private String checkAlt(Element img) {
        boolean noAltError = false;
        String altS = "";
        BlindProblem prob = null;
        if (!img.hasAttribute(ALT)) {
            prob = new BlindProblem(0, img.getAttribute(SRC));
            noAltError = true;
        } else {
            altS = img.getAttribute(ALT);
            if (altS.length() > 0) {
                TextCheckResult result = this.textChecker.checkAlt(altS, img.getAttribute(SRC));
                if (result.equals((Object)TextCheckResult.NG_WORD) || result.equals((Object)TextCheckResult.IMG_EXT)) {
                    prob = new BlindProblem(27, altS);
                } else if (result.equals((Object)TextCheckResult.SPACE_SEPARATED_JP)) {
                    prob = new BlindProblem(29, altS);
                } else if (result.equals((Object)TextCheckResult.SPACE_SEPARATED)) {
                    prob = new BlindProblem(34, altS);
                } else if (result.equals((Object)TextCheckResult.BLANK_NBSP)) {
                    prob = new BlindProblem(38, altS);
                } else if (!result.equals((Object)TextCheckResult.OK)) {
                    prob = new BlindProblem(27, altS);
                }
            }
        }
        if (prob != null) {
            prob.setTargetNode(this.mapData.getOrigNode(img));
            Integer idObj = this.mapData.getIdOfNode(img);
            if (idObj != null) {
                prob.setNode(img, idObj);
            } else {
                prob.setNode(img);
            }
            this.problemV.add(prob);
        }
        String imgText = null;
        VisualizationNodeInfo info = this.mapData.getNodeInfo(img);
        imgText = info != null && info.getPacket() != null ? info.getPacket().getText() : (noAltError ? "" : altS);
        return imgText;
    }

    private boolean isIgnoredByAT(Element img) {
        String alt = img.getAttribute(ALT);
        return img.hasAttribute(ALT) && alt.matches("[ \\u00A0]*");
    }
}

