/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.voicebrowser;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.eclipse.actf.visualization.engines.voicebrowser.IPacket;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.Context;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.IElementRenderer;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.MessageCollection;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.OutLoud;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.Packet;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.PacketCollection;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.StaticABBRRenderer;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.StaticAREARenderer;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.StaticARenderer;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.StaticBRRenderer;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.StaticDefaultRenderer;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.StaticFORMRenderer;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.StaticHRenderer;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.StaticIMGRenderer;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.StaticINPUTRenderer;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.StaticMAPRenderer;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.StaticNoRenderer;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.StaticOPTIONRenderer;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.StaticPRenderer;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.StaticSELECTRenderer;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.StaticTABLERenderer;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.StaticTDRenderer;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.StaticTEXTAREARenderer;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.StaticTRRenderer;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.TextUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JWATCore {
    private static MessageCollection mc = null;
    private static String uriPrefix = null;
    private static Map<String, IElementRenderer> elementMap = new HashMap<String, IElementRenderer>();
    static final int IMG_ELEMENT = 0;
    static final int A_ELEMENT = 1;
    private static IElementRenderer defaultRenderer = new StaticDefaultRenderer();

    static {
        elementMap.put("img", new StaticIMGRenderer());
        elementMap.put("a", new StaticARenderer());
        elementMap.put("td", new StaticTDRenderer());
        elementMap.put("form", new StaticFORMRenderer());
        elementMap.put("select", new StaticSELECTRenderer());
        elementMap.put("input", new StaticINPUTRenderer());
        elementMap.put("br", new StaticBRRenderer());
        elementMap.put("table", new StaticTABLERenderer());
        elementMap.put("area", new StaticAREARenderer());
        elementMap.put("map", new StaticMAPRenderer());
        elementMap.put("head", new StaticNoRenderer());
        elementMap.put("script", new StaticNoRenderer());
        elementMap.put("noscript", new StaticNoRenderer());
        elementMap.put("tr", new StaticTRRenderer());
        elementMap.put("tbody", new StaticTRRenderer());
        elementMap.put("p", new StaticPRenderer());
        elementMap.put("th", new StaticTDRenderer());
        elementMap.put("div", new StaticTDRenderer());
        elementMap.put("li", new StaticTDRenderer());
        elementMap.put("h1", new StaticHRenderer());
        elementMap.put("h2", new StaticHRenderer());
        elementMap.put("h3", new StaticHRenderer());
        elementMap.put("h4", new StaticHRenderer());
        elementMap.put("h5", new StaticHRenderer());
        elementMap.put("h6", new StaticHRenderer());
        elementMap.put("abbr", new StaticABBRRenderer());
        elementMap.put("acronym", new StaticABBRRenderer());
        elementMap.put("option", new StaticOPTIONRenderer());
        elementMap.put("textarea", new StaticTEXTAREARenderer());
    }

    public MessageCollection setJwatMode(int mode, String xmlpath) {
        try {
            if (mc != null && mc.size() > 0) {
                mc.clear();
            }
            mc = OutLoud.createMessageCollection(mode, xmlpath);
            return mc;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    public PacketCollection getPacketCollection(Node node) {
        try {
            PacketCollection result = this.getPacketCollectionTraversely(node, JWATCore.getCurrentParentsStack(node));
            return result;
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
            return null;
        }
    }

    private static Stack<Node> getCurrentParentsStack(Node node) {
        try {
            Stack<Node> parentsStack = new Stack<Node>();
            Stack<Node> tempStack = new Stack<Node>();
            Node tempNode = node;
            while (tempNode != null) {
                tempStack.push(tempNode);
                tempNode = tempNode.getParentNode();
            }
            while (tempStack.size() > 1) {
                parentsStack.push((Node)tempStack.pop());
            }
            return parentsStack;
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
            return null;
        }
    }

    private PacketCollection getPacketCollectionTraversely(Node node, Stack<Node> elementStack) {
        Context curContext = new Context();
        PacketCollection result = new PacketCollection();
        Node curReadNode = node;
        while (curReadNode != null) {
            PacketCollection tmp = JWATCore.getPacketCollectionOneNode(curReadNode, curContext);
            if (tmp != null) {
                result.addAll(tmp);
            }
            curReadNode = this.goNext(curReadNode, curContext, elementStack, result);
        }
        return result;
    }

    private Node goNext(Node curReadNode, Context curContext, Stack<Node> elementStack, PacketCollection result) {
        PacketCollection tmp = null;
        if (curReadNode == null) {
            return null;
        }
        if (curContext.isGoChild() && curReadNode.hasChildNodes()) {
            elementStack.push(curReadNode);
            return curReadNode.getFirstChild();
        }
        if (curReadNode.getNextSibling() != null) {
            IElementRenderer renderer;
            if (result != null && curReadNode.getNodeType() == 1 && (renderer = JWATCore.getElementRenderer((Element)curReadNode)) != null && (tmp = renderer.getPacketCollectionOut((Element)curReadNode, curContext, uriPrefix, mc)) != null) {
                result.addAll(tmp);
            }
            return curReadNode.getNextSibling();
        }
        curReadNode = null;
        while (curReadNode == null) {
            IElementRenderer renderer;
            if (elementStack.size() == 0) break;
            curReadNode = elementStack.pop();
            if (result != null && curReadNode.getNodeType() == 1 && (renderer = JWATCore.getElementRenderer((Element)curReadNode)) != null && (tmp = renderer.getPacketCollectionOut((Element)curReadNode, curContext, uriPrefix, mc)) != null) {
                result.addAll(tmp);
            }
            curReadNode = curReadNode.getNextSibling();
        }
        return curReadNode;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static PacketCollection getPacketCollectionOneNode(Node node, Context curContext) {
        curContext.setLinkTag(false);
        curContext.setStartSelect(false);
        curContext.setStringOutput(true);
        switch (node.getNodeType()) {
            case 1: {
                return JWATCore.getPacketCollectionOneElement((Element)node, curContext);
            }
            case 3: {
                try {
                    String curNodeValue = node.getNodeValue();
                    curNodeValue = TextUtil.trim(curNodeValue);
                    curNodeValue = TextUtil.replace(new StringBuffer(curNodeValue)).toString();
                    curNodeValue = TextUtil.substitute(curNodeValue, "&nbsp;", " ");
                    if (curNodeValue.indexOf("<!") >= 0) return null;
                    if (curNodeValue.indexOf("<%") >= 0) return null;
                    if (curNodeValue.length() == 0) return null;
                    curContext.setLineDelimiter(false);
                    return new PacketCollection(new Packet(node, curNodeValue, curContext, true));
                }
                catch (NullPointerException nullPointerException) {
                    return null;
                }
            }
        }
        return null;
    }

    private static PacketCollection getPacketCollectionOneElement(Element element, Context curContext) {
        PacketCollection result = null;
        try {
            result = JWATCore.getElementRenderer(element).getPacketCollectionIn(element, curContext, uriPrefix, mc);
            return result;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    private static IElementRenderer getElementRenderer(Element element) {
        String nodeName = element.getNodeName().toLowerCase();
        IElementRenderer renderer = null;
        renderer = elementMap.get(nodeName);
        if (renderer == null) {
            renderer = defaultRenderer;
        }
        return renderer;
    }

    public int getNodePosition(Node node, PacketCollection pc) {
        if (pc == null) {
            return 0;
        }
        try {
            Context curContext = new Context();
            PacketCollection p = new PacketCollection();
            Node curReadNode = node;
            Stack<Node> parentsStack = JWATCore.getCurrentParentsStack(node);
            while (curReadNode != null) {
                PacketCollection tmp = JWATCore.getPacketCollectionOneNode(curReadNode, curContext);
                if (tmp != null) {
                    p.addAll(tmp);
                    break;
                }
                curReadNode = this.goNext(curReadNode, curContext, parentsStack, p);
            }
            int size = pc.size();
            Node n = ((IPacket)p.get(0)).getNode();
            int i = 0;
            while (i < size) {
                if (n == ((IPacket)pc.get(i)).getNode()) {
                    return i;
                }
                ++i;
            }
            return 0;
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
            return 0;
        }
        catch (ClassCastException cce) {
            cce.printStackTrace();
            return 0;
        }
    }

    public int getAnchorPosition(String anchorName, Node topNode, PacketCollection pc) {
        if (pc == null) {
            return 0;
        }
        try {
            int pos = 0;
            Node node = null;
            NodeList aTags = ((Element)topNode).getElementsByTagName("a");
            int i = 0;
            while (i < aTags.getLength()) {
                String name;
                node = aTags.item(i);
                NamedNodeMap attrs = node.getAttributes();
                Node typeNode = attrs.getNamedItem("name");
                if (typeNode != null && anchorName.equals(name = typeNode.getNodeValue())) break;
                ++i;
            }
            if (node != null) {
                pos = this.getNodePosition(node, pc);
            }
            return pos;
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
            return 0;
        }
    }

    public String getHrefString(Node node) {
        NamedNodeMap attrs;
        Node typeNode;
        String href = null;
        if (node.getNodeType() == 1 && (node.getNodeName().toLowerCase().equals("a") || node.getNodeName().toLowerCase().equals("area")) && (typeNode = (attrs = node.getAttributes()).getNamedItem("href")) != null) {
            href = typeNode.getNodeValue();
        }
        return href;
    }

    public Node getTargetNode(Node node, Node topNode) {
        String href = this.getHrefString(node);
        if (href != null && href.length() > 0) {
            if (href.charAt(0) == '#') {
                String targetStr = href.substring(1, href.length());
                if (node != null) {
                    NodeList aTags = ((Element)topNode).getElementsByTagName("a");
                    int i = 0;
                    while (i < aTags.getLength()) {
                        String name;
                        Node n = aTags.item(i);
                        NamedNodeMap attrs = n.getAttributes();
                        Node typeNode = attrs.getNamedItem("name");
                        if (typeNode != null && targetStr.equals(name = typeNode.getNodeValue())) {
                            return n;
                        }
                        ++i;
                    }
                }
                return node;
            }
            return null;
        }
        return null;
    }

    public static void setUriPrefix(String uriPrefix) {
        JWATCore.uriPrefix = uriPrefix;
    }
}

