/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.voicebrowser;

import org.eclipse.actf.visualization.internal.engines.voicebrowser.Context;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.IElementRenderer;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.MessageCollection;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.OutLoud;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.Packet;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.PacketCollection;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.TextUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class StaticABBRRenderer
implements IElementRenderer {
    public PacketCollection getPacketCollectionIn(Element element, Context curContext, String url, MessageCollection mc) {
        this.setContextIn(element, curContext);
        NamedNodeMap attrs = element.getAttributes();
        Node node = attrs.getNamedItem("title");
        if (node == null) {
            return null;
        }
        String str = node.getNodeValue();
        if ((str = TextUtil.trim(str)).length() == 0) {
            return null;
        }
        String result = OutLoud.buildResultString(mc, url, element, null, null, "<name=str1>", str);
        if (result == null && OutLoud.hprDefltMsg) {
            result = element.getNodeName().toLowerCase().equals("abbr") ? "(Abbreviation: " + str + ".)" : "(Acronym: " + str + ".)";
        }
        if (result != null) {
            result = result.trim();
        }
        return new PacketCollection(new Packet(element, result, curContext, true));
    }

    public PacketCollection getPacketCollectionOut(Element element, Context curContext, String url, MessageCollection mc) {
        this.setContextOut(element, curContext);
        return null;
    }

    public void setContextIn(Element element, Context curContext) {
        curContext.setGoChild(true);
        curContext.setLineDelimiter(false);
    }

    public void setContextOut(Element element, Context curContext) {
        curContext.setGoChild(true);
        curContext.setLineDelimiter(false);
    }
}

