/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.voicebrowser;

import org.eclipse.actf.visualization.internal.engines.voicebrowser.Context;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.IElementRenderer;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.MessageCollection;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.OutLoud;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.Packet;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.PacketCollection;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.TextUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class StaticOPTIONRenderer
implements IElementRenderer {
    public PacketCollection getPacketCollectionIn(Element element, Context curContext, String url, MessageCollection mc) {
        this.setContextIn(element, curContext);
        String result = null;
        String selstr = null;
        Node node = element.getFirstChild();
        if (node != null && node.getNodeType() == 3) {
            selstr = node.getNodeValue();
            if (selstr.length() > 0) {
                selstr = TextUtil.substitute(selstr, "\n", "");
                selstr = TextUtil.trim(selstr);
            }
            int selected = 0;
            NamedNodeMap attList = element.getAttributes();
            int j = 0;
            while (j < attList.getLength()) {
                Attr att = (Attr)attList.item(j);
                if (att.getName().equals("selected")) {
                    result = OutLoud.buildResultString(mc, url, element, null, "on", "name=str1", selstr);
                    if (result == null && OutLoud.hprDefltMsg) {
                        result = String.valueOf(selstr) + " [Selected.]";
                    }
                    ++selected;
                    break;
                }
                ++j;
            }
            if (selected == 0) {
                curContext.setStringOutput(false);
                result = OutLoud.buildResultString(mc, url, element, null, "off", "name=str1", selstr);
                if (result == null && OutLoud.hprDefltMsg) {
                    result = String.valueOf(selstr) + " [Off.]";
                }
            }
        }
        if (result != null) {
            result = result.trim();
        }
        return new PacketCollection(new Packet(element, result, curContext, true));
    }

    public PacketCollection getPacketCollectionOut(Element element, Context curContext, String url, MessageCollection mc) {
        this.setContextOut(element, curContext);
        return null;
    }

    public void setContextIn(Element element, Context curContext) {
        curContext.setGoChild(false);
        curContext.setLineDelimiter(true);
        curContext.setLinkTag(true);
    }

    public void setContextOut(Element element, Context curContext) {
        curContext.setGoChild(true);
        curContext.setLineDelimiter(false);
        curContext.setLinkTag(false);
    }
}

