/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.ui.report.table;

import org.eclipse.actf.visualization.eval.IEvaluationItem;
import org.eclipse.actf.visualization.eval.guideline.GuidelineHolder;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.eclipse.actf.visualization.internal.ui.report.ReportPlugin;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class ResultTableLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private GuidelineHolder guidelineHolder = GuidelineHolder.getInstance();
    private int metricsFinPos = this.guidelineHolder.getMetricsNames().length + 1;
    private int guidelineFinPos = this.metricsFinPos + this.guidelineHolder.getGuidelineData().length;
    private static Image HIGHLIGHT_IMAGE = ReportPlugin.imageDescriptorFromPlugin((String)"org.eclipse.actf.visualization.eval", (String)"icons/star.gif").createImage();

    public Image getColumnImage(Object arg0, int arg1) {
        IProblemItem tmpItem = (IProblemItem)arg0;
        if (arg1 == 0) {
            if (tmpItem.isCanHighlight()) {
                return HIGHLIGHT_IMAGE;
            }
        } else if (arg1 < this.metricsFinPos) {
            return tmpItem.getEvaluationItem().getMetricsIcons()[arg1 - 1];
        }
        return null;
    }

    public String getColumnText(Object arg0, int arg1) {
        IProblemItem tmpItem = (IProblemItem)arg0;
        IEvaluationItem ei = tmpItem.getEvaluationItem();
        if (arg1 != 0) {
            if (arg1 < this.metricsFinPos) {
                return ei.getTableDataMetrics()[arg1 - 1];
            }
            if (arg1 < this.guidelineFinPos) {
                return ei.getTableDataGuideline()[arg1 - this.metricsFinPos];
            }
            switch (arg1 - this.guidelineFinPos) {
                case 0: {
                    return ei.getTableDataTechniques();
                }
                case 1: {
                    return tmpItem.getLineStrMulti();
                }
                case 2: {
                    return tmpItem.getDescription();
                }
            }
        }
        return "";
    }
}

