/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.blind.internal;

import java.util.ArrayList;
import org.eclipse.actf.util.logging.DebugPrintUtil;
import org.eclipse.actf.visualization.blind.IBlindVisualizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;

public class BlindVisualizerExtension {
    private static final String VISUALIZER = "blindVisualizer";
    private static final String ATTR_CLASS = "class";
    private static BlindVisualizerExtension[] extensions;
    private static IBlindVisualizer[] visualizers;
    private IBlindVisualizer visualizer = null;

    static {
        visualizers = null;
    }

    public static IBlindVisualizer[] getVisualizers() {
        if (visualizers != null) {
            return visualizers;
        }
        BlindVisualizerExtension[] tmpExtensions = BlindVisualizerExtension.getExtensions();
        ArrayList<IBlindVisualizer> tmpList = new ArrayList<IBlindVisualizer>();
        if (tmpExtensions != null) {
            int i = 0;
            while (i < tmpExtensions.length) {
                IBlindVisualizer tmpProvider = tmpExtensions[i].getElementViewerInfoProvider();
                if (tmpProvider != null) {
                    tmpList.add(tmpProvider);
                }
                ++i;
            }
        }
        visualizers = new IBlindVisualizer[tmpList.size()];
        tmpList.toArray(visualizers);
        return visualizers;
    }

    private static BlindVisualizerExtension[] getExtensions() {
        if (extensions != null) {
            return extensions;
        }
        IExtension[] tmpExtensions = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.actf.visualization.blind", VISUALIZER).getExtensions();
        DebugPrintUtil.devOrDebugPrintln((Object)("Blind Visualizer:" + tmpExtensions.length));
        ArrayList<BlindVisualizerExtension> l = new ArrayList<BlindVisualizerExtension>();
        int i = 0;
        while (i < tmpExtensions.length) {
            IConfigurationElement[] configElements = tmpExtensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                BlindVisualizerExtension ex = BlindVisualizerExtension.parseExtension(configElements[j]);
                if (ex != null) {
                    l.add(ex);
                }
                ++j;
            }
            ++i;
        }
        extensions = l.toArray(new BlindVisualizerExtension[l.size()]);
        return extensions;
    }

    private static BlindVisualizerExtension parseExtension(IConfigurationElement configElement) {
        if (!configElement.getName().equals(VISUALIZER)) {
            return null;
        }
        try {
            return new BlindVisualizerExtension(configElement);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private BlindVisualizerExtension(IConfigurationElement configElement) {
        try {
            this.visualizer = (IBlindVisualizer)configElement.createExecutableExtension(ATTR_CLASS);
        }
        catch (Exception exception) {}
    }

    private IBlindVisualizer getElementViewerInfoProvider() {
        return this.visualizer;
    }
}

