/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.blind.ui.internal;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleClientSite;
import org.eclipse.swt.ole.win32.OleControlSite;
import org.eclipse.swt.ole.win32.OleFrame;
import org.eclipse.swt.ole.win32.Variant;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class BlindVisualizationBrowser {
    private static final String WEBBROWSER_CONTROL_NAME = "Shell.Explorer";
    private static final String NAVIGATE_METHOD_NAME = "Navigate";
    private static final String URL_PARAM_NAME = "URL";
    private static final Variant[] ARG_CLEAR_HIGHLIGHT = new Variant[]{new Variant("clearHighlight();")};
    private OleAutomation oleAutomationIE;
    private OleAutomation ieWindowAutomation = null;
    private int id_exec_script;
    private int id_navigate;
    private int[] id_url_param;

    public BlindVisualizationBrowser(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        parent.setLayout((Layout)gridLayout);
        OleFrame webFrame = new OleFrame(parent, 0);
        OleControlSite webControlSite = new OleControlSite((Composite)webFrame, 0, WEBBROWSER_CONTROL_NAME);
        this.oleAutomationIE = new OleAutomation((OleClientSite)webControlSite);
        webControlSite.doVerb(-5);
        int[] rgdispid = this.oleAutomationIE.getIDsOfNames(new String[]{NAVIGATE_METHOD_NAME, URL_PARAM_NAME});
        this.id_navigate = rgdispid[0];
        this.id_url_param = new int[1];
        this.id_url_param[0] = rgdispid[1];
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 4;
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.verticalAlignment = 4;
        gridData2.grabExcessVerticalSpace = true;
        webFrame.setLayoutData((Object)gridData2);
    }

    protected void setBrowserSilent() {
        int[] rgdispid = this.oleAutomationIE.getIDsOfNames(new String[]{"Silent"});
        int dispIdMember = rgdispid[0];
        Variant varSilent = new Variant(1);
        this.oleAutomationIE.setProperty(dispIdMember, varSilent);
    }

    protected void disposeOleBrowser() {
        if (this.oleAutomationIE != null) {
            this.oleAutomationIE.dispose();
        }
    }

    protected void navigate(String url) {
        Variant[] rgvarg = new Variant[]{new Variant(url)};
        this.oleAutomationIE.invoke(this.id_navigate, rgvarg, this.id_url_param);
    }

    private boolean initWindowAutomation() {
        if (this.ieWindowAutomation == null) {
            try {
                int[] rgdispid = this.oleAutomationIE.getIDsOfNames(new String[]{"Document"});
                int dispIdMember = rgdispid[0];
                Variant result = this.oleAutomationIE.getProperty(dispIdMember);
                OleAutomation htmlDocumentAutomation = result.getAutomation();
                rgdispid = htmlDocumentAutomation.getIDsOfNames(new String[]{"parentWindow"});
                dispIdMember = rgdispid[0];
                result = htmlDocumentAutomation.getProperty(dispIdMember);
                this.ieWindowAutomation = result.getAutomation();
                rgdispid = this.ieWindowAutomation.getIDsOfNames(new String[]{"execScript"});
                this.id_exec_script = rgdispid[0];
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    protected void execScript(String str) {
        if (this.initWindowAutomation()) {
            Variant[] rgvarg = new Variant[]{new Variant(str)};
            if (this.ieWindowAutomation.invoke(this.id_exec_script, rgvarg) == null) {
                this.ieWindowAutomation = null;
                if (this.initWindowAutomation()) {
                    this.ieWindowAutomation.invoke(this.id_exec_script, rgvarg);
                }
            }
        }
    }

    protected void clearHighlight() {
        if (this.initWindowAutomation()) {
            this.ieWindowAutomation.invoke(this.id_exec_script, ARG_CLEAR_HIGHLIGHT);
        }
    }
}

