/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.dombycom.impl.flash;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.eclipse.actf.model.dom.dombycom.AnalyzedResult;
import org.eclipse.actf.model.dom.dombycom.IFlashMSAANode;
import org.eclipse.actf.model.dom.dombycom.IFlashNode;
import org.eclipse.actf.model.dom.dombycom.INodeEx;
import org.eclipse.actf.model.dom.dombycom.impl.DocumentImpl;
import org.eclipse.actf.model.dom.dombycom.impl.flash.FlashTerms;
import org.eclipse.actf.model.dom.dombycom.impl.flash.FlashTopNodeImpl;
import org.eclipse.actf.model.flash.ASAccInfo;
import org.eclipse.actf.model.flash.IASBridge;
import org.eclipse.actf.model.flash.IASNode;
import org.eclipse.actf.model.flash.IFlashConst;
import org.eclipse.actf.util.dom.EmptyNodeListImpl;
import org.eclipse.actf.util.vocab.AbstractTerms;
import org.eclipse.actf.util.win32.comclutch.ComPlugin;
import org.eclipse.actf.util.win32.keyhook.ISendEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;

class FlashNodeImpl
implements IFlashNode,
IFlashConst {
    private final ASAccInfo accInfo;
    private final String target;
    private final IFlashNode parent;
    private final boolean hasChildren;
    private FlashTopNodeImpl swf;
    private DocumentImpl doc;
    private final IASNode flashNode;
    private final IASBridge flashPlayer;
    private static ISendEvent sendEvent;

    public int hashCode() {
        return this.target.intern().hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof FlashNodeImpl) {
            FlashNodeImpl f = (FlashNodeImpl)o;
            return ((Object)((Object)this.swf)).equals((Object)f.swf) && this.target.equals(f.target);
        }
        return false;
    }

    private FlashNodeImpl(IASNode node, IFlashNode parent) {
        this.flashNode = node;
        this.flashPlayer = node.getPlayer();
        this.target = node.getTarget();
        this.accInfo = node.getAccInfo();
        this.hasChildren = !node.isOpaqueObject();
        this.parent = parent;
    }

    FlashNodeImpl(FlashNodeImpl baseNode, IASNode node) {
        this(node, baseNode);
        this.swf = baseNode.swf;
        this.doc = baseNode.doc;
    }

    FlashNodeImpl(FlashTopNodeImpl baseNode, IASNode node) {
        this(node, baseNode);
        this.swf = baseNode;
        this.doc = (DocumentImpl)baseNode.getOwnerDocument();
    }

    private Object getProperty(String prop) {
        return this.flashPlayer.getProperty(this.getTarget(), prop);
    }

    private void setProperty(String prop, Object value) {
        this.flashPlayer.setProperty(this.getTarget(), prop, value);
    }

    private ISendEvent getSendEvent() {
        if (sendEvent == null) {
            sendEvent = ComPlugin.getDefault().newSendEvent();
        }
        return sendEvent;
    }

    public String getNodeName() {
        return "#flashNode:" + this.getTarget();
    }

    public String getNodeValue() throws DOMException {
        return null;
    }

    public void setNodeValue(String nodeValue) throws DOMException {
        throw new UnsupportedOperationException();
    }

    public short getNodeType() {
        return 1;
    }

    public Node getParentNode() {
        return this.parent;
    }

    public NodeList getChildNodes() {
        if (!this.hasChildren) {
            return EmptyNodeListImpl.getInstance();
        }
        IFlashNode[] r = this.getSWFChildNodes();
        return new NodeListImpl(r);
    }

    public Node getFirstChild() {
        if (!this.hasChildren) {
            return null;
        }
        IFlashNode[] r = this.getSWFChildNodes();
        if (r == null) {
            return null;
        }
        if (r.length == 0) {
            return null;
        }
        return r[0];
    }

    public Node getLastChild() {
        if (!this.hasChildren) {
            return null;
        }
        IFlashNode[] r = this.getSWFChildNodes();
        if (r == null) {
            return null;
        }
        if (r.length == 0) {
            return null;
        }
        return r[r.length - 1];
    }

    public Node getPreviousSibling() {
        throw new UnsupportedOperationException();
    }

    public Node getNextSibling() {
        throw new UnsupportedOperationException();
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public Document getOwnerDocument() {
        return this.doc;
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        throw new UnsupportedOperationException();
    }

    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        throw new UnsupportedOperationException();
    }

    public Node removeChild(Node oldChild) throws DOMException {
        throw new UnsupportedOperationException();
    }

    public Node appendChild(Node newChild) throws DOMException {
        throw new UnsupportedOperationException();
    }

    public boolean hasChildNodes() {
        if (!this.hasChildren) {
            return false;
        }
        IFlashNode[] r = this.getSWFChildNodes();
        if (r == null) {
            return false;
        }
        return r.length != 0;
    }

    public Node cloneNode(boolean deep) {
        throw new UnsupportedOperationException();
    }

    public void normalize() {
    }

    public boolean isSupported(String feature, String version) {
        return false;
    }

    public String getNamespaceURI() {
        return null;
    }

    public String getPrefix() {
        return null;
    }

    public void setPrefix(String prefix) throws DOMException {
        throw new UnsupportedOperationException();
    }

    public String getLocalName() {
        String target = this.getTarget();
        int idx = target.lastIndexOf(46);
        if (idx < 0) {
            return target;
        }
        return target.substring(idx + 1);
    }

    public boolean hasAttributes() {
        return false;
    }

    public String getBaseURI() {
        return null;
    }

    public short compareDocumentPosition(Node other) throws DOMException {
        return 0;
    }

    public String getTextContent() throws DOMException {
        return this.extractString();
    }

    public void setTextContent(String textContent) throws DOMException {
        throw new UnsupportedOperationException();
    }

    public boolean isSameNode(Node other) {
        return false;
    }

    public String lookupPrefix(String namespaceURI) {
        return null;
    }

    public boolean isDefaultNamespace(String namespaceURI) {
        return false;
    }

    public String lookupNamespaceURI(String prefix) {
        return null;
    }

    public boolean isEqualNode(Node arg) {
        return false;
    }

    public Object getFeature(String feature, String version) {
        return null;
    }

    public Object setUserData(String key, Object data, UserDataHandler handler) {
        throw new UnsupportedOperationException();
    }

    public Object getUserData(String key) {
        throw new UnsupportedOperationException();
    }

    private String decodeString(String input) {
        if (input == null) {
            return "";
        }
        try {
            return URLDecoder.decode(input, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return input;
        }
    }

    public String extractString() {
        String r = null;
        if (this.accInfo != null) {
            r = this.accInfo.getName();
        }
        if (r == null) {
            r = this.flashNode.getText(false);
        }
        if (r == null) {
            return "";
        }
        return r;
    }

    public short getHeadingLevel() {
        return 0;
    }

    public String getLinkURI() {
        return null;
    }

    public void setText(String text) {
        this.setProperty("text", text);
    }

    public String getText() {
        Object o = this.getProperty("text");
        if (o instanceof String) {
            return (String)o;
        }
        return "";
    }

    private boolean doHardwareClick() {
        long hwnd = this.swf.getHWND();
        int ix = (int)this.flashNode.getX();
        int iy = (int)this.flashNode.getY();
        int iw = (int)this.flashNode.getWidth();
        int ih = (int)this.flashNode.getHeight();
        int x = ix + iw / 4;
        int y = iy + ih / 4;
        this.getSendEvent().focusWindow(hwnd);
        this.setFocus();
        this.getSendEvent().postMouse(x, y, false);
        boolean result = this.getSendEvent().postMouse(x, y, true);
        return result;
    }

    String getClickableTarget(String current) {
        while (current.length() > 0) {
            String tryOnRelease = String.valueOf(current) + ".onRelease";
            if (this.swf.getNodeFromPath(tryOnRelease) != null) {
                return current;
            }
            String tryOnPress = String.valueOf(current) + ".onPress";
            if (this.swf.getNodeFromPath(tryOnPress) != null) {
                return current;
            }
            int idx = current.lastIndexOf(46);
            if (idx <= 0) break;
            current = current.substring(0, idx);
        }
        return null;
    }

    public boolean doClick() {
        String current = this.getTarget();
        if (current.length() > 0) {
            String tryOnRelease = String.valueOf(current) + ".onRelease";
            if (this.swf.getNodeFromPath(tryOnRelease) != null) {
                this.flashPlayer.callMethod(this.flashNode, "onRelease");
                return true;
            }
            String tryOnPress = String.valueOf(current) + ".onPress";
            if (this.swf.getNodeFromPath(tryOnPress) != null) {
                this.flashPlayer.callMethod(this.flashNode, "onPress");
                return true;
            }
        }
        return this.doHardwareClick();
    }

    public boolean highlight() {
        this.flashPlayer.callMethod(this.flashNode, "onRollOver");
        boolean ret1 = this.swf.highlight();
        boolean ret2 = this.flashNode.setMarker();
        return ret1 && ret2;
    }

    public boolean unhighlight() {
        this.flashPlayer.callMethod(this.flashNode, "onRollOut");
        boolean ret1 = this.swf.unhighlight();
        boolean ret2 = this.flashPlayer.unsetMarker();
        return ret1 && ret2;
    }

    public boolean setFocus() {
        if (!this.swf.setFocus()) {
            return false;
        }
        return this.flashPlayer.setFocus(this.getTarget());
    }

    public int getNth() {
        return 0;
    }

    public String getTarget() {
        return this.target;
    }

    public IFlashNode getNodeFromPath(String path) {
        return this.swf.getNodeFromPath(path);
    }

    public IFlashNode getNodeAtDepth(int depth) {
        IASNode result = this.flashPlayer.getNodeAtDepthWithPath(this.getTarget(), depth);
        if (result == null) {
            return null;
        }
        return new FlashNodeImpl(this.swf, result);
    }

    private IFlashNode[] createIFlashNodeArray(IASNode[] nodes) {
        IFlashNode[] results = new IFlashNode[nodes.length];
        int i = 0;
        while (i < nodes.length) {
            results[i] = new FlashNodeImpl(this, nodes[i]);
            ++i;
        }
        return results;
    }

    public IFlashNode[] getInnerNodes() {
        return this.createIFlashNodeArray(this.flashNode.getChildren(true));
    }

    public IFlashNode[] getSWFChildNodes() {
        return this.createIFlashNodeArray(this.flashNode.getChildren(false));
    }

    public int getDepth() {
        return this.flashNode.getDepth();
    }

    public int getCurrentFrame() {
        return this.flashNode.getCurrentFrame();
    }

    public IFlashNode[] translate() {
        return this.createIFlashNodeArray(this.flashPlayer.translateWithPath(this.getTarget()));
    }

    public INodeEx getBaseNode() {
        return this.swf;
    }

    boolean isInputable() {
        return this.flashNode.isInputable();
    }

    boolean isSilent() {
        return this.accInfo.isSilent();
    }

    public AnalyzedResult analyze(AnalyzedResult ar) {
        return ar;
    }

    public AbstractTerms getTerms() {
        return FlashTerms.getInstance();
    }

    public Rectangle getLocation() {
        return this.swf.getLocation();
    }

    public IFlashMSAANode getMSAA() {
        return null;
    }

    public void repairFlash() {
    }

    public String[] getStillPictureData() {
        return new String[3];
    }

    public char getAccessKey() {
        return '\u0000';
    }

    private static class NodeListImpl
    implements NodeList {
        private final IFlashNode[] nodes;

        public Node item(int index) {
            if (index < 0 || index >= this.nodes.length) {
                return null;
            }
            return this.nodes[index];
        }

        public int getLength() {
            return this.nodes.length;
        }

        NodeListImpl(IFlashNode[] nodes) {
            this.nodes = nodes;
        }
    }
}

