/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.blind;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.actf.util.FileUtils;
import org.eclipse.actf.visualization.engines.blind.BlindVizResourceUtil;
import org.eclipse.actf.visualization.engines.blind.TextChecker;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class BlindVizEnginePlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.actf.visualization.engines.blind";
    private static BlindVizEnginePlugin plugin;
    private static File tmpDir;

    static {
        tmpDir = null;
    }

    public BlindVizEnginePlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        String tmpS;
        super.start(context);
        if (!this.getPreferenceStore().getBoolean("blindViz.not_first_time")) {
            TextChecker.getInstance();
        }
        BlindVizEnginePlugin.createTempDirectory();
        if (tmpDir != null && FileUtils.isAvailableDirectory((String)(tmpS = String.valueOf(tmpDir.getAbsolutePath()) + File.separator + "img"))) {
            String tmpS2 = String.valueOf(tmpS) + File.separator;
            BlindVizResourceUtil.saveImages(tmpS2);
            BlindVizResourceUtil.saveScripts(tmpS2);
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.getPreferenceStore().setValue("blindViz.not_first_time", true);
        plugin = null;
        super.stop(context);
        this.deleteFiles(tmpDir);
    }

    public static BlindVizEnginePlugin getDefault() {
        return plugin;
    }

    public String getConfigDir() {
        try {
            URL url = plugin.getBundle().getEntry("config");
            url = FileLocator.resolve((URL)url);
            return new Path(url.getPath()).makeAbsolute().toOSString();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return "";
        }
    }

    private static void createTempDirectory() {
        if (tmpDir == null) {
            String tmpS = String.valueOf(plugin.getStateLocation().toOSString()) + File.separator + "tmp";
            if (FileUtils.isAvailableDirectory((String)tmpS)) {
                tmpDir = new File(tmpS);
            } else {
                System.err.println("org.eclipse.actf.visualization.engines.blind : can't create tmp Directory");
                tmpDir = new File(System.getProperty("java.io.tmpdir"));
            }
        }
    }

    public static File createTempFile(String prefix, String suffix) throws Exception {
        BlindVizEnginePlugin.createTempDirectory();
        return File.createTempFile(prefix, suffix, tmpDir);
    }

    public static File getTempDirectory() {
        if (tmpDir == null) {
            BlindVizEnginePlugin.createTempDirectory();
        }
        return tmpDir;
    }

    private void deleteFiles(File rootDir) {
        if (rootDir != null) {
            File[] fileList = rootDir.listFiles();
            int i = 0;
            while (i < fileList.length) {
                if (fileList[i].isDirectory()) {
                    this.deleteFiles(fileList[i]);
                }
                fileList[i].delete();
                ++i;
            }
        }
    }
}

