/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.odf;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.actf.model.dom.odf.base.ODFDocument;
import org.eclipse.actf.model.dom.odf.base.ODFNode;
import org.eclipse.actf.model.dom.odf.base.impl.ODFDocumentImpl;
import org.eclipse.actf.util.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ODFParser {
    private InputStream getFileInputStream(String odfName, String fileName) {
        URL url = null;
        try {
            url = new URL(odfName);
        }
        catch (MalformedURLException malformedURLException) {}
        ZipFile zipFile = null;
        ZipEntry zipEntry = null;
        try {
            zipFile = url != null ? new ZipFile(new File(url.toURI())) : new ZipFile(odfName);
            String zipFileName = fileName.replaceAll("\\\\", "/");
            zipEntry = zipFile.getEntry(zipFileName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        InputStream is = null;
        if (zipEntry != null) {
            try {
                is = zipFile.getInputStream(zipEntry);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return is;
    }

    private void createODFNode(Node parent, ODFDocument odfDoc, ODFNode odfNodeParent) {
        NodeList nl;
        int i;
        NamedNodeMap attrs;
        if (parent instanceof Element && (attrs = ((Element)parent).getAttributes()) != null && attrs.getLength() > 0) {
            i = 0;
            while (i < attrs.getLength()) {
                ((ODFDocumentImpl)odfDoc).getODFNode(attrs.item(i));
                ++i;
            }
        }
        if ((nl = parent.getChildNodes()) != null && nl.getLength() != 0) {
            i = 0;
            while (i < nl.getLength()) {
                Node child = nl.item(i);
                ODFNode odfChild = ((ODFDocumentImpl)odfDoc).getODFNode(child);
                this.createODFNode(child, odfDoc, odfChild);
                ++i;
            }
        }
    }

    private ODFDocument parse(InputSource is) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        Document document = null;
        try {
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            document = documentBuilder.parse(is);
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {}
        if (document == null) {
            return null;
        }
        Element root = document.getDocumentElement();
        ODFDocumentImpl odfDoc = new ODFDocumentImpl(document);
        ODFNode odfDocRoot = (ODFNode)((Object)odfDoc.getDocumentElement());
        this.createODFNode(root, odfDoc, odfDocRoot);
        return odfDoc;
    }

    public ODFDocument getDocument(String odfName, String xmlName) {
        ODFDocument odfDoc = null;
        try {
            InputStream is = this.getFileInputStream(odfName, xmlName);
            if (is != null) {
                odfDoc = this.parse(new InputSource(is));
                is.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return odfDoc;
    }

    public ODFDocument getDocument(String odfName) {
        ODFDocument contentDoc = this.getDocument(odfName, "content.xml");
        ODFDocument styleDoc = this.getDocument(odfName, "styles.xml");
        if (contentDoc != null) {
            contentDoc.setStyleDocument(styleDoc);
            contentDoc.setURL(odfName);
        }
        return contentDoc;
    }

    public String[] getFileEntries(String odfName) {
        ZipFile zipFile = null;
        URL url = null;
        try {
            url = new URL(odfName);
        }
        catch (MalformedURLException malformedURLException) {}
        try {
            zipFile = url != null ? new ZipFile(url.getPath()) : new ZipFile(odfName);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            ArrayList<String> list = new ArrayList<String>();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                list.add(name);
            }
            return list.toArray(new String[list.size()]);
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return null;
        }
    }

    public void copyFile(String odfName, String entry, String outputFileName) {
        InputStream is = this.getFileInputStream(odfName, entry);
        FileUtils.saveToFile((InputStream)is, (String)outputFileName, (boolean)true);
    }
}

