/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.odf.text.impl;

import java.util.Iterator;
import org.eclipse.actf.model.dom.odf.base.ODFDocument;
import org.eclipse.actf.model.dom.odf.base.ODFElement;
import org.eclipse.actf.model.dom.odf.base.impl.ODFStylableElementImpl;
import org.eclipse.actf.model.dom.odf.range.ITextElementContainer;
import org.eclipse.actf.model.dom.odf.style.StyleElement;
import org.eclipse.actf.model.dom.odf.text.ListElement;
import org.eclipse.actf.model.dom.odf.text.ListItemElement;
import org.eclipse.actf.model.dom.odf.text.ListLevelStyleBulletElement;
import org.eclipse.actf.model.dom.odf.text.ListLevelStyleNumberElement;
import org.eclipse.actf.model.dom.odf.text.ListStyleElement;
import org.eclipse.actf.util.xpath.XPathService;
import org.eclipse.actf.util.xpath.XPathServiceFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ListElementImpl
extends ODFStylableElementImpl
implements ListElement {
    private static final long serialVersionUID = -1816073361921569606L;
    private static final XPathService xpathService = XPathServiceFactory.newService();
    private static final Object EXP1 = xpathService.compile("./*[namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:text:1.0' and local-name()='list-item']");

    protected ListElementImpl(ODFDocument odfDoc, Element element) {
        super(odfDoc, element);
    }

    @Override
    public long getSize() {
        return xpathService.evalForNodeList(EXP1, (Node)this).getLength();
    }

    @Override
    public ListItemElement getItem(long idx) {
        NodeList nodeList = xpathService.evalPathForNodeList("./*[namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:text:1.0' and local-name()='list-item'][" + (idx + 1L) + "]", (Node)this);
        if (nodeList != null && nodeList.getLength() == 1 && nodeList.item(0) instanceof ListItemElement) {
            return (ListItemElement)nodeList.item(0);
        }
        return null;
    }

    @Override
    public StyleElement getStyle() {
        ListElement topLevelList = this.getTopLevelListElement();
        String styleName = topLevelList.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "style-name");
        ODFElement elem = this.findElementByAttrValue("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "list-style", "urn:oasis:names:tc:opendocument:xmlns:style:1.0", "name", styleName);
        if (elem != null && elem instanceof ListStyleElement) {
            return (StyleElement)elem;
        }
        return null;
    }

    @Override
    public void appendItem(ListItemElement item) {
    }

    @Override
    public void insertBefore(ListItemElement item, long idx) {
    }

    @Override
    public long getContentSize() {
        return 0L;
    }

    @Override
    public Iterator<ITextElementContainer> getChildIterator() {
        return null;
    }

    @Override
    public long getListLevel() {
        long level = 1L;
        ListElement topListElem = this;
        while (true) {
            Node parent = topListElem.getParentNode();
            Node gparent = null;
            if (parent != null) {
                gparent = parent.getParentNode();
            }
            if (parent == null || !(parent instanceof ListItemElement) || gparent == null || !(gparent instanceof ListElement)) break;
            topListElem = (ListElement)gparent;
            ++level;
        }
        return level;
    }

    @Override
    public ListElement getTopLevelListElement() {
        ListElement topListElem = this;
        while (true) {
            Node parent = topListElem.getParentNode();
            Node gparent = null;
            if (parent != null) {
                gparent = parent.getParentNode();
            }
            if (parent == null || !(parent instanceof ListItemElement) || gparent == null || !(gparent instanceof ListElement)) break;
            topListElem = (ListElement)gparent;
        }
        return topListElem;
    }

    @Override
    public StyleElement getListLevelStyleElement() {
        long level = this.getListLevel();
        StyleElement style = this.getStyle();
        if (style == null) {
            return null;
        }
        NodeList children = style.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child instanceof StyleElement) {
                if (child instanceof ListLevelStyleBulletElement && ((ListLevelStyleBulletElement)child).getAttrLevel() == level) {
                    return (StyleElement)child;
                }
                if (child instanceof ListLevelStyleNumberElement && ((ListLevelStyleNumberElement)child).getAttrLevel() == level) {
                    return (StyleElement)child;
                }
            }
            ++i;
        }
        return null;
    }
}

