/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.flash;

import org.eclipse.actf.model.flash.proxy.FlashCacheUtil;
import org.eclipse.actf.model.ui.util.PerspectiveListenerForBrowserLaunch;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class Startup
implements IStartup {
    public void earlyStartup() {
        IWorkbenchWindow[] windows;
        IWorkbenchWindow[] iWorkbenchWindowArray = windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            this.addListener(window);
            ++n2;
        }
        PlatformUI.getWorkbench().addWindowListener(new IWindowListener(){

            public void windowActivated(IWorkbenchWindow window) {
            }

            public void windowClosed(IWorkbenchWindow window) {
            }

            public void windowDeactivated(IWorkbenchWindow window) {
            }

            public void windowOpened(IWorkbenchWindow window) {
                Startup.this.addListener(window);
            }
        });
    }

    private void addListener(IWorkbenchWindow window) {
        final PerspectiveListenerForBrowserLaunch listener = new PerspectiveListenerForBrowserLaunch("org.eclipse.actf.visualization.ui.perspectives.FlashPerspective");
        final PerspectiveListenerForCacheCheck listener2 = new PerspectiveListenerForCacheCheck();
        window.addPerspectiveListener((IPerspectiveListener)listener);
        window.addPerspectiveListener((IPerspectiveListener)listener2);
        final IWorkbenchPage page = window.getActivePage();
        if (page != null) {
            window.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    listener.perspectiveActivated(page, page.getPerspective());
                    listener2.perspectiveActivated(page, page.getPerspective());
                }
            });
        }
    }

    private class PerspectiveListenerForCacheCheck
    implements IPerspectiveListener {
        private PerspectiveListenerForCacheCheck() {
        }

        public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
            if ("org.eclipse.actf.visualization.ui.perspectives.FlashPerspective".equals(perspective.getId())) {
                FlashCacheUtil.checkCache();
            }
        }

        public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
        }
    }
}

