/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.core.search.DLTKSearchParticipant;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchDocument;
import org.eclipse.dltk.core.search.SearchParticipant;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.SearchRequestor;
import org.eclipse.dltk.core.search.TypeNameMatch;
import org.eclipse.dltk.core.search.indexing.IndexManager;
import org.eclipse.dltk.core.search.matching.MatchLocator;
import org.eclipse.dltk.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.ScriptProject;
import org.eclipse.dltk.internal.core.SourceModule;
import org.eclipse.dltk.internal.core.search.DLTKSearchDocument;
import org.eclipse.dltk.internal.core.search.DLTKSearchScope;
import org.eclipse.dltk.internal.core.search.DLTKSearchTypeNameMatch;
import org.eclipse.dltk.internal.core.search.IRestrictedAccessTypeRequestor;
import org.eclipse.dltk.internal.core.search.PathCollector;
import org.eclipse.dltk.internal.core.search.PatternSearchJob;
import org.eclipse.dltk.internal.core.util.Messages;
import org.eclipse.dltk.internal.core.util.Util;

public class BasicSearchEngine {
    private ISourceModule[] workingCopies;
    private WorkingCopyOwner workingCopyOwner;
    public static boolean VERBOSE = false;

    public BasicSearchEngine() {
    }

    public BasicSearchEngine(ISourceModule[] workingCopies) {
        this.workingCopies = workingCopies;
    }

    char convertTypeKind(int typeDeclarationKind) {
        switch (typeDeclarationKind) {
            case 3001: {
                return 'C';
            }
        }
        return 'C';
    }

    public BasicSearchEngine(WorkingCopyOwner workingCopyOwner) {
        this.workingCopyOwner = workingCopyOwner;
    }

    public static IDLTKSearchScope createHierarchyScope(IType type) throws ModelException {
        return BasicSearchEngine.createHierarchyScope(type, DefaultWorkingCopyOwner.PRIMARY);
    }

    public static IDLTKSearchScope createHierarchyScope(IType type, WorkingCopyOwner owner) throws ModelException {
        return null;
    }

    public static IDLTKSearchScope createSearchScope(IModelElement[] elements) {
        return BasicSearchEngine.createSearchScope(elements, true);
    }

    public static IDLTKSearchScope createSearchScope(IModelElement[] elements, boolean includeReferencedProjects) {
        int includeMask = 7;
        if (includeReferencedProjects) {
            includeMask |= 8;
        }
        return BasicSearchEngine.createSearchScope(elements, includeMask);
    }

    public static IDLTKSearchScope createSearchScope(IModelElement[] elements, int includeMask) {
        IDLTKLanguageToolkit toolkit = null;
        if (elements.length > 0) {
            try {
                toolkit = DLTKLanguageManager.getLanguageToolkit(elements[0]);
            }
            catch (CoreException e) {
                if (DLTKCore.DEBUG) {
                    e.printStackTrace();
                }
                return null;
            }
        }
        if (toolkit == null) {
            return null;
        }
        DLTKSearchScope scope = new DLTKSearchScope(toolkit);
        HashSet visitedProjects = new HashSet(2);
        int i = 0;
        int length = elements.length;
        while (i < length) {
            IModelElement element = elements[i];
            if (element != null) {
                try {
                    if (element instanceof ScriptProject) {
                        scope.add((ScriptProject)element, includeMask, visitedProjects);
                    } else {
                        scope.add(element);
                    }
                }
                catch (ModelException modelException) {}
            }
            ++i;
        }
        return scope;
    }

    public static TypeNameMatch createTypeNameMatch(IType type, int modifiers) {
        return new DLTKSearchTypeNameMatch(type, modifiers);
    }

    public static IDLTKSearchScope createWorkspaceScope(IDLTKLanguageToolkit toolkit) {
        return ModelManager.getModelManager().getWorkspaceScope(toolkit);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void findMatches(SearchPattern pattern, SearchParticipant[] participants, IDLTKSearchScope scope, SearchRequestor requestor, IProgressMonitor monitor) throws CoreException {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (monitor != null) {
            monitor.beginTask(Messages.engine_searching, 100);
        }
        if (VERBOSE) {
            Util.verbose("Searching for pattern: " + pattern.toString());
            Util.verbose(scope.toString());
        }
        if (participants == null) {
            if (!VERBOSE) return;
            Util.verbose("No participants => do nothing!");
            return;
        }
        IndexManager indexManager = ModelManager.getModelManager().getIndexManager();
        try {
            try {
                requestor.beginReporting();
                int i = 0;
                int l = participants.length;
                while (i < l) {
                    Object var20_24;
                    SubProgressMonitor subMonitor;
                    if (monitor != null && monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    SearchParticipant participant = participants[i];
                    SubProgressMonitor subProgressMonitor = subMonitor = monitor == null ? null : new SubProgressMonitor(monitor, 1000);
                    if (subMonitor != null) {
                        subMonitor.beginTask("", 1000);
                    }
                    try {
                        try {
                            String[] indexMatchPaths;
                            if (subMonitor != null) {
                                subMonitor.subTask(Messages.bind(Messages.engine_searching_indexing, new String[]{participant.getDescription()}));
                            }
                            participant.beginSearching();
                            requestor.enterParticipant(participant);
                            PathCollector pathCollector = new PathCollector();
                            indexManager.performConcurrentJob(new PatternSearchJob(pattern, participant, scope, pathCollector), 3, (IProgressMonitor)subMonitor);
                            if (monitor != null && monitor.isCanceled()) {
                                throw new OperationCanceledException();
                            }
                            if (subMonitor != null) {
                                subMonitor.subTask(Messages.bind(Messages.engine_searching_matching, new String[]{participant.getDescription()}));
                            }
                            if ((indexMatchPaths = pathCollector.getPaths()) != null) {
                                SearchDocument[] matches;
                                pathCollector = null;
                                int indexMatchLength = indexMatchPaths.length;
                                SearchDocument[] indexMatches = new SearchDocument[indexMatchLength];
                                int j = 0;
                                while (true) {
                                    if (j >= indexMatchLength) {
                                        matches = MatchLocator.addWorkingCopies(pattern, indexMatches, this.getWorkingCopies(), participant);
                                        if (DLTKCore.DEBUG) {
                                            System.err.println("This is Quick fix... Dublicates of Interpreter libraris, should be handled not here...");
                                        }
                                        break;
                                    }
                                    indexMatches[j] = participant.getDocument(indexMatchPaths[j]);
                                    ++j;
                                }
                                ArrayList<Path> paths = new ArrayList<Path>();
                                ArrayList<SearchDocument> filteredMatches = new ArrayList<SearchDocument>();
                                int q = 0;
                                while (true) {
                                    if (q >= matches.length) {
                                        SearchDocument[] fmatches = filteredMatches.toArray(new SearchDocument[filteredMatches.size()]);
                                        participant.locateMatches(fmatches, pattern, scope, requestor, (IProgressMonitor)subMonitor);
                                    }
                                    Path path = new Path(matches[q].getPath());
                                    if (!paths.contains(path)) {
                                        paths.add(path);
                                        filteredMatches.add(matches[q]);
                                    }
                                    ++q;
                                }
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    catch (Throwable throwable) {
                        var20_24 = null;
                        requestor.exitParticipant(participant);
                        participant.doneSearching();
                        throw throwable;
                    }
                    {
                        var20_24 = null;
                        requestor.exitParticipant(participant);
                        participant.doneSearching();
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            Object var22_27 = null;
            requestor.endReporting();
            if (monitor == null) throw throwable;
            monitor.done();
            throw throwable;
        }
        {
            Object var22_28 = null;
            requestor.endReporting();
            if (monitor == null) return;
        }
        monitor.done();
    }

    /*
     * Exception decompiling
     */
    List findMatchesSourceOnly(SearchPattern pattern, SearchParticipant[] participants, IDLTKSearchScope scope, IProgressMonitor monitor) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 465->468)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static SearchParticipant getDefaultSearchParticipant() {
        return new DLTKSearchParticipant();
    }

    public static String getMatchRuleString(int matchRule) {
        if (matchRule == 0) {
            return "R_EXACT_MATCH";
        }
        StringBuffer buffer = new StringBuffer();
        int i = 1;
        while (i <= 8) {
            int bit = matchRule & 1 << i - 1;
            if (bit != 0 && buffer.length() > 0) {
                buffer.append(" | ");
            }
            switch (bit) {
                case 1: {
                    buffer.append("R_PREFIX_MATCH");
                    break;
                }
                case 8: {
                    buffer.append("R_CASE_SENSITIVE");
                    break;
                }
                case 32: {
                    buffer.append("R_EQUIVALENT_MATCH");
                    break;
                }
                case 16: {
                    buffer.append("R_ERASURE_MATCH");
                    break;
                }
                case 64: {
                    buffer.append("R_FULL_MATCH");
                    break;
                }
                case 2: {
                    buffer.append("R_PATTERN_MATCH");
                    break;
                }
                case 4: {
                    buffer.append("R_REGEXP_MATCH");
                    break;
                }
                case 128: {
                    buffer.append("R_CAMELCASE_MATCH");
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String getSearchForString(int searchFor) {
        switch (searchFor) {
            case 0: {
                return "TYPE";
            }
            case 1: {
                return "METHOD";
            }
            case 2: {
                return "FIELD";
            }
            case 8: {
                return "ANNOTATION_TYPE";
            }
        }
        return "UNKNOWN";
    }

    private ISourceModule[] getWorkingCopies() {
        int length;
        ISourceModule[] copies;
        if (this.workingCopies != null) {
            if (this.workingCopyOwner == null) {
                copies = ModelManager.getModelManager().getWorkingCopies(DefaultWorkingCopyOwner.PRIMARY, false);
                if (copies == null) {
                    copies = this.workingCopies;
                } else {
                    ISourceModule unit;
                    HashMap<IPath, ISourceModule> pathToCUs = new HashMap<IPath, ISourceModule>();
                    int i = 0;
                    int length2 = copies.length;
                    while (i < length2) {
                        unit = copies[i];
                        pathToCUs.put(unit.getPath(), unit);
                        ++i;
                    }
                    i = 0;
                    length2 = this.workingCopies.length;
                    while (i < length2) {
                        unit = this.workingCopies[i];
                        pathToCUs.put(unit.getPath(), unit);
                        ++i;
                    }
                    length = pathToCUs.size();
                    copies = new ISourceModule[length];
                    pathToCUs.values().toArray(copies);
                }
            } else {
                copies = this.workingCopies;
            }
        } else {
            copies = this.workingCopyOwner != null ? ModelManager.getModelManager().getWorkingCopies(this.workingCopyOwner, true) : ModelManager.getModelManager().getWorkingCopies(DefaultWorkingCopyOwner.PRIMARY, false);
        }
        if (copies == null) {
            return null;
        }
        ISourceModule[] result = null;
        length = copies.length;
        int index = 0;
        int i = 0;
        while (i < length) {
            SourceModule copy = (SourceModule)copies[i];
            try {
                if (!copy.isPrimary() || copy.hasUnsavedChanges() || copy.hasResourceChanged()) {
                    if (result == null) {
                        result = new ISourceModule[length];
                    }
                    result[index++] = copy;
                }
            }
            catch (ModelException modelException) {}
            ++i;
        }
        if (index != length && result != null) {
            ISourceModule[] iSourceModuleArray = result;
            result = new ISourceModule[index];
            System.arraycopy(iSourceModuleArray, 0, result, 0, index);
        }
        return result;
    }

    private ISourceModule[] getWorkingCopies(IModelElement element) {
        ISourceModule cu;
        if (element instanceof IMember && (cu = ((IMember)element).getSourceModule()) != null && cu.isWorkingCopy()) {
            int length;
            ISourceModule[] copies = this.getWorkingCopies();
            int n = length = copies == null ? 0 : copies.length;
            if (length > 0) {
                ISourceModule[] newWorkingCopies = new ISourceModule[length + 1];
                System.arraycopy(copies, 0, newWorkingCopies, 0, length);
                newWorkingCopies[length] = cu;
                return newWorkingCopies;
            }
            return new ISourceModule[]{cu};
        }
        return this.getWorkingCopies();
    }

    boolean match(char patternTypeSuffix, int modifiers) {
        switch (patternTypeSuffix) {
            case 'C': {
                return true;
            }
        }
        return true;
    }

    boolean match(char patternTypeSuffix, char[] patternPkg, char[] patternTypeName, int matchRule, int typeKind, char[] typeName) {
        boolean isCaseSensitive;
        boolean bl = isCaseSensitive = (matchRule & 8) != 0;
        if (patternTypeName != null) {
            boolean matchFirstChar;
            boolean isCamelCase = (matchRule & 0x80) != 0;
            int matchMode = matchRule & 7;
            if (!isCaseSensitive && !isCamelCase) {
                patternTypeName = CharOperation.toLowerCase(patternTypeName);
            }
            boolean bl2 = matchFirstChar = !isCaseSensitive || patternTypeName[0] == typeName[0];
            if (isCamelCase && matchFirstChar && CharOperation.camelCaseMatch(patternTypeName, typeName)) {
                return true;
            }
            switch (matchMode) {
                case 0: {
                    if (!isCamelCase) {
                        return matchFirstChar && CharOperation.equals(patternTypeName, typeName, isCaseSensitive);
                    }
                }
                case 1: {
                    return matchFirstChar && CharOperation.prefixEquals(patternTypeName, typeName, isCaseSensitive);
                }
                case 2: {
                    return CharOperation.match(patternTypeName, typeName, isCaseSensitive);
                }
            }
        }
        return true;
    }

    public void search(SearchPattern pattern, SearchParticipant[] participants, IDLTKSearchScope scope, SearchRequestor requestor, IProgressMonitor monitor) throws CoreException {
        if (VERBOSE) {
            Util.verbose("BasicSearchEngine.search(SearchPattern, SearchParticipant[], IJavaSearchScope, SearchRequestor, IProgressMonitor)");
        }
        this.findMatches(pattern, participants, scope, requestor, monitor);
    }

    public List searchSourceOnly(SearchPattern pattern, SearchParticipant[] participants, IDLTKSearchScope scope, IProgressMonitor monitor) throws CoreException {
        if (VERBOSE) {
            Util.verbose("BasicSearchEngine.search(SearchPattern, SearchParticipant[], IJavaSearchScope, SearchRequestor, IProgressMonitor)");
        }
        return this.findMatchesSourceOnly(pattern, participants, scope, monitor);
    }

    public void searchAllSecondaryTypeNames(IProjectFragment[] sourceFolders, IRestrictedAccessTypeRequestor nameRequestor, boolean waitForIndexes, IProgressMonitor progressMonitor) throws ModelException {
    }

    /*
     * Exception decompiling
     */
    public void searchAllTypeNames(char[] packageName, int packageMatchRule, char[] typeName, int typeMatchRule, int searchFor, IDLTKSearchScope scope, IRestrictedAccessTypeRequestor nameRequestor, int waitingPolicy, IProgressMonitor progressMonitor) throws ModelException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 722->726)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void searchAllTypeNames(char[][] qualifications, char[][] typeNames, int matchRule, int searchFor, IDLTKSearchScope scope, IRestrictedAccessTypeRequestor nameRequestor, int waitingPolicy, IProgressMonitor progressMonitor) throws ModelException {
        if (VERBOSE) {
            Util.verbose("BasicSearchEngine.searchAllTypeNames(char[][], char[][], int, int, IJavaSearchScope, IRestrictedAccessTypeRequestor, int, IProgressMonitor)");
            Util.verbose("\t- package name: " + (qualifications == null ? "null" : new String(CharOperation.concatWith(qualifications, ','))));
            Util.verbose("\t- type name: " + (typeNames == null ? "null" : new String(CharOperation.concatWith(typeNames, ','))));
            Util.verbose("\t- match rule: " + matchRule);
            Util.verbose("\t- search for: " + searchFor);
            Util.verbose("\t- scope: " + scope);
        }
    }

    public DLTKSearchParticipant getSearchParticipant(IModelElement element) {
        DLTKSearchParticipant par;
        IDLTKLanguageToolkit toolkit = null;
        try {
            toolkit = DLTKLanguageManager.getLanguageToolkit(element);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (toolkit != null && (par = DLTKLanguageManager.createSearchParticipant(toolkit.getNatureId())) != null) {
            return par;
        }
        return new DLTKSearchParticipant();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void searchDeclarations(IModelElement enclosingElement, SearchRequestor requestor, SearchPattern pattern, IProgressMonitor monitor) throws ModelException {
        if (VERBOSE) {
            Util.verbose("\t- script element: " + enclosingElement);
        }
        IDLTKSearchScope scope = BasicSearchEngine.createSearchScope(new IModelElement[]{enclosingElement});
        IResource resource = enclosingElement.getResource();
        if (enclosingElement instanceof IMember) {
            IMember member = (IMember)enclosingElement;
            ISourceModule cu = member.getSourceModule();
            if (cu != null) {
                resource = cu.getResource();
            } else if (((IProjectFragment)member.getAncestor(3)).isExternal()) {
                resource = null;
            }
        }
        try {
            if (!(resource instanceof IFile)) {
                this.search(pattern, new SearchParticipant[]{BasicSearchEngine.getDefaultSearchParticipant()}, scope, requestor, monitor);
                return;
            }
            try {
                requestor.beginReporting();
                if (VERBOSE) {
                    Util.verbose("Searching for " + pattern + " in " + resource.getFullPath());
                }
                DLTKSearchParticipant participant = this.getSearchParticipant(enclosingElement);
                boolean external = false;
                IProjectFragment fragment = (IProjectFragment)enclosingElement.getAncestor(3);
                if (fragment != null) {
                    external = fragment.isExternal();
                }
                SearchDocument[] documents = MatchLocator.addWorkingCopies(pattern, new SearchDocument[]{new DLTKSearchDocument(enclosingElement.getPath().toString(), participant, external)}, this.getWorkingCopies(enclosingElement), participant);
                ((SearchParticipant)participant).locateMatches(documents, pattern, scope, requestor, monitor);
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                requestor.endReporting();
                throw throwable;
            }
            {
                Object var11_15 = null;
                requestor.endReporting();
                return;
            }
        }
        catch (CoreException e) {
            if (!(e instanceof ModelException)) throw new ModelException(e);
            throw (ModelException)e;
        }
    }

    public void searchDeclarationsOfAccessedFields(IModelElement enclosingElement, SearchRequestor requestor, IProgressMonitor monitor) throws ModelException {
    }

    public void searchDeclarationsOfReferencedTypes(IModelElement enclosingElement, SearchRequestor requestor, IProgressMonitor monitor) throws ModelException {
    }

    public void searchDeclarationsOfSentMessages(IModelElement enclosingElement, SearchRequestor requestor, IProgressMonitor monitor) throws ModelException {
    }
}

