/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.dbgp.internal;

import java.net.URI;
import org.eclipse.dltk.dbgp.IDbgpStackLevel;

public class DbgpStackLevel
implements IDbgpStackLevel {
    private final int level;
    private final int lineNumber;
    private final int lineBegin;
    private final int lineEnd;
    private final URI fileUri;
    private final String where;

    public DbgpStackLevel(URI fileUri, String where, int level, int lineNumber, int lineBegin, int lineEnd) {
        this.fileUri = fileUri;
        this.level = level;
        this.lineNumber = lineNumber;
        this.lineBegin = lineBegin;
        this.lineEnd = lineEnd;
        this.where = where;
    }

    public String getWhere() {
        return this.where;
    }

    public int getLevel() {
        return this.level;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getLineBegin() {
        return this.lineBegin;
    }

    public int getLineEnd() {
        return this.lineEnd;
    }

    public URI getFileURI() {
        return this.fileUri;
    }

    public String toString() {
        return "DbgpStackLevel(level: " + this.level + ", line: " + this.lineNumber + ", begin: " + this.lineBegin + ", end: " + this.lineEnd + ")";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fileUri == null ? 0 : this.fileUri.hashCode());
        result = 31 * result + this.level;
        result = 31 * result + this.lineBegin;
        result = 31 * result + this.lineEnd;
        result = 31 * result + this.lineNumber;
        result = 31 * result + (this.where == null ? 0 : this.where.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DbgpStackLevel)) {
            return false;
        }
        DbgpStackLevel other = (DbgpStackLevel)obj;
        if (this.fileUri == null ? other.fileUri != null : !this.fileUri.equals(other.fileUri)) {
            return false;
        }
        if (this.level != other.level) {
            return false;
        }
        if (this.lineBegin != other.lineBegin) {
            return false;
        }
        if (this.lineEnd != other.lineEnd) {
            return false;
        }
        if (this.lineNumber != other.lineNumber) {
            return false;
        }
        return !(this.where == null ? other.where != null : !this.where.equals(other.where));
    }
}

