/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.core.model.operations;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.dbgp.IDbgpContinuationHandler;
import org.eclipse.dltk.dbgp.IDbgpStatus;
import org.eclipse.dltk.dbgp.commands.IDbgpCommands;
import org.eclipse.dltk.dbgp.commands.IDbgpCoreCommands;
import org.eclipse.dltk.dbgp.commands.IDbgpExtendedCommands;
import org.eclipse.dltk.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.debug.core.model.IScriptThread;

public abstract class DbgpOperation {
    private static final boolean DEBUG = DLTKCore.DEBUG;
    private final Job job;
    private final IDbgpContinuationHandler continuationHandler;
    private final IDbgpCommands commands;
    private final IScriptThread th;
    private final IResultHandler resultHandler;

    protected IDbgpCoreCommands getCore() {
        return this.commands.getCoreCommands();
    }

    protected IDbgpExtendedCommands getExtended() {
        return this.commands.getExtendedCommands();
    }

    protected IDbgpContinuationHandler getContinuationHandler() {
        return this.continuationHandler;
    }

    protected void callFinish(IDbgpStatus status) {
        if (DEBUG) {
            System.out.println("Status: " + status);
        }
        this.resultHandler.finish(status, null);
    }

    protected DbgpOperation(IScriptThread thread, String name, IResultHandler handler) {
        this.th = thread;
        this.resultHandler = handler;
        this.commands = thread.getDbgpSession();
        this.job = new Job(name){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    DbgpOperation.this.process();
                }
                catch (DbgpException e) {
                    if (DEBUG) {
                        System.out.println("Exception: " + e.getMessage());
                    }
                    DbgpOperation.this.resultHandler.finish(null, e);
                }
                return Status.OK_STATUS;
            }
        };
        this.job.setSystem(false);
        this.job.setUser(false);
        this.continuationHandler = new IDbgpContinuationHandler(){

            public void stderrReceived(String data) {
                try {
                    OutputStream err = DbgpOperation.this.th.getStreamProxy().getStderr();
                    err.write(data.getBytes());
                    err.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (DEBUG) {
                    System.out.println("Received (stderr): " + data);
                }
            }

            public void stdoutReceived(String data) {
                try {
                    OutputStream out = DbgpOperation.this.th.getStreamProxy().getStdout();
                    out.write(data.getBytes());
                    out.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (DEBUG) {
                    System.out.println("Received (stdout): " + data);
                }
            }
        };
    }

    public void schedule() {
        if (DEBUG) {
            System.out.println("Starting operation: " + this.job.getName());
        }
        this.job.schedule();
    }

    protected abstract void process() throws DbgpException;

    public static interface IResultHandler {
        public void finish(IDbgpStatus var1, DbgpException var2);
    }
}

