/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.ui;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.dltk.core.ICodeAssist;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.debug.core.eval.IScriptEvaluationEngine;
import org.eclipse.dltk.debug.core.eval.IScriptEvaluationResult;
import org.eclipse.dltk.debug.core.model.IScriptDebugTarget;
import org.eclipse.dltk.debug.core.model.IScriptStackFrame;
import org.eclipse.dltk.debug.core.model.IScriptThread;
import org.eclipse.dltk.debug.core.model.IScriptVariable;
import org.eclipse.dltk.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.debug.ui.ScriptDebugModelPresentation;
import org.eclipse.dltk.internal.ui.text.HTMLTextPresenter;
import org.eclipse.dltk.internal.ui.text.ScriptWordFinder;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.text.hover.IScriptEditorTextHover;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.EditorsUI;

public abstract class ScriptDebugHover
implements IScriptEditorTextHover,
ITextHoverExtension {
    private IEditorPart editor;
    static /* synthetic */ Class class$0;

    public void setEditor(IEditorPart editor) {
        this.editor = editor;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return ScriptWordFinder.findWord((IDocument)textViewer.getDocument(), (int)offset);
    }

    protected IScriptStackFrame getFrame() {
        IAdaptable adaptable = DebugUITools.getDebugContext();
        if (adaptable != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.dltk.debug.core.model.IScriptStackFrame");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (IScriptStackFrame)adaptable.getAdapter((Class)clazz);
        }
        return null;
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        IScriptStackFrame frame = this.getFrame();
        if (frame != null) {
            IDocument document = textViewer.getDocument();
            if (document != null) {
                try {
                    String snippet = document.get(hoverRegion.getOffset(), hoverRegion.getLength());
                    try {
                        IScriptVariable variable = frame.findVariable(snippet.trim());
                        if (variable != null) {
                            return this.getVariableText((IVariable)variable);
                        }
                        IScriptEvaluationEngine engine = ((IScriptThread)frame.getThread()).getEvaluationEngine();
                        IScriptEvaluationResult result = engine.syncEvaluate(snippet, null);
                        if (result != null) {
                            return this.getResultText(result);
                        }
                    }
                    catch (DebugException e1) {
                        e1.printStackTrace();
                    }
                }
                catch (BadLocationException badLocationException) {
                    return null;
                }
            }
            ICodeAssist codeAssist = null;
            if (this.editor != null) {
                IEditorInput input = this.editor.getEditorInput();
                ISourceModule element = DLTKUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(input);
                if (element instanceof ICodeAssist) {
                    codeAssist = (ICodeAssist)element;
                }
            }
            IModelElement[] resolve = null;
            try {
                resolve = codeAssist.codeSelect(hoverRegion.getOffset(), hoverRegion.getLength());
            }
            catch (ModelException modelException) {
                resolve = new IModelElement[]{};
            }
            int i = 0;
            while (i < resolve.length) {
                IModelElement scriptElement = resolve[i];
                System.out.println("Element: " + scriptElement.getClass());
                if (scriptElement instanceof IField) {
                    IField cfr_ignored_0 = (IField)scriptElement;
                    IScriptDebugTarget cfr_ignored_1 = (IScriptDebugTarget)frame.getDebugTarget();
                }
                ++i;
            }
        }
        return null;
    }

    protected String getResultText(IScriptEvaluationResult result) throws DebugException {
        return this.prepareHtml(String.valueOf(result.getSnippet()) + " = " + result.getValue().getValueString());
    }

    protected String getVariableText(IVariable variable) throws DebugException {
        return this.prepareHtml(String.valueOf(variable.getName()) + " = " + variable.getValue().getValueString());
    }

    protected String prepareHtml(String text) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<p><pre>");
        buffer.append(ScriptDebugHover.replaceHTMLChars(text));
        buffer.append("</pre></p>");
        if (buffer.length() > 0) {
            return buffer.toString();
        }
        return null;
    }

    private static String replaceHTMLChars(String variableText) {
        StringBuffer buffer = new StringBuffer(variableText.length());
        char[] characters = variableText.toCharArray();
        int i = 0;
        while (i < characters.length) {
            char character = characters[i];
            switch (character) {
                case '<': {
                    buffer.append("&lt;");
                    break;
                }
                case '>': {
                    buffer.append("&gt;");
                    break;
                }
                case '&': {
                    buffer.append("&amp;");
                    break;
                }
                case '\"': {
                    buffer.append("&quot;");
                    break;
                }
                default: {
                    buffer.append(character);
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    public static boolean getBooleanPreferenceValue(String id, String preference) {
        String compositeKey = String.valueOf(id) + "." + preference;
        IPreferenceStore store = DLTKDebugUIPlugin.getDefault().getPreferenceStore();
        boolean value = false;
        value = store.contains(compositeKey) ? store.getBoolean(compositeKey) : store.getBoolean(preference);
        return value;
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true), EditorsUI.getTooltipAffordanceString());
            }
        };
    }

    protected abstract ScriptDebugModelPresentation getModelPresentation();
}

