/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.compiler.problem;

import java.util.Arrays;
import org.eclipse.dltk.compiler.problem.CategorizedProblem;
import org.eclipse.dltk.compiler.util.Messages;
import org.eclipse.dltk.compiler.util.Util;
import org.eclipse.dltk.core.DLTKCore;

public class DefaultProblem
extends CategorizedProblem {
    private String fileName;
    private int id;
    private int startPosition;
    private int endPosition;
    private int line;
    private int column;
    private int severity;
    private String[] arguments;
    private String message;
    private static final String MARKER_TYPE_PROBLEM = "org.eclipse.dltk.core.problem";
    private static final String MARKER_TYPE_TASK = "org.eclipse.dltk.core.task";
    public static final Object[] EMPTY_VALUES = new Object[0];

    private static int hashCode(Object[] array) {
        if (array == null) {
            return 0;
        }
        int result = 1;
        int index = 0;
        while (index < array.length) {
            result = 31 * result + (array[index] == null ? 0 : array[index].hashCode());
            ++index;
        }
        return result;
    }

    public DefaultProblem(String originatingFileName, String message, int id, String[] stringArguments, int severity, int startPosition, int endPosition, int line, int column) {
        this.fileName = originatingFileName;
        this.message = message;
        this.id = id;
        this.arguments = stringArguments;
        this.severity = severity;
        this.startPosition = startPosition;
        this.endPosition = endPosition;
        this.line = line;
        this.column = column;
    }

    public DefaultProblem(String originatingFileName, String message, int id, String[] stringArguments, int severity, int startPosition, int endPosition, int line) {
        this(originatingFileName, message, id, stringArguments, severity, startPosition, endPosition, line, 0);
    }

    public String errorReportSource(char[] unitSource) {
        return this.errorReportSource(unitSource, 0);
    }

    public String errorReportSource(char[] unitSource, int tagBits) {
        char c;
        if (this.startPosition > this.endPosition || this.startPosition < 0 && this.endPosition < 0 || unitSource.length == 0) {
            return Messages.problem_noSourceInformation;
        }
        StringBuffer errorBuffer = new StringBuffer();
        if (DLTKCore.DEBUG) {
            System.err.println("TODO: Add correct code here. DefaultProblem");
        }
        errorBuffer.append('\t');
        int length = unitSource.length;
        int begin = this.startPosition >= length ? length - 1 : this.startPosition;
        while (begin > 0) {
            c = unitSource[begin - 1];
            if (c == '\n' || c == '\r') break;
            --begin;
        }
        int end = this.endPosition >= length ? length - 1 : this.endPosition;
        while (end + 1 < length) {
            c = unitSource[end + 1];
            if (c == '\r' || c == '\n') break;
            ++end;
        }
        while ((c = unitSource[begin]) == ' ' || c == '\t') {
            ++begin;
        }
        errorBuffer.append(unitSource, begin, end - begin + 1);
        errorBuffer.append(Util.LINE_SEPARATOR).append("\t");
        int i = begin;
        while (i < this.startPosition) {
            errorBuffer.append(unitSource[i] == '\t' ? (char)'\t' : ' ');
            ++i;
        }
        i = this.startPosition;
        while (i <= (this.endPosition >= length ? length - 1 : this.endPosition)) {
            errorBuffer.append('^');
            ++i;
        }
        return errorBuffer.toString();
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public int getCategoryID() {
        if (DLTKCore.DEBUG) {
            System.err.println("TODO: DefaultProblem getCategoryID always return 0. Fix it.");
        }
        return 0;
    }

    public int getID() {
        return this.id;
    }

    public String getInternalCategoryMessage() {
        switch (this.getCategoryID()) {
            case 0: {
                return "unspecified";
            }
            case 10: {
                return "buildpath";
            }
            case 20: {
                return "syntax";
            }
            case 30: {
                return "import";
            }
            case 40: {
                return "type";
            }
            case 50: {
                return "member";
            }
            case 60: {
                return "internal";
            }
            case 80: {
                return "code style";
            }
            case 90: {
                return "potential programming problem";
            }
            case 100: {
                return "name shadowing conflict";
            }
            case 110: {
                return "deprecation";
            }
            case 120: {
                return "unnecessary code";
            }
            case 130: {
                return "unchecked/raw";
            }
            case 140: {
                return "nls";
            }
            case 150: {
                return "restriction";
            }
        }
        return null;
    }

    public String getMarkerType() {
        return this.id == 536871362 ? MARKER_TYPE_TASK : MARKER_TYPE_PROBLEM;
    }

    public String getMessage() {
        return this.message;
    }

    public int getColumn() {
        return this.column;
    }

    public String getOriginatingFileName() {
        return this.fileName;
    }

    public int getSourceEnd() {
        return this.endPosition;
    }

    public int getSourceLineNumber() {
        return this.line;
    }

    public int getSourceStart() {
        return this.startPosition;
    }

    public boolean isError() {
        return (this.severity & 1) != 0;
    }

    public boolean isWarning() {
        return (this.severity & 1) == 0;
    }

    public void setOriginatingFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setSourceEnd(int sourceEnd) {
        this.endPosition = sourceEnd;
    }

    public void setSourceLineNumber(int lineNumber) {
        this.line = lineNumber;
    }

    public void setSourceStart(int sourceStart) {
        this.startPosition = sourceStart;
    }

    public String toString() {
        String s = "Pb(" + (this.id & 0xFFFFFF) + ") ";
        if (this.message != null) {
            s = String.valueOf(s) + this.message;
        } else if (this.arguments != null) {
            int i = 0;
            while (i < this.arguments.length) {
                s = String.valueOf(s) + " " + this.arguments[i];
                ++i;
            }
        }
        return s;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + DefaultProblem.hashCode(this.arguments);
        result = 31 * result + this.column;
        result = 31 * result + this.endPosition;
        result = 31 * result + (this.fileName == null ? 0 : this.fileName.hashCode());
        result = 31 * result + this.id;
        result = 31 * result + this.line;
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + this.severity;
        result = 31 * result + this.startPosition;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultProblem other = (DefaultProblem)obj;
        if (!Arrays.equals(this.arguments, other.arguments)) {
            return false;
        }
        if (this.column != other.column) {
            return false;
        }
        if (this.endPosition != other.endPosition) {
            return false;
        }
        if (this.fileName == null ? other.fileName != null : !this.fileName.equals(other.fileName)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.line != other.line) {
            return false;
        }
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        if (this.severity != other.severity) {
            return false;
        }
        return this.startPosition == other.startPosition;
    }
}

