/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.compiler.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.eclipse.dltk.compiler.CharOperation;

public class Util {
    private static final int DEFAULT_READING_SIZE = 8192;
    public static final String UTF_8 = "UTF-8";
    public static String LINE_SEPARATOR = System.getProperty("line.separator");

    public static byte[] getInputStreamAsByteArray(InputStream stream, int length) throws IOException {
        byte[] contents;
        if (length == -1) {
            contents = new byte[]{};
            int contentsLength = 0;
            int amountRead = -1;
            do {
                int amountRequested;
                if (contentsLength + (amountRequested = Math.max(stream.available(), 8192)) > contents.length) {
                    byte[] byArray = contents;
                    contents = new byte[contentsLength + amountRequested];
                    System.arraycopy(byArray, 0, contents, 0, contentsLength);
                }
                if ((amountRead = stream.read(contents, contentsLength, amountRequested)) <= 0) continue;
                contentsLength += amountRead;
            } while (amountRead != -1);
            if (contentsLength < contents.length) {
                byte[] byArray = contents;
                contents = new byte[contentsLength];
                System.arraycopy(byArray, 0, contents, 0, contentsLength);
            }
        } else {
            contents = new byte[length];
            int len = 0;
            int readSize = 0;
            while (readSize != -1 && len != length) {
                readSize = stream.read(contents, len += readSize, length - len);
            }
        }
        return contents;
    }

    public static byte[] getFileByteContent(File file) throws IOException {
        byte[] byArray;
        block5: {
            FileInputStream stream = null;
            try {
                stream = new FileInputStream(file);
                byArray = Util.getInputStreamAsByteArray(stream, (int)file.length());
                Object var2_3 = null;
                if (stream == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var2_4 = null;
                    if (stream == null) break block6;
                    try {
                        ((InputStream)stream).close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                ((InputStream)stream).close();
            }
            catch (IOException iOException) {}
        }
        return byArray;
    }

    public static char[] getInputStreamAsCharArray(InputStream stream, int length, String encoding) throws IOException {
        InputStreamReader reader = null;
        try {
            reader = encoding == null ? new InputStreamReader(stream) : new InputStreamReader(stream, encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            reader = new InputStreamReader(stream);
        }
        int totalRead = 0;
        char[] contents = length == -1 ? CharOperation.NO_CHAR : new char[length];
        while (true) {
            int amountRequested;
            if (totalRead < length) {
                amountRequested = length - totalRead;
            } else {
                int current = reader.read();
                if (current < 0) break;
                amountRequested = Math.max(stream.available(), 8192);
                if (totalRead + 1 + amountRequested > contents.length) {
                    char[] cArray = contents;
                    contents = new char[totalRead + 1 + amountRequested];
                    System.arraycopy(cArray, 0, contents, 0, totalRead);
                }
                contents[totalRead++] = (char)current;
            }
            int amountRead = reader.read(contents, totalRead, amountRequested);
            if (amountRead < 0) break;
            totalRead += amountRead;
        }
        int start = 0;
        if (totalRead > 0 && UTF_8.equals(encoding) && contents[0] == '\ufeff') {
            --totalRead;
            start = 1;
        }
        if (totalRead < contents.length) {
            char[] cArray = contents;
            contents = new char[totalRead];
            System.arraycopy(cArray, start, contents, 0, totalRead);
        }
        return contents;
    }

    public static final boolean isArchiveFileName(String name) {
        if (name == null) {
            return false;
        }
        return name.toLowerCase().endsWith(".zip") || name.toLowerCase().endsWith(".zip");
    }

    public static final boolean isExcluded(char[] path, char[][] inclusionPatterns, char[][] exclusionPatterns, boolean isFolderPath) {
        int length;
        int i;
        block9: {
            if (inclusionPatterns == null && exclusionPatterns == null) {
                return false;
            }
            if (inclusionPatterns != null) {
                i = 0;
                length = inclusionPatterns.length;
                while (i < length) {
                    int star;
                    int lastSlash;
                    char[] pattern;
                    char[] folderPattern = pattern = inclusionPatterns[i];
                    if (isFolderPath && (lastSlash = CharOperation.lastIndexOf('/', pattern)) != -1 && lastSlash != pattern.length - 1 && ((star = CharOperation.indexOf('*', pattern, lastSlash)) == -1 || star >= pattern.length - 1 || pattern[star + 1] != '*')) {
                        folderPattern = CharOperation.subarray(pattern, 0, lastSlash);
                    }
                    if (!CharOperation.pathMatch(folderPattern, path, true, '/')) {
                        ++i;
                        continue;
                    }
                    break block9;
                }
                return true;
            }
        }
        if (isFolderPath) {
            path = CharOperation.concat(path, new char[]{'*'}, '/');
        }
        if (exclusionPatterns != null) {
            i = 0;
            length = exclusionPatterns.length;
            while (i < length) {
                if (CharOperation.pathMatch(exclusionPatterns[i], path, true, '/')) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static char[] getFileCharContent(File file, String encoding) throws IOException {
        char[] cArray;
        block5: {
            FileInputStream stream = null;
            try {
                stream = new FileInputStream(file);
                cArray = Util.getInputStreamAsCharArray(stream, (int)file.length(), encoding);
                Object var3_4 = null;
                if (stream == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var3_5 = null;
                    if (stream == null) break block6;
                    try {
                        ((InputStream)stream).close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                ((InputStream)stream).close();
            }
            catch (IOException iOException) {}
        }
        return cArray;
    }
}

