/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ti;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.ti.GoalEngine;
import org.eclipse.dltk.ti.GoalState;
import org.eclipse.dltk.ti.IGoalEvaluatorFactory;
import org.eclipse.dltk.ti.IPruner;
import org.eclipse.dltk.ti.ITypeInferencer;
import org.eclipse.dltk.ti.TimelimitPruner;
import org.eclipse.dltk.ti.goals.AbstractTypeGoal;
import org.eclipse.dltk.ti.goals.GoalEvaluator;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.goals.NullGoalEvaluator;
import org.eclipse.dltk.ti.statistics.IEvaluationStatisticsRequestor;
import org.eclipse.dltk.ti.types.IEvaluatedType;

public class DefaultTypeInferencer
implements ITypeInferencer {
    private Map evaluators = new HashMap();
    private static Set statRequestors = new HashSet();
    private final GoalEngine engine;
    private final IGoalEvaluatorFactory userFactory;
    private final ProxyStatisticsRequestor stat = new ProxyStatisticsRequestor();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    private void initStdGoals() {
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("org.eclipse.dltk.ti.goals.FieldReferencesGoal");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz2 = class$2) == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.dltk.ti.goals.FieldReferencesGoalEvaluator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.registerEvaluator(clazz3, clazz2);
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.eclipse.dltk.ti.goals.MethodCallsGoal");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz = class$4) == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.dltk.ti.goals.MethodCallsGoalEvaluator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.registerEvaluator(clazz4, clazz);
    }

    public DefaultTypeInferencer(IGoalEvaluatorFactory userFactory) {
        this.engine = new GoalEngine(new MapBasedEvaluatorFactory());
        this.userFactory = userFactory;
        this.initStdGoals();
    }

    public void registerEvaluator(Class goalClass, Class evaluatorClass) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dltk.ti.goals.IGoal");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Assert.isLegal((boolean)clazz.isAssignableFrom(goalClass));
        Class<?> clazz2 = class$5;
        if (clazz2 == null) {
            try {
                clazz2 = class$5 = Class.forName("org.eclipse.dltk.ti.goals.GoalEvaluator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Assert.isLegal((boolean)clazz2.isAssignableFrom(evaluatorClass));
        this.evaluators.put(goalClass, evaluatorClass);
    }

    public IEvaluatedType evaluateType(AbstractTypeGoal goal, int timeLimit) {
        IEvaluatedType result = this.evaluateType(goal, new TimelimitPruner(timeLimit));
        return result;
    }

    public IEvaluatedType evaluateType(AbstractTypeGoal goal, IPruner pruner) {
        return (IEvaluatedType)this.engine.evaluateGoal(goal, pruner, this.stat);
    }

    protected Object evaluateGoal(IGoal goal, IPruner pruner) {
        return this.engine.evaluateGoal(goal, pruner, this.stat);
    }

    public IEvaluatedType evaluateType(AbstractTypeGoal goal) {
        return this.evaluateType(goal, null);
    }

    public static void addEvaluationStatisticsRequestor(IEvaluationStatisticsRequestor r) {
        statRequestors.add(r);
    }

    public static void removeEvaluationStatisticsRequestor(IEvaluationStatisticsRequestor r) {
        statRequestors.remove(r);
    }

    private class MapBasedEvaluatorFactory
    implements IGoalEvaluatorFactory {
        private MapBasedEvaluatorFactory() {
        }

        public GoalEvaluator createEvaluator(IGoal goal) {
            GoalEvaluator evaluator = null;
            if (DefaultTypeInferencer.this.userFactory != null && (evaluator = DefaultTypeInferencer.this.userFactory.createEvaluator(goal)) != null) {
                return evaluator;
            }
            Class<?> goalClass = goal.getClass();
            evaluator = DefaultTypeInferencer.this.evaluators.get(goalClass);
            if (evaluator == null || !(evaluator instanceof Class)) {
                String className = goalClass.getName();
                if (DLTKCore.DEBUG) {
                    System.err.println("No evaluator registered for " + className.substring(className.lastIndexOf(46)) + ": " + goal + " - using NullGoalEvaluator");
                }
                return new NullGoalEvaluator(goal);
            }
            Class evalClass = (Class)((Object)evaluator);
            try {
                Class[] classArray = new Class[1];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.dltk.ti.goals.IGoal");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz;
                GoalEvaluator newInstance = (GoalEvaluator)evalClass.getConstructor(classArray).newInstance(goal);
                return newInstance;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            return null;
        }
    }

    private static class ProxyStatisticsRequestor
    implements IEvaluationStatisticsRequestor {
        private ProxyStatisticsRequestor() {
        }

        public void evaluationStarted(IGoal rootGoal) {
            Iterator iterator = statRequestors.iterator();
            while (iterator.hasNext()) {
                IEvaluationStatisticsRequestor t = (IEvaluationStatisticsRequestor)iterator.next();
                if (t == null) continue;
                t.evaluationStarted(rootGoal);
            }
        }

        public void evaluatorInitialized(GoalEvaluator evaluator, IGoal[] subgoals, long time) {
            Iterator iterator = statRequestors.iterator();
            while (iterator.hasNext()) {
                IEvaluationStatisticsRequestor t = (IEvaluationStatisticsRequestor)iterator.next();
                if (t == null) continue;
                t.evaluatorInitialized(evaluator, subgoals, time);
            }
        }

        public void evaluatorProducedResult(GoalEvaluator evaluator, Object result, long time) {
            Iterator iterator = statRequestors.iterator();
            while (iterator.hasNext()) {
                IEvaluationStatisticsRequestor t = (IEvaluationStatisticsRequestor)iterator.next();
                if (t == null) continue;
                t.evaluatorProducedResult(evaluator, result, time);
            }
        }

        public void evaluatorReceivedResult(GoalEvaluator evaluator, IGoal finishedGoal, IGoal[] newSubgoals, long time) {
            Iterator iterator = statRequestors.iterator();
            while (iterator.hasNext()) {
                IEvaluationStatisticsRequestor t = (IEvaluationStatisticsRequestor)iterator.next();
                if (t == null) continue;
                t.evaluatorReceivedResult(evaluator, finishedGoal, newSubgoals, time);
            }
        }

        public void goalEvaluatorAssigned(IGoal goal, GoalEvaluator evaluator) {
            Iterator iterator = statRequestors.iterator();
            while (iterator.hasNext()) {
                IEvaluationStatisticsRequestor t = (IEvaluationStatisticsRequestor)iterator.next();
                if (t == null) continue;
                t.goalEvaluatorAssigned(goal, evaluator);
            }
        }

        public void goalStateChanged(IGoal goal, GoalState state, GoalState oldState) {
            Iterator iterator = statRequestors.iterator();
            while (iterator.hasNext()) {
                IEvaluationStatisticsRequestor t = (IEvaluationStatisticsRequestor)iterator.next();
                if (t == null) continue;
                t.goalStateChanged(goal, state, oldState);
            }
        }
    }
}

