/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.debug.ui.console;

import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.ruby.internal.debug.ui.console.ConsoleMessages;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class RubyFileHyperlink
implements IHyperlink {
    private TextConsole fConsole;

    public RubyFileHyperlink(TextConsole console) {
        this.fConsole = console;
    }

    public void linkEntered() {
    }

    public void linkExited() {
    }

    public void linkActivated() {
        try {
            String editorId;
            IEditorInput editorInput;
            Object sourceElement;
            int lineNumber;
            String fileName;
            try {
                String linkText = this.getLinkText();
                fileName = this.getFileName(linkText);
                lineNumber = this.getLineNumber(linkText);
            }
            catch (CoreException e1) {
                ErrorDialog.openError((Shell)DLTKDebugUIPlugin.getActiveWorkbenchShell(), (String)ConsoleMessages.RubyFileHyperlink_Error, (String)ConsoleMessages.RubyFileHyperlink_Error, (IStatus)e1.getStatus());
                return;
            }
            if (lineNumber > 0) {
                --lineNumber;
            }
            if ((sourceElement = this.getSourceModule(fileName)) != null && (editorInput = this.getEditorInput(sourceElement)) != null && (editorId = this.getEditorId(editorInput, sourceElement)) != null) {
                IEditorPart editorPart = DLTKDebugUIPlugin.getActivePage().openEditor(editorInput, editorId);
                if (editorPart instanceof ITextEditor && lineNumber >= 0) {
                    ITextEditor textEditor = (ITextEditor)editorPart;
                    IDocumentProvider provider = textEditor.getDocumentProvider();
                    provider.connect((Object)editorInput);
                    IDocument document = provider.getDocument((Object)editorInput);
                    try {
                        IRegion line = document.getLineInformation(lineNumber);
                        textEditor.selectAndReveal(line.getOffset(), line.getLength());
                    }
                    catch (BadLocationException badLocationException) {
                        MessageDialog.openInformation((Shell)DLTKDebugUIPlugin.getActiveWorkbenchShell(), (String)ConsoleMessages.RubyFileHyperlink_0, (String)MessageFormat.format("{0}{1}{2}", String.valueOf(lineNumber + 1), ConsoleMessages.RubyFileHyperlink_1, fileName));
                    }
                    provider.disconnect((Object)editorInput);
                }
                return;
            }
            MessageDialog.openInformation((Shell)DLTKDebugUIPlugin.getActiveWorkbenchShell(), (String)ConsoleMessages.RubyFileHyperlink_Information_1, (String)MessageFormat.format(ConsoleMessages.RubyFileHyperlink_Source_not_found_for__0__2, fileName));
        }
        catch (CoreException e) {
            DLTKDebugUIPlugin.errorDialog((String)ConsoleMessages.RubyFileHyperlink_An_exception_occurred_while_following_link__3, (Throwable)e);
            return;
        }
    }

    public String getEditorId(IEditorInput input, Object inputObject) {
        try {
            IEditorDescriptor descriptor = IDE.getEditorDescriptor((String)input.getName());
            return descriptor.getId();
        }
        catch (PartInitException partInitException) {
            return null;
        }
    }

    public IEditorInput getEditorInput(Object item) {
        try {
            return EditorUtility.getEditorInput((Object)item);
        }
        catch (CoreException e) {
            DLTKDebugUIPlugin.log((Throwable)e);
            return null;
        }
    }

    protected Object getSourceModule(String fileName) throws CoreException {
        IFile f = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(fileName));
        return f;
    }

    protected String getFileName(String linkText) throws CoreException {
        Pattern p = Pattern.compile("^(.+rb):(\\d+)$");
        Matcher m = p.matcher(linkText);
        if (m.find()) {
            String name = m.group(1);
            return name;
        }
        Status status = new Status(4, DLTKDebugUIPlugin.getUniqueIdentifier(), 0, ConsoleMessages.RubyFileHyperlink_Unable_to_parse_type_name_from_hyperlink__5, null);
        throw new CoreException((IStatus)status);
    }

    protected int getLineNumber(String linkText) throws CoreException {
        Pattern p = Pattern.compile("^(.+rb):(\\d+)$");
        Matcher m = p.matcher(linkText);
        if (m.find()) {
            String lineText = m.group(2);
            try {
                return Integer.parseInt(lineText);
            }
            catch (NumberFormatException e) {
                Status status = new Status(4, DLTKDebugUIPlugin.getUniqueIdentifier(), 0, ConsoleMessages.RubyFileHyperlink_Unable_to_parse_line_number_from_hyperlink__6, (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
        Status status = new Status(4, DLTKDebugUIPlugin.getUniqueIdentifier(), 0, ConsoleMessages.RubyFileHyperlink_Unable_to_parse_line_number_from_hyperlink__7, null);
        throw new CoreException((IStatus)status);
    }

    protected TextConsole getConsole() {
        return this.fConsole;
    }

    protected String getLinkText() throws CoreException {
        try {
            IDocument document = this.getConsole().getDocument();
            IRegion region = this.getConsole().getRegion((IHyperlink)this);
            return document.get(region.getOffset(), region.getLength());
        }
        catch (BadLocationException e) {
            Status status = new Status(4, DLTKDebugUIPlugin.getUniqueIdentifier(), 0, ConsoleMessages.RubyFileHyperlink_Unable_to_retrieve_hyperlink_text__8, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }
}

