/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.launching;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.internal.launching.InterpreterMessages;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallType;
import org.eclipse.dltk.launching.LaunchingMessages;
import org.eclipse.dltk.launching.LibraryLocation;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.osgi.framework.Bundle;

public abstract class AbstractInterpreterInstallType
implements IInterpreterInstallType,
IExecutableExtension {
    private List fInterpreters = new ArrayList();
    private String fId;
    private static HashMap fCachedLocations = new HashMap();

    protected AbstractInterpreterInstallType() {
    }

    public IInterpreterInstall[] getInterpreterInstalls() {
        return this.fInterpreters.toArray(new IInterpreterInstall[this.fInterpreters.size()]);
    }

    public void disposeInterpreterInstall(String id) {
        Iterator it = this.fInterpreters.iterator();
        while (it.hasNext()) {
            IInterpreterInstall install = (IInterpreterInstall)it.next();
            if (!install.getId().equals(id)) continue;
            it.remove();
            ScriptRuntime.fireInterpreterRemoved(install);
            return;
        }
    }

    public IInterpreterInstall findInterpreterInstall(String id) {
        Iterator it = this.fInterpreters.iterator();
        while (it.hasNext()) {
            IInterpreterInstall install = (IInterpreterInstall)it.next();
            if (!install.getId().equals(id)) continue;
            return install;
        }
        return null;
    }

    public IInterpreterInstall createInterpreterInstall(String id) throws IllegalArgumentException {
        if (this.findInterpreterInstall(id) != null) {
            String format = LaunchingMessages.InterpreterInstallType_duplicateInterpreter;
            throw new IllegalArgumentException(MessageFormat.format(format, id));
        }
        IInterpreterInstall install = this.doCreateInterpreterInstall(id);
        this.fInterpreters.add(install);
        return install;
    }

    protected abstract IInterpreterInstall doCreateInterpreterInstall(String var1);

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
        this.fId = config.getAttribute("id");
    }

    public String getId() {
        return this.fId;
    }

    public IInterpreterInstall findInterpreterInstallByName(String name) {
        Iterator it = this.fInterpreters.iterator();
        while (it.hasNext()) {
            IInterpreterInstall install = (IInterpreterInstall)it.next();
            if (!install.getName().equals(name)) continue;
            return install;
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static void storeFile(File dest, URL url) throws IOException {
        OutputStream output;
        block5: {
            BufferedInputStream input = null;
            output = null;
            try {
                input = new BufferedInputStream(url.openStream());
                output = new BufferedOutputStream(new FileOutputStream(dest));
                int ch = -1;
                while ((ch = ((InputStream)input).read()) != -1) {
                    output.write(ch);
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (input != null) {
                    ((InputStream)input).close();
                }
                if (output == null) throw throwable;
                output.close();
                throw throwable;
            }
            {
                Object var5_7 = null;
                if (input == null) break block5;
            }
            ((InputStream)input).close();
        }
        if (output == null) return;
        output.close();
    }

    protected String[] extractEnvironment() {
        Map systemEnv = DebugPlugin.getDefault().getLaunchManager().getNativeEnvironmentCasePreserved();
        this.filterEnvironment(systemEnv);
        ArrayList<String> list = new ArrayList<String>();
        Iterator it = systemEnv.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            list.add(entry.getKey() + "=" + entry.getValue());
        }
        return list.toArray(new String[list.size()]);
    }

    protected void filterEnvironment(Map environment) {
    }

    protected File storeToMetadata(Bundle bundle, String name, String path) throws IOException {
        File pathFile = DLTKCore.getDefault().getStateLocation().append(name).toFile();
        AbstractInterpreterInstallType.storeFile(pathFile, FileLocator.resolve((URL)bundle.getEntry(path)));
        return pathFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readPathsFromProcess(IProgressMonitor monitor, Process p) {
        final BufferedReader dataIn = new BufferedReader(new InputStreamReader(p.getInputStream()));
        final String[] result = new String[1];
        final Object lock = new Object();
        Thread tReading = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    result[0] = dataIn.readLine();
                    Object object = lock;
                    synchronized (object) {
                        lock.notifyAll();
                    }
                }
                catch (IOException iOException) {}
            }
        });
        tReading.start();
        Object object = lock;
        synchronized (object) {
            try {
                lock.wait(5000L);
            }
            catch (InterruptedException interruptedException) {}
            p.destroy();
        }
        return result[0];
    }

    protected LibraryLocation[] correctLocations(ArrayList locs) {
        ArrayList<LibraryLocation> resolvedLocs = new ArrayList<LibraryLocation>();
        Iterator iter = locs.iterator();
        while (iter.hasNext()) {
            String res;
            LibraryLocation l = (LibraryLocation)iter.next();
            try {
                File f = l.getLibraryPath().toFile();
                if (f == null) continue;
                res = f.getCanonicalPath();
            }
            catch (IOException iOException) {
                continue;
            }
            LibraryLocation n = new LibraryLocation((IPath)new Path(res));
            if (resolvedLocs.contains(n)) continue;
            resolvedLocs.add(n);
        }
        LibraryLocation[] libs = resolvedLocs.toArray(new LibraryLocation[resolvedLocs.size()]);
        return libs;
    }

    protected void fillLocationsExceptOne(List locs, String[] paths, IPath path) {
        String sPath = path.toOSString();
        int i = 0;
        while (i < paths.length) {
            File f;
            if (!paths[i].equals(sPath) && (f = new File(paths[i])).exists()) {
                LibraryLocation l = new LibraryLocation((IPath)new Path(paths[i]));
                locs.add(l);
            }
            ++i;
        }
    }

    protected void runLibraryLookup(IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        runnable.run((IProgressMonitor)new NullProgressMonitor());
    }

    protected abstract String getPluginId();

    protected abstract String[] getPossibleInterpreterNames();

    protected abstract ILog getLog();

    protected abstract File createPathFile() throws IOException;

    protected String[] buildCommandLine(File installLocation, File pathFile) {
        String path = installLocation.getAbsolutePath();
        return new String[]{path, pathFile.getAbsolutePath()};
    }

    protected String getBuildPathDelimeter() {
        return " ";
    }

    protected String[] parsePaths(String result) {
        String[] paths = result.split(this.getBuildPathDelimeter());
        ArrayList<String> filtered = new ArrayList<String>();
        int i = 0;
        while (i < paths.length) {
            if (!paths[i].equals(".")) {
                filtered.add(paths[i].trim());
            }
            ++i;
        }
        return filtered.toArray(new String[filtered.size()]);
    }

    public IStatus validateInstallLocation(File installLocation) {
        if (!installLocation.exists() || !installLocation.isFile() || installLocation.isHidden()) {
            return this.createStatus(4, InterpreterMessages.errNonExistentOrInvalidInstallLocation, null);
        }
        String name = installLocation.getName();
        if (Platform.getOS().equals("win32") && !name.matches(".*\\.exe")) {
            return this.createStatus(4, InterpreterMessages.errNoInterpreterExecutablesFound, null);
        }
        String[] possible = this.getPossibleInterpreterNames();
        int i = 0;
        while (i < possible.length) {
            if (name.indexOf(possible[i]) != -1) {
                return this.createStatus(0, "", null);
            }
            ++i;
        }
        return this.createStatus(4, InterpreterMessages.errNoInterpreterExecutablesFound, null);
    }

    protected IRunnableWithProgress createLookupRunnable(final File installLocation, final List locations) {
        return new IRunnableWithProgress(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) {
                Process process;
                block14: {
                    block13: {
                        process = null;
                        String[] cmdLine = null;
                        try {
                            try {
                                monitor.beginTask(InterpreterMessages.statusFetchingLibs, 1);
                                if (monitor.isCanceled()) {
                                    Object var9_4 = null;
                                    if (process != null) {
                                        process.destroy();
                                    }
                                    break block13;
                                }
                                String[] env = AbstractInterpreterInstallType.this.extractEnvironment();
                                File pathFile = AbstractInterpreterInstallType.this.createPathFile();
                                cmdLine = AbstractInterpreterInstallType.this.buildCommandLine(installLocation, pathFile);
                                try {
                                    process = DebugPlugin.exec((String[])cmdLine, null, (String[])env);
                                    if (process != null) {
                                        String result = AbstractInterpreterInstallType.this.readPathsFromProcess(monitor, process);
                                        if (result == null) {
                                            throw new IOException("null result from process");
                                        }
                                        String[] paths = AbstractInterpreterInstallType.this.parsePaths(result);
                                        IPath path = new Path(pathFile.getCanonicalPath()).removeLastSegments(1);
                                        AbstractInterpreterInstallType.this.fillLocationsExceptOne(locations, paths, path);
                                    }
                                    break block14;
                                }
                                catch (CoreException coreException) {}
                            }
                            catch (IOException iOException) {}
                            break block14;
                        }
                        catch (Throwable throwable) {
                            Object var9_5 = null;
                            if (process != null) {
                                process.destroy();
                            }
                            monitor.done();
                            throw throwable;
                        }
                    }
                    monitor.done();
                    return;
                }
                Object var9_6 = null;
                if (process != null) {
                    process.destroy();
                }
                monitor.done();
            }
        };
    }

    public synchronized LibraryLocation[] getDefaultLibraryLocations(File installLocation) {
        if (fCachedLocations.containsKey(installLocation)) {
            return (LibraryLocation[])fCachedLocations.get(installLocation);
        }
        ArrayList locations = new ArrayList();
        IRunnableWithProgress runnable = this.createLookupRunnable(installLocation, locations);
        try {
            this.runLibraryLookup(runnable);
        }
        catch (InvocationTargetException e) {
            this.getLog().log(this.createStatus(4, "Error to get default libraries:", e));
        }
        catch (InterruptedException e) {
            this.getLog().log(this.createStatus(4, "Error to get default libraries:", e));
        }
        LibraryLocation[] libs = this.correctLocations(locations);
        if (libs.length != 0) {
            fCachedLocations.put(installLocation, libs);
        }
        return libs;
    }

    protected IStatus createStatus(int severity, String message, Throwable throwable) {
        return new Status(severity, this.getPluginId(), 0, message, throwable);
    }
}

