/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.Argument;
import org.eclipse.dltk.ast.declarations.FieldDeclaration;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.tcl.ast.TclModuleDeclaration;
import org.eclipse.dltk.tcl.ast.TclNamespaceDeclaration;
import org.eclipse.dltk.tcl.ast.TclStatement;
import org.eclipse.dltk.tcl.ast.expressions.TclBlockExpression;
import org.eclipse.dltk.tcl.internal.parser.TclParseUtils;

public class TclASTBuilder {
    public static final int TYPE_MODULE = 0;
    public static final int TYPE_NAMESPACE = 1;
    public static final int TYPE_PROC = 2;
    public static final int TYPE_UNKNOWN = 3;

    public static void buildAST(TclModuleDeclaration declaration, List types, List functions, List variables) {
        TclASTBuilder.build((ASTNode)declaration, declaration.getStatements(), 0);
        List statements = declaration.getStatements();
        if (statements != null) {
            Iterator i = statements.iterator();
            while (i.hasNext()) {
                ASTNode node = (ASTNode)i.next();
                if (node instanceof MethodDeclaration) {
                    functions.add(node);
                    continue;
                }
                if (node instanceof TypeDeclaration) {
                    types.add(node);
                    continue;
                }
                if (!(node instanceof TclStatement)) continue;
                TclStatement tNode = (TclStatement)node;
                FieldDeclaration[] fields = TclParseUtils.returnVariableDeclarations(tNode);
                int k = 0;
                while (k < fields.length) {
                    boolean exist = false;
                    int t = 0;
                    while (t < variables.size()) {
                        FieldDeclaration f = (FieldDeclaration)variables.get(t);
                        if (f.getName().equals(fields[k].getName())) {
                            exist = true;
                            break;
                        }
                        ++t;
                    }
                    if (!exist) {
                        variables.add(fields[k]);
                    }
                    ++k;
                }
            }
        }
    }

    public static void build(ASTNode node, List ostatements, int type) {
        if (ostatements == null) {
            return;
        }
        ArrayList newStatements = new ArrayList(ostatements.size());
        newStatements.addAll(ostatements);
        Iterator i = newStatements.iterator();
        while (i.hasNext()) {
            TclStatement statement;
            Expression commandId;
            Statement sst = (Statement)i.next();
            if (!(sst instanceof TclStatement) || (commandId = (statement = (TclStatement)sst).getAt(0)) == null || !(commandId instanceof SimpleReference)) continue;
            String name = ((SimpleReference)commandId).getName();
            if (name.equals("proc")) {
                TclASTBuilder.processProc(node, statement);
                continue;
            }
            if (!name.equals("namespace")) continue;
            Expression nameSpaceArg = statement.getAt(1);
            if (nameSpaceArg == null || !(nameSpaceArg instanceof SimpleReference)) {
                System.err.println("tcl: namespace argument is null or not simple reference");
                continue;
            }
            Expression nameSpaceName = statement.getAt(2);
            if (nameSpaceName == null || !(nameSpaceName instanceof SimpleReference)) continue;
            String sNameSpaceArg = ((SimpleReference)nameSpaceArg).getName();
            String sNameSpaceName = ((SimpleReference)nameSpaceName).getName();
            Expression code = statement.getAt(3);
            if (code == null || !(code instanceof TclBlockExpression) || !sNameSpaceArg.equals("eval")) continue;
            TclNamespaceDeclaration nsType = new TclNamespaceDeclaration(sNameSpaceName, nameSpaceName.sourceStart(), nameSpaceName.sourceEnd(), statement.sourceStart(), statement.sourceEnd());
            if (node instanceof TypeDeclaration) {
                TypeDeclaration t = (TypeDeclaration)node;
                nsType.setEnclosingTypeName(String.valueOf(t.getEnclosingTypeName()) + "$" + t.getName());
            }
            TclASTBuilder.replaceChild(node, (ASTNode)statement, (ASTNode)nsType);
            List inner = null;
            inner = ((TclBlockExpression)code).parseBlock(code.sourceStart() + 1);
            Block block = new Block(code.sourceStart(), code.sourceEnd(), inner);
            nsType.setBody(block);
            TclASTBuilder.build((ASTNode)nsType, inner, 1);
        }
    }

    private static void replaceChild(ASTNode node, ASTNode statement, ASTNode nsType) {
        if (node instanceof ModuleDeclaration) {
            List statements = ((ModuleDeclaration)node).getStatements();
            int index = statements.indexOf(statement);
            statements.remove(index);
            statements.add(index, nsType);
        } else if (node instanceof TypeDeclaration) {
            List statements = ((TypeDeclaration)node).getStatements();
            int index = statements.indexOf(statement);
            statements.remove(index);
            statements.add(index, nsType);
        } else if (node instanceof Block) {
            List statements = ((Block)node).getStatements();
            int index = statements.indexOf(statement);
            statements.remove(index);
            statements.add(index, nsType);
        }
    }

    private static void processProc(ASTNode parent, TclStatement statement) {
        if (statement.getCount() < 4) {
            return;
        }
        Expression procName = statement.getAt(1);
        if (procName == null) {
            throw new RuntimeException("empty proc name");
        }
        if (!(procName instanceof SimpleReference)) {
            return;
        }
        Expression procArguments = statement.getAt(2);
        Expression procCode = statement.getAt(3);
        List<Argument> arguments = null;
        if (procArguments instanceof TclBlockExpression) {
            List st = null;
            st = ((TclBlockExpression)procArguments).parseBlock();
            arguments = TclParseUtils.parseArguments(st);
        }
        if (procArguments instanceof SimpleReference) {
            arguments = new ArrayList();
            Argument a = new Argument((SimpleReference)procArguments, procArguments.sourceStart(), null, 0);
            arguments.add(a);
        }
        SimpleReference refProcName = (SimpleReference)procName;
        MethodDeclaration method = new MethodDeclaration(refProcName.getName(), refProcName.sourceStart(), refProcName.sourceEnd(), statement.sourceStart(), statement.sourceEnd());
        if (parent instanceof TypeDeclaration) {
            TypeDeclaration t = (TypeDeclaration)parent;
            method.setDeclaringTypeName(String.valueOf(t.getEnclosingTypeName()) + "$" + t.getName());
        }
        method.acceptArguments(arguments);
        TclASTBuilder.replaceChild(parent, (ASTNode)statement, (ASTNode)method);
        if (procCode instanceof TclBlockExpression) {
            List code = null;
            code = ((TclBlockExpression)procCode).parseBlock(procCode.sourceStart() + 1);
            Iterator i = code.iterator();
            while (i.hasNext()) {
                Statement in = (Statement)i.next();
                in.setStart(in.sourceStart());
                in.setEnd(in.sourceEnd());
            }
            Block body = new Block(procCode.sourceStart(), procCode.sourceEnd(), code);
            method.acceptBody(body, false);
            TclASTBuilder.build((ASTNode)method, code, 2);
        }
    }

    public static void buildFullAST(TclModuleDeclaration decl) {
    }

    public static void rebuildMethods(TclModuleDeclaration unit) {
        MethodDeclaration[] methods;
        TypeDeclaration[] types = unit.getTypes();
        if (types != null) {
            int i = 0;
            while (i < types.length) {
                TypeDeclaration type = types[i];
                TclASTBuilder.rebuildMethodProcessBodies(type, unit);
                ++i;
            }
        }
        if ((methods = unit.getFunctions()) != null) {
            int i = 0;
            while (i < methods.length) {
                MethodDeclaration methodDeclaration;
                String name;
                MethodDeclaration method = methods[i];
                if (method instanceof MethodDeclaration && (name = (methodDeclaration = method).getName()).indexOf("::") != -1) {
                    if (name.startsWith("::")) {
                        name = name.substring(2);
                    }
                    if (name.endsWith("::")) {
                        name = name.substring(0, name.length() - 2);
                    }
                    name = name.replaceAll("(::)+", "::");
                    String[] split = name.split("::");
                    methodDeclaration.setName(split[split.length - 1]);
                    TypeDeclaration type = TclASTBuilder.searchCreateTypeDeclaration(unit, split, method, 0);
                    if (type != null) {
                        unit.getStatements().remove(methodDeclaration);
                        unit.getFunctionList().remove(methodDeclaration);
                        type.getStatements().add(methodDeclaration);
                        type.getMethodList().add(methodDeclaration);
                    }
                }
                ++i;
            }
        }
    }

    private static TypeDeclaration searchCreateTypeDeclaration(TclModuleDeclaration unit, String[] split, MethodDeclaration method, int offset) {
        if (split.length - 1 <= offset) {
            return null;
        }
        String typeName = split[0 + offset];
        TypeDeclaration[] types = unit.getTypes();
        int i = 0;
        while (i < types.length) {
            if (types[i].getName().equals(typeName)) {
                return TclASTBuilder.searchCreateTypeDeclaration(types[i], split, method, offset + 1);
            }
            ++i;
        }
        TypeDeclaration decl = new TypeDeclaration(typeName, method.getNameStart(), method.getNameEnd(), method.sourceStart(), method.sourceEnd());
        unit.addStatement((Statement)decl);
        unit.getTypeList().add(decl);
        return TclASTBuilder.searchCreateTypeDeclaration(decl, split, method, offset + 1);
    }

    private static TypeDeclaration searchCreateTypeDeclaration(TypeDeclaration typeDeclaration, String[] split, MethodDeclaration method, int offset) {
        if (offset == split.length - 1) {
            return typeDeclaration;
        }
        String typeName = split[0 + offset];
        TypeDeclaration[] types = typeDeclaration.getTypes();
        int i = 0;
        while (i < types.length) {
            if (types[i].getName().equals(typeName)) {
                return TclASTBuilder.searchCreateTypeDeclaration(types[i], split, method, offset + 1);
            }
            ++i;
        }
        TypeDeclaration decl = new TypeDeclaration(typeName, method.getNameStart(), method.getNameEnd(), method.sourceStart(), method.sourceEnd());
        typeDeclaration.getStatements().add(decl);
        typeDeclaration.getTypeList().add(decl);
        return TclASTBuilder.searchCreateTypeDeclaration(decl, split, method, offset + 1);
    }

    protected static void rebuildMethodProcessBodies(TypeDeclaration type, TclModuleDeclaration module) {
        TypeDeclaration[] memberTypes;
        MethodDeclaration[] methods = type.getMethods();
        if (methods != null) {
            int i = 0;
            while (i < methods.length) {
                MethodDeclaration methodDeclaration;
                String name;
                MethodDeclaration method = methods[i];
                if (method instanceof MethodDeclaration && (name = (methodDeclaration = method).getName()).indexOf("::") != -1) {
                    boolean start = false;
                    if (name.startsWith("::")) {
                        name = name.substring(2);
                        start = true;
                    }
                    if (name.endsWith("::")) {
                        name = name.substring(0, name.length() - 2);
                    }
                    name = name.replaceAll("(::)+", "::");
                    String[] split = name.split("::");
                    if (start && split.length > 2) {
                        module.getFunctionList().add(methodDeclaration);
                        type.getMethodList().remove(methodDeclaration);
                        type.getStatements().remove(methodDeclaration);
                    } else {
                        method.setName(split[split.length - 1]);
                        TypeDeclaration decl = TclASTBuilder.searchCreateTypeDeclaration(type, split, method, 0);
                        if (decl != null) {
                            type.getMethodList().remove(methodDeclaration);
                            type.getStatements().remove(methodDeclaration);
                            decl.getStatements().add(method);
                            decl.getMethodList().add(method);
                        }
                    }
                }
                ++i;
            }
        }
        if ((memberTypes = type.getTypes()) != null) {
            int i = 0;
            while (i < memberTypes.length) {
                TypeDeclaration memberType = memberTypes[i];
                TclASTBuilder.rebuildMethodProcessBodies(memberType, module);
                ++i;
            }
        }
    }
}

