/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.ast.declarations.Argument;
import org.eclipse.dltk.ast.declarations.ISourceParser;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.expressions.StringLiteral;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.compiler.ISourceElementRequestor;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.ISourceElementParser;
import org.eclipse.dltk.core.ISourceModuleInfoCache;
import org.eclipse.dltk.tcl.TclKeywordsManager;
import org.eclipse.dltk.tcl.ast.TclStatement;
import org.eclipse.dltk.tcl.ast.expressions.TclBlockExpression;
import org.eclipse.dltk.tcl.ast.expressions.TclExecuteExpression;
import org.eclipse.dltk.tcl.internal.parser.TclParseUtils;
import org.eclipse.dltk.tcl.internal.parsers.raw.SimpleTclParser;

public class TclSourceElementParser
implements ISourceElementParser {
    private static final int TYPE_MODULE = 0;
    private static final int TYPE_NAMESPACE = 1;
    private static final int TYPE_PROC = 2;
    private ISourceElementRequestor fRequestor;
    private Stack namespacesLevel = new Stack();
    private static String[] kw = TclKeywordsManager.getKeywords();
    private static Map kwMap = new HashMap();
    private static int counter;

    static {
        int q = 0;
        while (q < kw.length) {
            kwMap.put(kw[q], Boolean.TRUE);
            ++q;
        }
        counter = 0;
    }

    public ModuleDeclaration parseSourceModule(char[] contents, ISourceModuleInfoCache.ISourceModuleInfo astCashe, char[] filename) {
        ModuleDeclaration moduleDeclaration;
        block5: {
            ISourceParser sourceParser = null;
            try {
                sourceParser = DLTKLanguageManager.getSourceParser((String)"org.eclipse.dltk.tcl.core.nature");
            }
            catch (CoreException e1) {
                if (DLTKCore.DEBUG) {
                    e1.printStackTrace();
                }
                return null;
            }
            moduleDeclaration = sourceParser.parse(null, contents, null);
            moduleDeclaration.disableRebuild();
            List statements = moduleDeclaration.getStatements();
            try {
                this.fRequestor.enterModule();
                this.namespacesLevel.push("::");
                this.buildModel(statements, 0, "");
                this.fRequestor.exitModule(contents.length);
            }
            catch (Exception e) {
                if (!DLTKCore.DEBUG_PARSER) break block5;
                e.printStackTrace();
            }
        }
        return moduleDeclaration;
    }

    private void buildModel(List statements, int type, String namespaceName) {
        if (statements == null) {
            return;
        }
        HashSet variablesSet = new HashSet();
        Iterator i = statements.iterator();
        while (i.hasNext()) {
            TclStatement statement;
            Expression commandId;
            Statement sst = (Statement)i.next();
            if (!(sst instanceof TclStatement) || (commandId = (statement = (TclStatement)sst).getAt(0)) == null || !(commandId instanceof SimpleReference)) continue;
            String name = ((SimpleReference)commandId).getName();
            if (name.startsWith("::")) {
                name = name.substring(2);
            }
            if (name.equals("proc")) {
                this.processProc(statement, namespaceName);
            } else if (name.equals("set")) {
                this.processVariableSet(statement, variablesSet);
            } else if (name.equals("variable") && (type == 1 || type == 2)) {
                this.processVariable(statement, variablesSet, namespaceName);
            } else if (name.equals("upvar") && type == 2) {
                this.processUpvarVariable(statement, variablesSet);
            } else if (name.equals("global") && type == 2) {
                this.processGlobalVariable(statement, variablesSet);
            } else if (name.equals("package")) {
                this.processPackage(statement);
            } else if (name.equals("namespace")) {
                this.processNamespace(statement, namespaceName);
            } else if (name.equals("if")) {
                this.processIf(statement, namespaceName);
            } else if (name.equals("while")) {
                this.processWhile(statement, namespaceName);
            } else if (name.equals("for")) {
                this.processFor(statement, namespaceName);
            } else if (name.equals("catch")) {
                this.processCatch(statement, namespaceName);
            } else if (name.equals("after")) {
                this.processAfter(statement, namespaceName);
            }
            int j = 1;
            while (j < statement.getCount()) {
                if (statement.getAt(j) instanceof TclExecuteExpression) {
                    TclExecuteExpression expr = (TclExecuteExpression)statement.getAt(j);
                    this.processBlock(expr, namespaceName);
                }
                ++j;
            }
            this.processReferences(statement);
        }
    }

    private void processAfter(TclStatement statement, String namespaceName) {
        if (statement.getCount() >= 2) {
            int i = 2;
            while (i < statement.getCount()) {
                Expression e = statement.getAt(i);
                if (e instanceof TclExecuteExpression) {
                    this.processBlock((TclExecuteExpression)e, namespaceName);
                }
                ++i;
            }
        }
    }

    private void processCatch(TclStatement statement, String namespaceName) {
        Expression e;
        if (statement.getCount() >= 2 && (e = statement.getAt(1)) instanceof TclBlockExpression) {
            this.processBlock(e, namespaceName);
        }
    }

    private void processReferences(TclStatement statement) {
        Expression commandId = statement.getAt(0);
        if (commandId != null && commandId instanceof SimpleReference) {
            String name = ((SimpleReference)commandId).getName();
            if (name.startsWith("::")) {
                name = name.substring(2);
            }
            if (!kwMap.containsKey(name)) {
                int argCount = statement.getCount() - 1;
                if (name.length() > 0 && name.charAt(0) != '$') {
                    this.fRequestor.acceptMethodReference(name.toCharArray(), argCount, commandId.sourceStart(), commandId.sourceEnd());
                }
            }
        }
        int j = 1;
        while (j < statement.getCount()) {
            SimpleReference ref;
            String name;
            Expression st = statement.getAt(j);
            if (st instanceof TclExecuteExpression) {
                TclExecuteExpression expr = (TclExecuteExpression)st;
                List exprs = expr.parseExpression();
                int i = 0;
                while (i < exprs.size()) {
                    if (exprs.get(i) instanceof TclStatement) {
                        this.processReferences((TclStatement)((Object)exprs.get(i)));
                    }
                    ++i;
                }
            } else if (st instanceof StringLiteral) {
                int pos = 0;
                StringLiteral literal = (StringLiteral)st;
                String value = literal.getValue();
                pos = value.indexOf("$");
                while (pos != -1) {
                    SimpleReference ref2 = TclParseUtils.findVariableFromString(literal, pos);
                    if (ref2 != null) {
                        this.fRequestor.acceptFieldReference(ref2.getName().substring(1).toCharArray(), ref2.sourceStart());
                        pos += ref2.getName().length();
                    }
                    pos = value.indexOf("$", pos + 1);
                }
            } else if (st instanceof SimpleReference && (name = (ref = (SimpleReference)st).getName()).startsWith("$")) {
                this.fRequestor.acceptFieldReference(ref.getName().substring(1).toCharArray(), ref.sourceStart());
            }
            ++j;
        }
    }

    private void processFor(TclStatement statement, String namespaceName) {
        Expression bl;
        int bi;
        Expression bl2;
        List exprs = statement.getExpressions();
        int len = exprs.size();
        if (1 < len && (bl2 = (Expression)exprs.get(1)) instanceof TclBlockExpression) {
            this.processBlock(bl2, namespaceName);
        }
        if ((bi = 4) < len && (bl = (Expression)exprs.get(bi)) instanceof TclBlockExpression) {
            this.processBlock(bl, namespaceName);
        }
    }

    private void processWhile(TclStatement statement, String namespaceName) {
        Expression bl;
        int bi = 2;
        List exprs = statement.getExpressions();
        int len = exprs.size();
        if (bi < len && (bl = (Expression)exprs.get(bi)) instanceof TclBlockExpression) {
            this.processBlock(bl, namespaceName);
        }
    }

    private void processIf(TclStatement statement, String namespaceName) {
        List exprs = statement.getExpressions();
        TclParseUtils.processIf(exprs, namespaceName, 0, new TclParseUtils.IProcessStatementAction(){

            public void doAction(String name, Expression bl, int beforePosition) {
                TclSourceElementParser.this.processBlock(bl, name);
            }
        });
    }

    private void processBlock(Expression bl, String namespaceName) {
        TclBlockExpression block = (TclBlockExpression)bl;
        List code = null;
        code = block.parseBlock(block.sourceStart() + 1);
        this.buildModel(code, 2, namespaceName);
    }

    private void processBlock(TclExecuteExpression bl, String namespaceName) {
        List code = null;
        code = bl.parseExpression(bl.sourceStart() + 1);
        this.buildModel(code, 2, namespaceName);
    }

    private void processNamespace(TclStatement statement, String parentNamespaceName) {
        Expression nameSpaceName;
        Expression nameSpaceArg = statement.getAt(1);
        if ((nameSpaceArg == null || !(nameSpaceArg instanceof SimpleReference)) && DLTKCore.DEBUG) {
            System.err.println("tcl: namespace argument is null or not simple reference");
        }
        if ((nameSpaceName = statement.getAt(2)) == null || !(nameSpaceName instanceof SimpleReference)) {
            return;
        }
        Expression code = statement.getAt(3);
        if (code == null || !(code instanceof TclBlockExpression)) {
            return;
        }
        String sNameSpaceArg = ((SimpleReference)nameSpaceArg).getName();
        String sNameSpaceName = ((SimpleReference)nameSpaceName).getName();
        if (sNameSpaceArg.equals("eval")) {
            ISourceElementRequestor.TypeInfo info = new ISourceElementRequestor.TypeInfo();
            info.modifiers = 2048;
            String fullName = sNameSpaceName;
            String[] split = sNameSpaceName.split("::");
            info.name = split.length != 0 ? split[split.length - 1] : "";
            SimpleReference nsName = (SimpleReference)nameSpaceName;
            info.nameSourceStart = nsName.sourceStart();
            info.nameSourceEnd = nsName.sourceEnd() - 1;
            info.declarationStart = statement.getAt(0).sourceStart();
            ExitFromType exit = this.resolveType(nameSpaceName, String.valueOf(fullName) + "::dummy", true);
            List inner = null;
            inner = ((TclBlockExpression)code).parseBlock(code.sourceStart() + 1);
            if (sNameSpaceName.startsWith("::") && parentNamespaceName.length() == 0) {
                this.buildModel(inner, 1, sNameSpaceName);
            } else {
                this.buildModel(inner, 1, String.valueOf(parentNamespaceName) + "::" + sNameSpaceName);
            }
            exit.go();
        }
    }

    private void processPackage(TclStatement statement) {
        if (statement.getCount() < 3) {
            if (DLTKCore.DEBUG) {
                System.err.println("tcl: package argument could incorrect...");
            }
            return;
        }
        Expression nameSpaceArg = statement.getAt(1);
        if (nameSpaceArg == null || !(nameSpaceArg instanceof SimpleReference)) {
            if (DLTKCore.DEBUG) {
                System.err.println("tcl: package argument is null or not simple reference");
            }
            return;
        }
        String arg = ((SimpleReference)nameSpaceArg).getName();
        if (arg.equals("provide") || arg.equals("ifneeded")) {
            Expression pkg = statement.getAt(2);
            Expression pkgVer = null;
            if (statement.getCount() > 3) {
                pkgVer = statement.getAt(3);
            }
            if (pkg != null && pkg instanceof SimpleReference) {
                String _pkg = ((SimpleReference)pkg).getName();
                String _pkgVer = null;
                if (pkgVer != null && pkgVer instanceof SimpleReference) {
                    _pkgVer = ((SimpleReference)pkgVer).getName();
                    this.fRequestor.acceptPackage(pkg.sourceStart(), pkg.sourceEnd(), (String.valueOf(_pkg) + " (" + _pkgVer + ")").toCharArray());
                } else {
                    this.fRequestor.acceptPackage(pkg.sourceStart(), pkg.sourceEnd(), (String.valueOf(_pkg) + " (version n/a)").toCharArray());
                }
            }
        }
    }

    private void processVariableSet(TclStatement statement, HashSet vars) {
        if (statement.getCount() < 2) {
            return;
        }
        Expression variableName = statement.getAt(1);
        if (variableName == null) {
            throw new RuntimeException("empty variable name");
        }
        this.makeVariable(variableName, vars, 0, "");
    }

    private void makeVariable(Expression variableName, HashSet vars, int flags, String namespaceName) {
        String name = null;
        int start = 0;
        int end = 0;
        if (variableName instanceof SimpleReference) {
            name = ((SimpleReference)variableName).getName();
        } else if (variableName instanceof TclBlockExpression) {
            name = ((TclBlockExpression)variableName).getBlock();
            name = this.nameFromBlock(name, '{', '}');
        } else if (variableName instanceof StringLiteral) {
            name = ((StringLiteral)variableName).getValue();
            name = this.nameFromBlock(name, '\"', '\"');
        } else if (variableName instanceof TclExecuteExpression) {
            name = ((TclExecuteExpression)variableName).getExpression();
            if (vars.contains(name)) {
                return;
            }
        } else {
            return;
        }
        if (name != null) {
            String fullName;
            if (!name.startsWith("::") && flags == 10008 && this.namespacesLevel.size() > 0) {
                name = this.namespacesLevel.peek() + "::" + name;
            }
            String arrayName = null;
            String arrayIndex = null;
            if (this.isArrayVariable(name)) {
                int t1 = name.indexOf("(");
                if (t1 > 0 && name.charAt(t1 - 1) == '\\') {
                    --t1;
                }
                arrayName = name.substring(0, t1);
                arrayIndex = name.substring(name.indexOf("(") + 1, name.length() - 1);
                if (arrayIndex.endsWith("\\")) {
                    arrayIndex = arrayIndex.substring(0, arrayIndex.length() - 1);
                }
            }
            if (arrayName != null) {
                name = arrayName;
            }
            if ((fullName = this.escapeName(name)).indexOf("::") != -1) {
                String[] split = name.split("::");
                name = split[split.length - 1];
            }
            start = variableName.sourceStart();
            end = variableName.sourceEnd();
            ISourceElementRequestor.FieldInfo fi = new ISourceElementRequestor.FieldInfo();
            fi.name = name;
            fi.nameSourceStart = start;
            fi.nameSourceEnd = end - 1;
            fi.declarationStart = start;
            fi.modifiers = flags;
            boolean needExit = false;
            ExitFromType exit = this.resolveType(variableName, fullName, false);
            needExit = this.fRequestor.enterFieldCheckDuplicates(fi);
            if (needExit) {
                if (arrayName != null) {
                    ISourceElementRequestor.FieldInfo fiIndex = new ISourceElementRequestor.FieldInfo();
                    fiIndex.name = String.valueOf(arrayName) + "(" + arrayIndex + ")";
                    fiIndex.nameSourceStart = start;
                    fiIndex.nameSourceEnd = end - 1;
                    fiIndex.declarationStart = start;
                    fiIndex.modifiers = 10009;
                    if (this.fRequestor.enterFieldCheckDuplicates(fiIndex)) {
                        this.fRequestor.exitField(end);
                    }
                }
                this.fRequestor.exitField(end);
            }
            exit.go();
        }
    }

    private boolean isArrayVariable(String name) {
        if (name.length() <= 2) {
            return false;
        }
        if (!name.endsWith(")")) {
            return false;
        }
        return name.indexOf("(") != -1;
    }

    private String escapeName(String name) {
        name = SimpleTclParser.magicSubstitute(name);
        StringBuffer res = new StringBuffer();
        int len = name.length();
        int i = 0;
        while (i < len) {
            if (Character.isISOControl(name.charAt(i))) {
                res.append("\\u");
                String tmp = Integer.toHexString(name.charAt(i)).toUpperCase();
                if (tmp.length() == 1) {
                    res.append("0");
                }
                res.append(tmp);
            } else {
                res.append(name.charAt(i));
            }
            ++i;
        }
        String ans = res.toString();
        if (ans.trim().length() == 0) {
            return "{" + name + "}";
        }
        return ans;
    }

    private String nameFromBlock(String name, char c1, char c2) {
        int pos = name.indexOf(c1);
        String nname = name.substring(pos + 1);
        pos = nname.lastIndexOf(c2);
        nname = nname.substring(0, pos);
        return nname;
    }

    private void processUpvarVariable(TclStatement statement, HashSet vars) {
        int statementsCount = statement.getCount();
        if (statementsCount < 2) {
            return;
        }
        Expression level = statement.getAt(1);
        int startIndex = 1;
        if (level instanceof SimpleReference) {
            SimpleReference sLevel = (SimpleReference)level;
            String str = sLevel.getName();
            if (str == null || str.length() == 0) {
                throw new RuntimeException("empty upvar level name");
            }
            if (str.startsWith("#") || str.startsWith("\\#") || Character.isDigit(str.charAt(0))) {
                ++startIndex;
            }
        }
        int i = startIndex;
        while (i < statementsCount) {
            Expression variableName = statement.getAt(i + 1);
            if (variableName == null) {
                if (DLTKCore.DEBUG) {
                    System.out.println("Incorrect upvar variable declaration");
                }
                return;
            }
            this.makeVariable(variableName, vars, 10006, "");
            i += 2;
        }
    }

    private void processGlobalVariable(TclStatement statement, HashSet vars) {
        int statementsCount = statement.getCount();
        if (statementsCount < 2) {
            return;
        }
        int i = 1;
        while (i < statementsCount) {
            Expression variableName = statement.getAt(i);
            if (variableName == null) {
                throw new RuntimeException("empty variable name");
            }
            this.makeVariable(variableName, vars, 10007, "");
            ++i;
        }
    }

    private void processVariable(TclStatement statement, HashSet vars, String namespaceName) {
        if (statement.getCount() < 2) {
            return;
        }
        int j = 1;
        while (j < statement.getCount()) {
            Expression variableName = statement.getAt(j);
            if (variableName == null) {
                throw new RuntimeException("empty variable name");
            }
            this.makeVariable(variableName, vars, 10008, namespaceName);
            j += 2;
        }
    }

    private void processProc(TclStatement statement, String namespaceName) {
        if (statement.getCount() < 4) {
            return;
        }
        Expression procName = statement.getAt(1);
        if (procName == null) {
            throw new RuntimeException("empty proc name");
        }
        String sName = null;
        if (procName instanceof SimpleReference) {
            sName = ((SimpleReference)procName).getName();
        } else if (procName instanceof TclBlockExpression) {
            sName = ((TclBlockExpression)procName).getBlock();
        } else if (procName instanceof TclExecuteExpression) {
            sName = ((TclExecuteExpression)procName).getExpression();
        } else {
            return;
        }
        Expression procArguments = statement.getAt(2);
        Expression procCode = statement.getAt(3);
        List<Argument> arguments = null;
        if (procArguments instanceof TclBlockExpression) {
            List st = null;
            st = ((TclBlockExpression)procArguments).parseBlock();
            arguments = TclParseUtils.parseArguments(st);
        }
        if (procArguments instanceof SimpleReference) {
            arguments = new ArrayList();
            Argument a = new Argument((SimpleReference)procArguments, procArguments.sourceStart(), null, 0);
            arguments.add(a);
        }
        String[] parameter = null;
        String[] parameterInitializers = null;
        if (arguments != null) {
            parameter = new String[arguments.size()];
            parameterInitializers = new String[arguments.size()];
            int a = 0;
            while (a < arguments.size()) {
                Object node = arguments.get(a);
                parameterInitializers[a] = null;
                if (node instanceof Argument) {
                    Argument ref = (Argument)node;
                    parameter[a] = ref.getName();
                    Statement e = (Statement)ref.getInitialization();
                    if (e != null) {
                        String name;
                        if (e instanceof SimpleReference) {
                            parameterInitializers[a] = ((SimpleReference)e).getName();
                        } else if (e instanceof TclBlockExpression) {
                            name = ((TclBlockExpression)e).getBlock();
                            parameterInitializers[a] = this.nameFromBlock(name, '{', '}');
                        } else if (e instanceof StringLiteral) {
                            name = ((StringLiteral)e).getValue();
                            parameterInitializers[a] = this.nameFromBlock(name, '\"', '\"');
                        } else if (e instanceof TclExecuteExpression) {
                            parameterInitializers[a] = name = ((TclBlockExpression)e).getBlock();
                        }
                    }
                } else if (node instanceof String) {
                    parameter[a] = (String)node;
                }
                ++a;
            }
        }
        ISourceElementRequestor.MethodInfo mi = new ISourceElementRequestor.MethodInfo();
        String fullName = sName = this.escapeName(sName);
        if (fullName.indexOf("::") != -1) {
            String[] split = fullName.split("::");
            sName = split[split.length - 1];
        }
        mi.parameterNames = parameter;
        mi.parameterInitializers = parameterInitializers;
        mi.name = sName;
        mi.modifiers = 0;
        mi.nameSourceStart = procName.sourceStart();
        mi.nameSourceEnd = procName.sourceEnd() - 1;
        mi.declarationStart = statement.sourceStart();
        ExitFromType exit = this.resolveType(procName, fullName, false);
        this.fRequestor.enterMethodRemoveSame(mi);
        if (procCode instanceof TclBlockExpression) {
            List code = null;
            code = ((TclBlockExpression)procCode).parseBlock(procCode.sourceStart() + 1);
            Iterator i = code.iterator();
            while (i.hasNext()) {
                Statement in = (Statement)i.next();
                in.setStart(in.sourceStart());
                in.setEnd(in.sourceEnd());
            }
            this.buildModel(code, 2, namespaceName);
        }
        this.fRequestor.exitMethod(statement.sourceEnd());
        exit.go();
    }

    private String removeLastSegment(String s, String delimeter) {
        if (s.indexOf("::") == -1) {
            return "";
        }
        int pos = s.length() - 1;
        while (s.charAt(pos) != ':') {
            --pos;
        }
        if (pos > 1) {
            return s.substring(0, pos - 1);
        }
        return "::";
    }

    private ExitFromType resolveType(Expression expr, String name, boolean onlyCurrent) {
        String type = this.removeLastSegment(name, "::");
        while (type.length() > 2 && type.endsWith("::")) {
            type = type.substring(0, type.length() - 2);
        }
        if (type.length() == 0) {
            return new ExitFromType(0, 0, false, false);
        }
        if (type.equals("::")) {
            this.fRequestor.enterModuleRoot();
            this.namespacesLevel.push("::");
            return new ExitFromType(0, expr.sourceEnd(), true, true);
        }
        boolean fqn = type.startsWith("::");
        String fullyQualified = type;
        if (!fqn) {
            String e = this.getEnclosingNamespace();
            if (e == null) {
                throw new AssertionError((Object)"there are no enclosing namespace!");
            }
            if (!e.endsWith("::")) {
                e = String.valueOf(e) + "::";
            }
            fullyQualified = String.valueOf(e) + type;
        }
        if (this.fRequestor.enterTypeAppend(type, "::")) {
            this.namespacesLevel.push(fullyQualified);
            return new ExitFromType(1, expr.sourceEnd(), false, true);
        }
        if (!fqn && !onlyCurrent && this.fRequestor.enterTypeAppend("::" + type, "::")) {
            this.namespacesLevel.push("::" + type);
            return new ExitFromType(1, expr.sourceEnd(), false, true);
        }
        int needEnterLeave = 0;
        String[] split = null;
        String e = this.getEnclosingNamespace();
        if (e == null) {
            throw new AssertionError((Object)"there are no enclosing namespace!");
        }
        boolean entered = false;
        boolean exitFromModule = false;
        if (e.length() > 0 && !fqn) {
            entered = this.fRequestor.enterTypeAppend(e, "::");
        }
        if (fqn || !entered) {
            split = fullyQualified.substring(2).split("::");
            this.fRequestor.enterModuleRoot();
            exitFromModule = true;
        } else {
            if (!entered) {
                throw new AssertionError((Object)"can't enter to enclosing namespace!");
            }
            ++needEnterLeave;
            split = type.split("::");
        }
        int i = 0;
        while (i < split.length) {
            if (split[i].length() > 0) {
                ++needEnterLeave;
                if (!this.fRequestor.enterTypeAppend(split[i], "::")) {
                    ISourceElementRequestor.TypeInfo ti = new ISourceElementRequestor.TypeInfo();
                    ti.modifiers = 2048;
                    ti.name = split[i];
                    ti.nameSourceStart = expr.sourceStart();
                    ti.nameSourceEnd = expr.sourceEnd() - 1;
                    ti.declarationStart = expr.sourceStart();
                    this.fRequestor.enterType(ti);
                }
            }
            ++i;
        }
        this.namespacesLevel.push(fullyQualified);
        return new ExitFromType(needEnterLeave, expr.sourceEnd(), exitFromModule, true);
    }

    private String getEnclosingNamespace() {
        String s = (String)this.namespacesLevel.peek();
        return s;
    }

    public void setRequestor(ISourceElementRequestor requestor) {
        this.fRequestor = requestor;
    }

    public void setReporter(IProblemReporter reporter) {
    }

    private class ExitFromType {
        private int level;
        private int end;
        private boolean exitFromModule;
        private boolean pop;

        public ExitFromType(int level, int declEnd, boolean mod, boolean pop) {
            this.level = level;
            this.end = declEnd;
            this.exitFromModule = mod;
            this.pop = pop;
        }

        public void go() {
            int i = 0;
            while (i < this.level) {
                TclSourceElementParser.this.fRequestor.exitType(this.end);
                ++i;
            }
            if (this.exitFromModule) {
                TclSourceElementParser.this.fRequestor.exitModuleRoot();
            }
            if (this.pop) {
                TclSourceElementParser.this.namespacesLevel.pop();
            }
        }
    }
}

