/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.console.ui;

import java.io.IOException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.dltk.console.IScriptInterpreter;
import org.eclipse.dltk.console.ScriptConsoleHistory;
import org.eclipse.dltk.console.ScriptConsolePrompt;
import org.eclipse.dltk.console.ui.IConsoleStyleProvider;
import org.eclipse.dltk.console.ui.IScriptConsoleInput;
import org.eclipse.dltk.console.ui.IScriptConsoleListener;
import org.eclipse.dltk.console.ui.IScriptConsoleSession;
import org.eclipse.dltk.console.ui.ScriptConsolePartitioner;
import org.eclipse.dltk.console.ui.ScriptConsoleSourceViewerConfiguration;
import org.eclipse.dltk.console.ui.internal.ICommandHandler;
import org.eclipse.dltk.console.ui.internal.ScriptConsoleInput;
import org.eclipse.dltk.console.ui.internal.ScriptConsolePage;
import org.eclipse.dltk.console.ui.internal.ScriptConsoleSession;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.ui.console.IConsoleDocumentPartitioner;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.part.IPageBookViewPage;

public class ScriptConsole
extends TextConsole
implements ICommandHandler {
    private ScriptConsolePage page;
    private ScriptConsolePartitioner partitioner;
    private IContentAssistProcessor processor;
    private ITextHover hover;
    private IScriptInterpreter interpreter;
    private ScriptConsoleSession session;
    private ListenerList consoleListeners = new ListenerList(1);
    private ScriptConsolePrompt prompt = new ScriptConsolePrompt("=>", "->");
    private ScriptConsoleHistory history = new ScriptConsoleHistory();
    private IConsoleStyleProvider styleProvider;

    protected IConsoleDocumentPartitioner getPartitioner() {
        return this.partitioner;
    }

    public ScriptConsole(String consoleName, String consoleType) {
        super(consoleName, consoleType, null, true);
        this.session = new ScriptConsoleSession();
        this.addListener(this.session);
        this.partitioner = new ScriptConsolePartitioner();
        this.getDocument().setDocumentPartitioner((IDocumentPartitioner)this.partitioner);
        this.partitioner.connect(this.getDocument());
    }

    public IScriptConsoleSession getSession() {
        return this.session;
    }

    public void addListener(IScriptConsoleListener listener) {
        this.consoleListeners.add((Object)listener);
    }

    public void removeListener(IScriptConsoleListener listener) {
        this.consoleListeners.remove((Object)listener);
    }

    protected void setContentAssistProcessor(IContentAssistProcessor processor) {
        this.processor = processor;
    }

    protected void setInterpreter(IScriptInterpreter interpreter) {
        this.interpreter = interpreter;
    }

    protected void setStyleProvider(IConsoleStyleProvider provider) {
        this.styleProvider = provider;
    }

    public void setPrompt(ScriptConsolePrompt prompt) {
        this.prompt = prompt;
    }

    public ScriptConsolePrompt getPrompt() {
        return this.prompt;
    }

    public ScriptConsoleHistory getHistory() {
        return this.history;
    }

    protected void setTextHover(ITextHover hover) {
        this.hover = hover;
    }

    public IPageBookViewPage createPage(IConsoleView view) {
        ScriptConsoleSourceViewerConfiguration cfg = new ScriptConsoleSourceViewerConfiguration(this.processor, this.hover);
        this.page = new ScriptConsolePage(this, view, cfg);
        if (this.styleProvider != null) {
            this.page.setStyleProviser(this.styleProvider);
        }
        return this.page;
    }

    public void clearConsole() {
        this.page.clearConsolePage();
    }

    public IScriptConsoleInput getInput() {
        return new ScriptConsoleInput(this.page);
    }

    public String handleCommand(String userInput) throws IOException {
        Object[] listeners = this.consoleListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IScriptConsoleListener)listeners[i]).userRequest(userInput);
            ++i;
        }
        this.interpreter.exec(userInput);
        String output = this.interpreter.getOutput();
        if (this.interpreter.getState() == 0) {
            this.prompt.setMode(true);
        } else {
            this.prompt.setMode(false);
        }
        int i2 = 0;
        while (i2 < listeners.length) {
            ((IScriptConsoleListener)listeners[i2]).interpreterResponse(output);
            ++i2;
        }
        return output;
    }

    public void terminate() {
        try {
            this.interpreter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

