/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.launching;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.dltk.launching.AbstractScriptLaunchConfigurationDelegate;
import org.eclipse.dltk.launching.InterpreterConfig;
import org.eclipse.dltk.ruby.launching.RubyLaunchingPlugin;
import org.eclipse.dltk.utils.DeployHelper;

public class RubyLaunchConfigurationDelegate
extends AbstractScriptLaunchConfigurationDelegate {
    public String getLanguageId() {
        return "org.eclipse.dltk.ruby.core.nature";
    }

    protected String getCharset(ILaunchConfiguration configuration) throws CoreException {
        IProject project = RubyLaunchConfigurationDelegate.getScriptProject((ILaunchConfiguration)configuration).getProject();
        IResource resource = project.findMember(this.getMainScriptName(configuration));
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            return file.getCharset();
        }
        return null;
    }

    protected String getCharsetInterpreterFlag(String charset) {
        if (charset.equals("UTF-8")) {
            return "-KU";
        }
        if (charset.equals("EUC")) {
            return "-KE";
        }
        if (charset.equals("SJIS")) {
            return "-KS";
        }
        return "-KA";
    }

    protected void addEncodingInterpreterArg(InterpreterConfig config, ILaunchConfiguration configuration) throws CoreException {
        String charset;
        if (!config.hasMatchedInterpreterArg("-K.*") && (charset = this.getCharset(configuration)) != null) {
            config.addInterpreterArg(this.getCharsetInterpreterFlag(charset));
        }
    }

    protected void addIncludePathInterpreterArg(InterpreterConfig config, ILaunchConfiguration configuration) throws CoreException {
        IPath[] paths = this.createBuildPath(configuration);
        char separator = Platform.getOS().equals("win32") ? (char)';' : ':';
        StringBuffer sb = new StringBuffer("-I");
        int i = 0;
        while (i < paths.length) {
            sb.append(paths[i].toOSString());
            if (i < paths.length - 1) {
                sb.append(separator);
            }
            ++i;
        }
        config.addInterpreterArg(sb.toString());
    }

    protected void addStreamSync(InterpreterConfig config, ILaunchConfiguration configuration) {
        try {
            IPath path = DeployHelper.deploy((Plugin)RubyLaunchingPlugin.getDefault(), (String)"scripts");
            config.addInterpreterArg("-r");
            config.addInterpreterArg(path.append("sync.rb").toPortableString());
        }
        catch (IOException iOException) {}
    }

    protected InterpreterConfig createInterpreterConfig(ILaunchConfiguration configuration, ILaunch launch) throws CoreException {
        InterpreterConfig config = super.createInterpreterConfig(configuration, launch);
        this.addEncodingInterpreterArg(config, configuration);
        this.addIncludePathInterpreterArg(config, configuration);
        this.addStreamSync(config, configuration);
        return config;
    }
}

