/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.ui.formatting;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.dltk.ruby.internal.ui.formatting.AbstractBlockMarker;
import org.eclipse.dltk.ruby.internal.ui.formatting.BeginBlockMarker;
import org.eclipse.dltk.ruby.internal.ui.formatting.CodeFormatter;
import org.eclipse.dltk.ruby.internal.ui.formatting.DefaultCodeFormatterConstants;
import org.eclipse.dltk.ruby.internal.ui.formatting.DefaultCodeFormatterOptions;
import org.eclipse.dltk.ruby.internal.ui.formatting.EndBlockMarker;
import org.eclipse.dltk.ruby.internal.ui.formatting.FixLengthMarker;
import org.eclipse.dltk.ruby.internal.ui.formatting.IndentationState;
import org.eclipse.dltk.ruby.internal.ui.formatting.Indents;
import org.eclipse.dltk.ruby.internal.ui.formatting.MidBlockMarker;
import org.eclipse.dltk.ruby.internal.ui.formatting.NeutralMarker;
import org.eclipse.dltk.ruby.internal.ui.formatting.NoFormattingMarker;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class OldCodeFormatter
extends CodeFormatter {
    private static final String BLOCK_BEGIN_RE = "(class|module|def|if|unless|case|while|until|for|begin|do)";
    private static final String BLOCK_MID_RE = "(else|elsif|when|rescue|ensure)";
    private static final String BLOCK_END_RE = "(end)";
    private static final String DELIMITER_RE = "[?$/(){}#\\`.:\\]\\[]";
    private static final String[] LITERAL_BEGIN_LITERALS = new String[]{"\"", "'", "=begin", "%[Qqrxw]?.", "/", "<<[\\-]?[']?[a-zA-Z_]+[']?"};
    private static final String[] LITERAL_END_RES = new String[]{"[^\\\\](\\\\\\\\)*\"", "[^\\\\](\\\\\\\\)*'", "=end", "", "", ""};
    private final int BLOCK_BEGIN_PAREN = 2;
    private final int BLOCK_MID_PAREN = 5;
    private final int BLOCK_END_PAREN = 8;
    private final int LITERAL_BEGIN_PAREN = 10;
    private static Pattern MODIFIER_RE;
    private static Pattern OPERATOR_RE;
    private static Pattern NON_BLOCK_DO_RE;
    private static String LITERAL_BEGIN_RE;
    private static Pattern[] LITERAL_END_RES_COMPILED;
    private DefaultCodeFormatterOptions preferences;
    private Map options;

    static {
        LITERAL_END_RES_COMPILED = new Pattern[LITERAL_END_RES.length];
        int i = 0;
        while (i < LITERAL_END_RES.length) {
            try {
                OldCodeFormatter.LITERAL_END_RES_COMPILED[i] = Pattern.compile(LITERAL_END_RES[i]);
            }
            catch (PatternSyntaxException e) {
                System.out.println(e);
            }
            ++i;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        int i2 = 0;
        while (i2 < LITERAL_BEGIN_LITERALS.length) {
            sb.append(LITERAL_BEGIN_LITERALS[i2]);
            if (i2 < LITERAL_BEGIN_LITERALS.length - 1) {
                sb.append("|");
            }
            ++i2;
        }
        sb.append(")");
        LITERAL_BEGIN_RE = sb.toString();
        try {
            MODIFIER_RE = Pattern.compile("if|unless|while|until|rescue");
            OPERATOR_RE = Pattern.compile("[\\-,.+*/%&|\\^~=<>:]");
            NON_BLOCK_DO_RE = Pattern.compile("(^|[\\s])(while|until|for|rescue)[\\s]");
        }
        catch (PatternSyntaxException e) {
            System.out.println(e);
        }
    }

    public OldCodeFormatter() {
        this(new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getRubyConventionsSettings()), null);
    }

    public OldCodeFormatter(DefaultCodeFormatterOptions preferences) {
        this(preferences, null);
    }

    public OldCodeFormatter(DefaultCodeFormatterOptions defaultCodeFormatterOptions, Map options) {
        if (options == null) {
            throw new IllegalArgumentException();
        }
        if (options != null) {
            this.options = options;
            this.preferences = new DefaultCodeFormatterOptions(options);
        }
        if (defaultCodeFormatterOptions != null) {
            this.preferences.set(defaultCodeFormatterOptions.getMap());
        }
    }

    public OldCodeFormatter(Map options) {
        this(null, options);
    }

    public synchronized String formatString(String unformatted) {
        AbstractBlockMarker firstAbstractBlockMarker = this.createBlockMarkerList(unformatted);
        if (this.isDebug()) {
            firstAbstractBlockMarker.print();
        }
        int initialIndentLevel = Indents.measureIndentUnits(unformatted, this.preferences.tab_size, this.preferences.indentation_size);
        try {
            return this.formatString(unformatted, firstAbstractBlockMarker, initialIndentLevel);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return unformatted;
        }
    }

    private boolean isDebug() {
        return true;
    }

    protected String formatString(String unformatted, AbstractBlockMarker abstractBlockMarker, int initialIndentLevel) throws PatternSyntaxException {
        Pattern pat = Pattern.compile("\n");
        String[] lines = pat.split(unformatted);
        IndentationState state = null;
        StringBuffer formatted = new StringBuffer();
        Pattern whitespacePattern = Pattern.compile("^[\t ]*");
        int i = 0;
        while (i < lines.length) {
            Matcher whitespaceMatcher = whitespacePattern.matcher(lines[i]);
            whitespaceMatcher.find();
            int leadingWhitespace = whitespaceMatcher.end(0);
            if (state == null) {
                state = new IndentationState(unformatted, leadingWhitespace, initialIndentLevel);
            }
            state.incPos(leadingWhitespace);
            String strippedLine = lines[i].substring(leadingWhitespace);
            AbstractBlockMarker newBlockMarker = this.findNextBlockMarker(abstractBlockMarker, state.getPos(), state);
            if (newBlockMarker != null) {
                newBlockMarker.indentBeforePrint(state);
                newBlockMarker.appendIndentedLine(formatted, state, lines[i], strippedLine, this.options);
                newBlockMarker.indentAfterPrint(state);
                abstractBlockMarker = newBlockMarker;
            } else {
                abstractBlockMarker.appendIndentedLine(formatted, state, lines[i], strippedLine, this.options);
            }
            if (i != lines.length - 1) {
                formatted.append("\n");
            }
            state.incPos(strippedLine.length() + 1);
            ++i;
        }
        if (unformatted.lastIndexOf("\n") == unformatted.length() - 1) {
            formatted.append("\n");
        }
        return formatted.toString();
    }

    private AbstractBlockMarker findNextBlockMarker(AbstractBlockMarker abstractBlockMarker, int pos, IndentationState state) {
        AbstractBlockMarker startBlockMarker = abstractBlockMarker;
        while (abstractBlockMarker.getNext() != null && abstractBlockMarker.getNext().getPos() <= pos) {
            if (abstractBlockMarker != startBlockMarker) {
                abstractBlockMarker.indentBeforePrint(state);
                abstractBlockMarker.indentAfterPrint(state);
            }
            abstractBlockMarker = abstractBlockMarker.getNext();
        }
        return startBlockMarker == abstractBlockMarker ? null : abstractBlockMarker;
    }

    protected AbstractBlockMarker createBlockMarkerList(String unformatted) {
        Pattern pat = null;
        try {
            String expr = "(^|[\\s]|;)(class|module|def|if|unless|case|while|until|for|begin|do)($|[\\s]|[?$/(){}#\\`.:\\]\\[])|(^|[\\s])(else|elsif|when|rescue|ensure)($|[\\s]|[?$/(){}#\\`.:\\]\\[])|(^|[\\s]|;)(end)($|[\\s]|;)|" + LITERAL_BEGIN_RE + "|" + DELIMITER_RE;
            System.out.println("Expression: " + expr);
            pat = Pattern.compile(expr);
        }
        catch (PatternSyntaxException e) {
            System.out.println(e);
        }
        int pos = 0;
        AbstractBlockMarker lastBlockMarker = new NeutralMarker("start", 0);
        NeutralMarker firstBlockMarker = lastBlockMarker;
        Matcher re = pat.matcher(unformatted);
        while (pos != -1 && re.find(pos)) {
            AbstractBlockMarker newBlockMarker = null;
            if (re.group(2) != null) {
                pos = re.end(2);
                String blockBeginStr = re.group(2);
                if (MODIFIER_RE.matcher(blockBeginStr).matches() && !this.isRubyExprBegin(unformatted, re.start(2), "modifier") || blockBeginStr.equals("do") && this.isNonBlockDo(unformatted, re.start(2))) continue;
                newBlockMarker = new BeginBlockMarker(re.group(2), re.start(2));
            } else if (re.group(5) != null) {
                pos = re.end(5);
                newBlockMarker = new MidBlockMarker(re.group(5), re.start(5));
            } else if (re.group(8) != null) {
                pos = re.end(8);
                newBlockMarker = new EndBlockMarker(re.group(8), re.start(8));
            } else if (re.group(10) != null) {
                String matchedLiteralBegin;
                block34: {
                    pos = re.end(10);
                    matchedLiteralBegin = re.group(10);
                    if (matchedLiteralBegin.startsWith("%")) {
                        boolean expand;
                        char delimitChar = matchedLiteralBegin.charAt(matchedLiteralBegin.length() - 1);
                        boolean bl = expand = matchedLiteralBegin.charAt(1) != 'q';
                        pos = delimitChar == '[' ? this.forwardString(unformatted, pos, '[', ']', expand) : (delimitChar == '(' ? this.forwardString(unformatted, pos, '(', ')', expand) : (delimitChar == '{' ? this.forwardString(unformatted, pos, '{', '}', expand) : (delimitChar == '<' ? this.forwardString(unformatted, pos, '<', '>', expand) : unformatted.indexOf(delimitChar, pos))));
                    } else if (matchedLiteralBegin.startsWith("/")) {
                        int posNextLine;
                        int posClosingSlash = this.forwardString(unformatted, pos, ' ', "/", true);
                        if (posClosingSlash == pos || (posNextLine = unformatted.indexOf("\n", pos)) != -1 && posClosingSlash > posNextLine) continue;
                        pos = posClosingSlash;
                    } else if (matchedLiteralBegin.startsWith("'")) {
                        if (pos > 1 && unformatted.charAt(pos - 2) == '$') continue;
                        pos = this.forwardString(unformatted, pos, ' ', "'", true);
                    } else {
                        if (matchedLiteralBegin.startsWith("<<")) {
                            boolean isMinus;
                            int startId = 2;
                            int endId = matchedLiteralBegin.length();
                            boolean bl = isMinus = matchedLiteralBegin.charAt(startId) == '-';
                            if (isMinus) {
                                ++startId;
                            }
                            if (startId < matchedLiteralBegin.length() - 1 && matchedLiteralBegin.charAt(startId) == '\'') {
                                ++startId;
                                --endId;
                            }
                            String reStr = String.valueOf(isMinus ? "" : "\n") + matchedLiteralBegin.substring(startId, endId);
                            try {
                                Pattern idSearch = Pattern.compile(reStr);
                                Matcher matcher = idSearch.matcher(unformatted);
                                pos = matcher.find(pos) ? matcher.end(0) : -1;
                                break block34;
                            }
                            catch (PatternSyntaxException patternSyntaxException) {
                                continue;
                            }
                        }
                        int i = 0;
                        while (i < LITERAL_BEGIN_LITERALS.length) {
                            if (LITERAL_BEGIN_LITERALS[i].equals(matchedLiteralBegin)) {
                                Pattern matchEnd = LITERAL_END_RES_COMPILED[i];
                                pos = -1;
                                Matcher tmpMatch = matchEnd.matcher(unformatted);
                                if (!tmpMatch.find(re.end(10) - 1)) break;
                                pos = tmpMatch.end(0);
                                break;
                            }
                            ++i;
                        }
                    }
                }
                newBlockMarker = new NoFormattingMarker(matchedLiteralBegin, re.start(10));
                if (pos != -1) {
                    lastBlockMarker.setNext(newBlockMarker);
                    lastBlockMarker = newBlockMarker;
                    newBlockMarker = new NeutralMarker("", pos);
                }
            } else {
                String delimiter = re.group(0);
                if (delimiter.equals("#")) {
                    pos = unformatted.indexOf("\n", re.end(0));
                    continue;
                }
                if (delimiter.equals("{")) {
                    newBlockMarker = new BeginBlockMarker("{", re.start(0));
                } else if (delimiter.equals("}")) {
                    newBlockMarker = new EndBlockMarker("}", re.start(0));
                } else if (delimiter.equals("(")) {
                    newBlockMarker = new FixLengthMarker("(", re.start(0));
                } else if (delimiter.equals(")")) {
                    newBlockMarker = new NeutralMarker(")", re.start(0));
                }
                pos = re.end(0);
            }
            if (newBlockMarker == null) continue;
            if (lastBlockMarker != null) {
                lastBlockMarker.setNext(newBlockMarker);
            }
            lastBlockMarker = newBlockMarker;
        }
        return firstBlockMarker;
    }

    protected int forwardString(String unformatted, int pos, char opening, char closing, boolean expand) {
        return this.forwardString(unformatted, pos, opening, "\\" + opening + "\\" + closing, expand);
    }

    protected int forwardString(String unformatted, int pos, char opening, String term, boolean expand) {
        int n = 1;
        try {
            Pattern pat = Pattern.compile(expand ? "[" + term + "]|(#\\{)" : "[" + term + "]");
            Matcher re = pat.matcher(unformatted);
            while (re.find(pos) && n > 0) {
                if (re.group(1) != null) {
                    pos = this.forwardString(unformatted, re.end(1), '{', "\\{\\}", expand);
                    continue;
                }
                pos = re.end(0);
                if (pos > 2 && unformatted.charAt(pos - 2) == '\\' && unformatted.charAt(pos - 3) != '\\') continue;
                if (re.group(0).charAt(0) == opening) {
                    ++n;
                    continue;
                }
                --n;
            }
        }
        catch (PatternSyntaxException e) {
            e.printStackTrace();
        }
        return pos;
    }

    protected int skipCharsBackward(String unformatted, int pos) {
        do {
            if (pos == 0) {
                return 0;
            }
            if (unformatted.charAt(pos - 1) != '\n') continue;
            return pos;
        } while (unformatted.charAt(--pos) == '\t' || unformatted.charAt(pos) == ' ');
        return pos;
    }

    /*
     * Unable to fully structure code
     */
    protected int backToIndentation(String unformatted, int pos) {
        while (true) {
            if (pos == 0) {
                return 0;
            }
            if (unformatted.charAt(pos - 1) == '\n') ** GOTO lbl-1000
            --pos;
        }
        while (++pos != unformatted.length()) lbl-1000:
        // 2 sources

        {
            if (unformatted.charAt(pos) == '\t' || unformatted.charAt(pos) == ' ') continue;
        }
        return pos;
    }

    protected int posOfLineStart(String unformatted, int pos) {
        while (true) {
            if (pos == 0) {
                return 0;
            }
            if (unformatted.charAt(pos - 1) == '\n') break;
            --pos;
        }
        return pos;
    }

    protected boolean matchREBackward(String str, Pattern re) {
        int pos = str.length() - 1;
        while (pos >= 0) {
            if (str.charAt(pos) == ';') {
                return false;
            }
            if (re.matcher(str).find(pos)) {
                return true;
            }
            --pos;
        }
        return false;
    }

    protected boolean isRubyExprBegin(String unformatted, int pos, String option) {
        int firstNonSpaceCharInLine = this.skipCharsBackward(unformatted, pos);
        if (firstNonSpaceCharInLine == 0 || unformatted.charAt(firstNonSpaceCharInLine - 1) == '\n') {
            return true;
        }
        char c = unformatted.charAt(firstNonSpaceCharInLine);
        if (c == ';') {
            return true;
        }
        String c_str = "" + c;
        return OPERATOR_RE.matcher(c_str).matches();
    }

    protected boolean isNonBlockDo(String unformatted, int pos) {
        int lineStart = this.posOfLineStart(unformatted, pos);
        return this.matchREBackward(unformatted.substring(lineStart, pos), NON_BLOCK_DO_RE);
    }

    public TextEdit format(int kind, String source, int offset, int length, int indentationLevel, String lineSeparator) {
        String newText = this.formatString(source.substring(offset, length), indentationLevel);
        return new ReplaceEdit(offset, length, newText);
    }

    public String formatString(String unformatted, int indentationLevel) {
        AbstractBlockMarker firstAbstractBlockMarker = this.createBlockMarkerList(unformatted);
        if (this.isDebug()) {
            firstAbstractBlockMarker.print();
        }
        try {
            return this.formatString(unformatted, firstAbstractBlockMarker, indentationLevel);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return unformatted;
        }
    }
}

