/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.core.model;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.dbgp.IDbgpNotification;
import org.eclipse.dltk.dbgp.IDbgpNotificationListener;
import org.eclipse.dltk.dbgp.IDbgpSession;
import org.eclipse.dltk.dbgp.IDbgpStatus;
import org.eclipse.dltk.dbgp.breakpoints.IDbgpBreakpoint;
import org.eclipse.dltk.dbgp.commands.IDbgpExtendedCommands;
import org.eclipse.dltk.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.debug.core.eval.IScriptEvaluationEngine;
import org.eclipse.dltk.debug.core.model.IScriptDebugTarget;
import org.eclipse.dltk.debug.core.model.IScriptThread;
import org.eclipse.dltk.internal.debug.core.eval.ScriptEvaluationEngine;
import org.eclipse.dltk.internal.debug.core.model.DebugEventHelper;
import org.eclipse.dltk.internal.debug.core.model.IScriptThreadStreamProxy;
import org.eclipse.dltk.internal.debug.core.model.IThreadManagement;
import org.eclipse.dltk.internal.debug.core.model.ScriptDebugElement;
import org.eclipse.dltk.internal.debug.core.model.ScriptStack;
import org.eclipse.dltk.internal.debug.core.model.ScriptThreadManager;
import org.eclipse.dltk.internal.debug.core.model.operations.DbgpDebugger;
import org.eclipse.dltk.internal.debug.core.model.operations.IDbgpDebuggerFeedback;

public class ScriptThread
extends ScriptDebugElement
implements IScriptThread,
IThreadManagement,
IDbgpDebuggerFeedback {
    private static final IStackFrame[] NO_STACK_FRAMES = new IStackFrame[0];
    private int suspendCount;
    private final boolean canSuspend;
    private final ScriptThreadManager manager;
    private final IScriptThreadStreamProxy streamProxy;
    private final ScriptStack stack;
    private final DbgpDebugger engine;
    private final IDbgpSession session;
    private volatile boolean stepping;
    private volatile boolean suspended;
    private volatile boolean terminated;
    private final IScriptDebugTarget target;
    private IScriptEvaluationEngine evalEngine;

    private IDbgpStatus stopDebugger() throws DbgpException {
        return this.session.getCoreCommands().stop();
    }

    protected void processOperationEnd(DbgpException exception, IDbgpStatus status, int suspendDetail) {
        try {
            if (exception != null) {
                throw exception;
            }
            if (status.isBreak()) {
                this.stack.update();
                this.setSuspended(true, suspendDetail);
            } else if (status.isStopping()) {
                if (this.stopDebugger().isStopped()) {
                    this.setTerminated();
                }
            } else if (status.isStopped()) {
                this.setTerminated();
            }
        }
        catch (DbgpException e) {
            try {
                this.streamProxy.getStdout().write(e.getMessage().getBytes());
                this.setTerminated();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    protected boolean canStep() {
        return !this.isTerminated() && this.isSuspended();
    }

    protected void beginStep(int detail) {
        this.stepping = true;
        this.setSuspended(false, detail);
    }

    protected void endStep(DbgpException execption, IDbgpStatus status) {
        this.stepping = false;
        this.processOperationEnd(execption, status, 8);
    }

    public ScriptThread(IScriptDebugTarget target, IDbgpSession session, ScriptThreadManager manager) throws DbgpException, CoreException {
        this.target = target;
        this.manager = manager;
        this.streamProxy = target.getStreamManager().makeThreadStreamProxy();
        this.session = session;
        this.suspendCount = 0;
        this.suspended = true;
        this.terminated = false;
        this.stepping = this.suspended;
        this.engine = new DbgpDebugger(this, this);
        if (DLTKCore.DEBUG) {
            DbgpDebugger.printEngineInfo(this.engine);
        }
        final IDbgpExtendedCommands extended = session.getExtendedCommands();
        this.canSuspend = true;
        this.engine.setMaxChildren(256);
        this.engine.setMaxDepth(2);
        this.engine.setMaxData(8192);
        this.engine.redirectStdin();
        this.engine.setNotifyOk(true);
        this.engine.redirectStdout();
        this.engine.redirectStderr();
        session.getNotificationManager().addNotificationListener(new IDbgpNotificationListener(){
            private final BufferedReader reader;
            {
                this.reader = new BufferedReader(new InputStreamReader(ScriptThread.this.getStreamProxy().getStdin()));
            }

            public void dbgpNotify(IDbgpNotification notification) {
                try {
                    extended.sendStdin(String.valueOf(this.reader.readLine()) + "\n");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (DbgpException e) {
                    e.printStackTrace();
                }
            }
        });
        this.stack = new ScriptStack(this);
    }

    public boolean hasStackFrames() throws DebugException {
        return this.stack.hasFrames();
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        if (!this.isSuspended()) {
            return NO_STACK_FRAMES;
        }
        return this.stack.getFrames();
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        return this.stack.getTopFrame();
    }

    public String getName() throws DebugException {
        return this.session.getInfo().getThreadId();
    }

    public IBreakpoint[] getBreakpoints() {
        return DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(this.getModelIdentifier());
    }

    protected void setSuspended(boolean value, int detail) {
        this.suspended = value;
        if (value) {
            ++this.suspendCount;
            DebugEventHelper.fireSuspendEvent(this, detail);
        } else {
            DebugEventHelper.fireResumeEvent(this, detail);
            DebugEventHelper.fireChangeEvent(this);
        }
    }

    protected void setTerminated() {
        this.terminated = true;
        this.session.requestTermination();
        this.manager.terminateThread(this);
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public boolean canSuspend() {
        return this.canSuspend && !this.isTerminated() && !this.isSuspended();
    }

    public void endSuspend(DbgpException e, IDbgpStatus status) {
        this.processOperationEnd(e, status, 32);
    }

    public void suspend() throws DebugException {
        this.setSuspended(true, 32);
        this.engine.suspend();
    }

    public boolean canResume() {
        return !this.isTerminated() && this.isSuspended();
    }

    public void endResume(DbgpException e, IDbgpStatus status) {
        this.processOperationEnd(e, status, 16);
    }

    public void resume() throws DebugException {
        this.setSuspended(false, 32);
        this.engine.resume();
    }

    public boolean isStepping() {
        return !this.isTerminated() && this.stepping;
    }

    public boolean canStepInto() {
        return this.canStep();
    }

    public void endStepInto(DbgpException e, IDbgpStatus status) {
        this.endStep(e, status);
    }

    public void stepInto() throws DebugException {
        this.beginStep(1);
        this.engine.stepInto();
    }

    public boolean canStepOver() {
        return this.canStep();
    }

    public void endStepOver(DbgpException e, IDbgpStatus status) {
        this.endStep(e, status);
    }

    public void stepOver() throws DebugException {
        this.beginStep(2);
        this.engine.stepOver();
    }

    public boolean canStepReturn() {
        return this.canStep();
    }

    public void endStepReturn(DbgpException e, IDbgpStatus status) {
        this.endStep(e, status);
    }

    public void stepReturn() throws DebugException {
        this.beginStep(4);
        this.engine.stepReturn();
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public void endTerminate(DbgpException e, IDbgpStatus status) {
        this.processOperationEnd(e, status, 32);
    }

    public void terminate() throws DebugException {
        this.engine.terminate();
    }

    public boolean canTerminateEvaluation() {
        return false;
    }

    public IDbgpSession getDbgpSession() {
        return this.session;
    }

    public IDbgpBreakpoint getDbgpBreakpoint(String id) {
        try {
            return this.session.getCoreCommands().getBreakpoint(id);
        }
        catch (DbgpException e) {
            e.printStackTrace();
            return null;
        }
    }

    public IScriptThreadStreamProxy getStreamProxy() {
        return this.streamProxy;
    }

    public String toString() {
        return "Thread (" + this.session.getInfo().getThreadId() + ")";
    }

    public IDebugTarget getDebugTarget() {
        return this.target.getDebugTarget();
    }

    public IScriptEvaluationEngine getEvaluationEngine() {
        if (this.evalEngine == null) {
            this.evalEngine = new ScriptEvaluationEngine(this);
        }
        return this.evalEngine;
    }

    public int getSuspendCount() {
        return this.suspendCount;
    }
}

