/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.documentation;

import java.io.Reader;
import java.io.StringReader;
import org.eclipse.dltk.core.IBuffer;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.ui.documentation.IScriptDocumentationProvider;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;

public class TclCommentDocumentationProvider
implements IScriptDocumentationProvider {
    protected String getLine(Document d, int line) throws BadLocationException {
        return d.get(d.getLineOffset(line), d.getLineLength(line));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getHeaderComment(IMember member) {
        if (member instanceof IField) {
            return null;
        }
        try {
            ISourceRange range = member.getSourceRange();
            if (range == null) {
                return null;
            }
            IBuffer buf = null;
            ISourceModule compilationUnit = member.getSourceModule();
            if (!compilationUnit.isConsistent()) {
                return null;
            }
            buf = compilationUnit.getBuffer();
            int start = range.getOffset();
            String contents = buf.getContents();
            String result = "";
            Document doc = new Document(contents);
            try {
                int line = doc.getLineOfOffset(start);
                if (--line < 0) {
                    return null;
                }
                boolean emptyEnd = true;
                while (true) {
                    if (line < 0) {
                        return result;
                    }
                    String curLine = this.getLine(doc, line);
                    String curLineTrimmed = curLine.trim();
                    if (curLineTrimmed.length() != 0 || !emptyEnd) {
                        if (!curLineTrimmed.startsWith("#")) return result;
                    }
                    if (curLineTrimmed.length() != 0) {
                        emptyEnd = false;
                    }
                    result = String.valueOf(curLine) + result;
                    --line;
                }
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        catch (ModelException modelException) {
            return null;
        }
    }

    public Reader getInfo(IMember member, boolean lookIntoParents, boolean lookIntoExternal) {
        String header = this.getHeaderComment(member);
        return new StringReader(this.convertToHTML(header));
    }

    /*
     * Unable to fully structure code
     */
    protected String convertToHTML(String header) {
        result = new StringBuffer();
        d = new Document(header);
        line = 0;
        while (true) {
            try {
                str = this.getLine(d, line).trim();
                if (str != null) ** GOTO lbl10
                break;
lbl-1000:
                // 1 sources

                {
                    str = str.substring(1);
lbl10:
                    // 2 sources

                    ** while (str.length() > 0 && str.startsWith((String)"#"))
                }
lbl11:
                // 2 sources

                while (str.length() > 0 && str.endsWith("#")) {
                    str = str.substring(0, str.length() - 1);
                }
                if (str.length() == 0) {
                    result.append("<p>");
                } else if (str.trim().matches("\\w*:")) {
                    result.append("<h4>");
                    result.append(str);
                    result.append("</h4>");
                } else {
                    result.append(String.valueOf(str) + "<br>");
                }
            }
            catch (BadLocationException v0) {
                break;
            }
            ++line;
        }
        return result.toString();
    }

    public Reader getInfo(String content) {
        return null;
    }
}

