/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.ui.launchConfigurations;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.dltk.debug.ui.actions.ControlAccessibleListener;
import org.eclipse.dltk.debug.ui.launchConfigurations.CommonScriptLaunchTab;
import org.eclipse.dltk.debug.ui.messages.DLTKLaunchMessages;
import org.eclipse.dltk.internal.debug.ui.ScriptDebugImages;
import org.eclipse.dltk.internal.debug.ui.launcher.InterpreterArgumentsBlock;
import org.eclipse.dltk.internal.debug.ui.launcher.WorkingDirectoryBlock;
import org.eclipse.dltk.internal.launching.DLTKLaunchingPlugin;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ScriptArgumentsTab
extends CommonScriptLaunchTab {
    protected Label fPrgmArgumentsLabel;
    protected Text fPrgmArgumentsText;
    protected InterpreterArgumentsBlock fInterpreterArgumentsBlock = this.createInterpreterArgsBlock();
    protected WorkingDirectoryBlock fWorkingDirectoryBlock = this.createWorkingDirBlock();
    protected static final String EMPTY_STRING = "";

    protected InterpreterArgumentsBlock createInterpreterArgsBlock() {
        return new InterpreterArgumentsBlock();
    }

    protected WorkingDirectoryBlock createWorkingDirBlock() {
        return new WorkingDirectoryBlock();
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        comp.setLayout((Layout)layout);
        comp.setFont(font);
        GridData gd = new GridData(1808);
        comp.setLayoutData((Object)gd);
        this.setControl((Control)comp);
        this.setHelpContextId();
        Group group = new Group(comp, 0);
        group.setFont(font);
        layout = new GridLayout();
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(1808));
        String controlName = DLTKLaunchMessages.ArgumentsTab__Program_arguments__5;
        group.setText(controlName);
        this.fPrgmArgumentsText = new Text((Composite)group, 2626);
        gd = new GridData(1808);
        gd.heightHint = 40;
        gd.widthHint = 100;
        this.fPrgmArgumentsText.setLayoutData((Object)gd);
        this.fPrgmArgumentsText.setFont(font);
        this.fPrgmArgumentsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                ScriptArgumentsTab.this.updateLaunchConfigurationDialog();
            }
        });
        ControlAccessibleListener.addListener((Control)this.fPrgmArgumentsText, group.getText());
        String buttonLabel = DLTKLaunchMessages.ArgumentsTab_5;
        Button pgrmArgVariableButton = this.createPushButton((Composite)group, buttonLabel, null);
        pgrmArgVariableButton.setLayoutData((Object)new GridData(128));
        pgrmArgVariableButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(ScriptArgumentsTab.this.getShell());
                dialog.open();
                String variable = dialog.getVariableExpression();
                if (variable != null) {
                    ScriptArgumentsTab.this.fPrgmArgumentsText.insert(variable);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (this.fInterpreterArgumentsBlock != null) {
            this.fInterpreterArgumentsBlock.createControl(comp);
        }
        this.fWorkingDirectoryBlock.createControl(comp);
    }

    protected void setHelpContextId() {
    }

    public void dispose() {
    }

    public boolean isValid(ILaunchConfiguration config) {
        return this.fWorkingDirectoryBlock.isValid(config);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("scriptArguments", null);
        if (this.fInterpreterArgumentsBlock != null) {
            this.fInterpreterArgumentsBlock.setDefaults(config);
        }
        this.fWorkingDirectoryBlock.setDefaults(config);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.fPrgmArgumentsText.setText(configuration.getAttribute("scriptArguments", EMPTY_STRING));
            if (this.fInterpreterArgumentsBlock != null) {
                this.fInterpreterArgumentsBlock.initializeFrom(configuration);
            }
            this.fWorkingDirectoryBlock.initializeFrom(configuration);
        }
        catch (CoreException e) {
            this.setErrorMessage(String.valueOf(DLTKLaunchMessages.ArgumentsTab_Exception_occurred_reading_configuration___15) + e.getStatus().getMessage());
            DLTKLaunchingPlugin.log((Throwable)e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("scriptArguments", this.getAttributeValueFrom(this.fPrgmArgumentsText));
        if (this.fInterpreterArgumentsBlock != null) {
            this.fInterpreterArgumentsBlock.performApply(configuration);
        }
        this.fWorkingDirectoryBlock.performApply(configuration);
    }

    protected String getAttributeValueFrom(Text text) {
        String content = text.getText().trim();
        if (content.length() > 0) {
            return content;
        }
        return null;
    }

    public String getName() {
        return DLTKLaunchMessages.ArgumentsTab__Arguments_16;
    }

    public void setLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
        super.setLaunchConfigurationDialog(dialog);
        this.fWorkingDirectoryBlock.setLaunchConfigurationDialog(dialog);
        if (this.fInterpreterArgumentsBlock != null) {
            this.fInterpreterArgumentsBlock.setLaunchConfigurationDialog(dialog);
        }
    }

    public String getErrorMessage() {
        String m = super.getErrorMessage();
        if (m == null) {
            return this.fWorkingDirectoryBlock.getErrorMessage();
        }
        return m;
    }

    public String getMessage() {
        String m = super.getMessage();
        if (m == null) {
            return this.fWorkingDirectoryBlock.getMessage();
        }
        return m;
    }

    public Image getImage() {
        return ScriptDebugImages.get("IMG_VIEW_ARGUMENTS_TAB");
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        this.fWorkingDirectoryBlock.initializeFrom((ILaunchConfiguration)workingCopy);
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }
}

