/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.ui.tests.text;

import org.eclipse.dltk.core.tests.model.SuiteOfTestCases;
import org.eclipse.dltk.ruby.core.text.RubyContext;
import org.eclipse.dltk.ruby.internal.ui.text.syntax.RubyContextUtils;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;

public class ContextTest
extends SuiteOfTestCases {
    public ContextTest(String name) {
        super(name);
    }

    public RubyContext.HeuristicLookupResult doTest(String data, RubyContext expected, int inside) throws Exception {
        Document doc = new Document(data);
        RubyContext.HeuristicLookupResult result = RubyContext.determineContext((CharSequence)RubyContextUtils.createDocumentAdapter((IDocument)doc), (int)doc.getLength(), (int)0);
        ContextTest.assertEquals((String)expected.toString(), (String)result.context.toString());
        ContextTest.assertEquals((int)inside, (int)result.inside);
        return result;
    }

    public void testEmpty() throws Exception {
        this.doTest("", RubyContext.COMMAND_START, 0);
    }

    public void testDirectOperand() throws Exception {
        this.doTest("2 + 3 + ", RubyContext.EXPRESSION_START, 0);
    }

    public void testDirectOperator() throws Exception {
        this.doTest("2 + 3", RubyContext.AFTER_EXPRESSION, 6);
    }

    public void testPrevLineOperand() throws Exception {
        this.doTest("puts 2 + 3 +\n", RubyContext.EXPRESSION_START, 0);
    }

    public void testContinuedOperator() throws Exception {
        this.doTest("puts 2 + 3 \\\n", RubyContext.AFTER_EXPRESSION, 6);
    }

    public void testContinuedOperand() throws Exception {
        this.doTest("puts 2 + \\\n", RubyContext.EXPRESSION_START, 0);
    }

    public void testNewLineStatement() throws Exception {
        this.doTest("puts 2 + 3\n", RubyContext.COMMAND_START, 0);
    }

    public void testSemicolonStatement() throws Exception {
        this.doTest("puts 2 + 3; ", RubyContext.COMMAND_START, 0);
    }

    public void testFunctionCallOperator() throws Exception {
        this.doTest("foo ", RubyContext.ARGUMENT_OR_AFTER_EXPRESSION, 4);
    }

    public void testSpecialFunctionCallOperator() throws Exception {
        this.doTest("foo.gsub ", RubyContext.ARGUMENT, 4);
    }

    public void testReturnOperator() throws Exception {
        this.doTest("return ", RubyContext.KEYWORD_ARGUMENT, 4);
    }

    public void testIfOperand() throws Exception {
        this.doTest("if ", RubyContext.EXPRESSION_START, 4);
    }

    public void testBeginStatement() throws Exception {
        this.doTest("begin ", RubyContext.COMMAND_START, 4);
    }

    public void testMethodCallDot() throws Exception {
        this.doTest("foo.", RubyContext.AFTER_DOT, 0);
    }

    public void testNamespaceResolution() throws Exception {
        this.doTest("Foo::", RubyContext.AFTER_DOT, 0);
    }

    public void testSymbol() throws Exception {
        this.doTest(":", RubyContext.AFTER_DOT, 0);
    }

    public void testMethodDefinition() throws Exception {
        this.doTest("def ", RubyContext.NAME, 4);
    }

    public void testClassDefinition() throws Exception {
        this.doTest("class ", RubyContext.NAME, 4);
    }

    public void testModuleDefinition() throws Exception {
        this.doTest("module ", RubyContext.EXPRESSION_START, 4);
    }

    public void testInsideGlobalVariable() throws Exception {
        this.doTest("$foo", RubyContext.AFTER_EXPRESSION, 1);
    }

    public void testInsideClassVariable() throws Exception {
        this.doTest("@@foo", RubyContext.AFTER_EXPRESSION, 3);
    }

    public void testInsideInstanceVariable() throws Exception {
        this.doTest("@foo", RubyContext.AFTER_EXPRESSION, 2);
    }
}

